/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.DialogProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.metadata.MetadataViewTopComponent;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SelectExportMethodDialog;
import org.esa.snap.ui.UIUtils;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportMetadataAction
extends AbstractAction
implements HelpCtx.Provider,
LookupListener,
ContextAwareAction {
    private static final String ERR_MSG_BASE = "Metadata could not be exported:\n";
    private static final String DLG_TITLE = "Export Product Metadata";
    private final Lookup.Result<MetadataElement> result;
    private final Lookup lookup;
    private MetadataElement productMetadata;

    public ExportMetadataAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportMetadataAction(Lookup lookup) {
        super(Bundle.CTL_ExportMetadataAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(MetadataElement.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    private static String getWindowTitle() {
        return SnapApp.getDefault().getInstanceName() + " - " + DLG_TITLE;
    }

    private static File promptForFile(String defaultFileName) {
        File file = null;
        while (file == null) {
            file = Dialogs.requestFileForSave(DLG_TITLE, false, null, ".txt", defaultFileName, null, "exportMetadata.lastDir");
            if (file == null) {
                return null;
            }
            if (!file.exists()) continue;
            int status = JOptionPane.showConfirmDialog(SnapApp.getDefault().getMainFrame(), "The file '" + file + "' already exists.\nOverwrite it?", MessageFormat.format("{0} - {1}", SnapApp.getDefault().getInstanceName(), DLG_TITLE), 1, 2);
            if (status == 2) {
                return null;
            }
            if (status != 1) continue;
            file = null;
        }
        return file;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.exportMetadata();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Bundle.CTL_ExportMetadataAction_MenuText());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ExportMetadataAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        MetadataElement metadataElement = (MetadataElement)this.lookup.lookup(MetadataElement.class);
        this.setEnabled(metadataElement != null);
    }

    private void exportMetadata() {
        StringBuffer clipboardText;
        PrintWriter out;
        this.productMetadata = (MetadataElement)this.lookup.lookup(MetadataElement.class);
        String msgText = "How do you want to export the metadata?\n" + this.productMetadata.getName() + "Element  will be exported.\n";
        int method = SelectExportMethodDialog.run((Component)SnapApp.getDefault().getMainFrame(), (String)ExportMetadataAction.getWindowTitle(), (String)msgText, (String)this.getHelpCtx().getHelpID());
        int initialBufferSize = 256000;
        if (method == 0) {
            StringWriter stringWriter = new StringWriter(256000);
            out = new PrintWriter(stringWriter);
            clipboardText = stringWriter.getBuffer();
        } else if (method == 1) {
            FileWriter fileWriter;
            MetadataViewTopComponent metadataViewTopComponent = new MetadataViewTopComponent(this.productMetadata);
            File file = ExportMetadataAction.promptForFile(this.createDefaultFileName(metadataViewTopComponent));
            if (file == null) {
                return;
            }
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                Dialogs.showError(DLG_TITLE, "Metadata could not be exported:\nFailed to create file '" + file + "':\n" + e.getMessage());
                return;
            }
            out = new PrintWriter(new BufferedWriter(fileWriter, 256000));
            clipboardText = null;
        } else {
            return;
        }
        SwingWorker<Exception, Object> swingWorker = new SwingWorker<Exception, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Exception doInBackground() throws Exception {
                Exception returnValue = null;
                try {
                    DialogProgressMonitor pm = new DialogProgressMonitor((Component)SnapApp.getDefault().getMainFrame(), ExportMetadataAction.DLG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
                    MetadataExporter exporter = new MetadataExporter(ExportMetadataAction.this.productMetadata);
                    boolean success = exporter.exportMetadata(out, (ProgressMonitor)pm);
                    if (success && clipboardText != null) {
                        SystemUtils.copyToClipboard((String)clipboardText.toString());
                        clipboardText.setLength(0);
                    }
                }
                catch (Exception e) {
                    returnValue = e;
                }
                finally {
                    out.close();
                }
                return returnValue;
            }

            @Override
            public void done() {
                Exception exception;
                SnapApp.getDefault().setStatusBarMessage("");
                UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                try {
                    exception = (Exception)this.get();
                }
                catch (Exception e) {
                    exception = e;
                }
                if (exception != null) {
                    Dialogs.showError(ExportMetadataAction.DLG_TITLE, ExportMetadataAction.ERR_MSG_BASE + exception.getMessage());
                }
            }
        };
        SnapApp.getDefault().setStatusBarMessage("Exporting Product Metadata...");
        swingWorker.execute();
    }

    private String createDefaultFileName(MetadataViewTopComponent productMetadataView) {
        return FileUtils.getFilenameWithoutExtension((String)((MetadataElement)productMetadataView.getDocument()).getProduct().getName()) + "_" + this.productMetadata.getName() + ".txt";
    }

    private static class MetadataExporter {
        private final MetadataElement rootElement;

        private MetadataExporter(MetadataElement rootElement) {
            this.rootElement = rootElement;
        }

        public boolean exportMetadata(PrintWriter out, ProgressMonitor pm) {
            pm.beginTask("Export Metadata", 1);
            try {
                this.writeHeaderLine(out);
                this.writeAttributes(out, this.rootElement);
                pm.worked(1);
            }
            finally {
                pm.done();
            }
            return true;
        }

        private void writeHeaderLine(PrintWriter out) {
            out.print("Value\t");
            out.print("Type\t");
            out.print("Unit\t");
            out.print("Description\t\n");
        }

        private void writeAttributes(PrintWriter out, MetadataElement element) {
            MetadataElement[] subElements;
            MetadataAttribute[] attributes;
            for (MetadataAttribute attribute : attributes = element.getAttributes()) {
                out.print(this.createAttributeName(attribute) + "\t");
                out.print(attribute.getData().getElemString() + "\t");
                out.print(attribute.getUnit() + "\t");
                out.print(attribute.getDescription() + "\t\n");
            }
            for (MetadataElement subElement : subElements = element.getElements()) {
                this.writeAttributes(out, subElement);
            }
        }

        private String createAttributeName(MetadataAttribute attribute) {
            StringBuilder sb = new StringBuilder();
            MetadataElement metadataElement = attribute.getParentElement();
            if (metadataElement != null) {
                this.prependParentName(metadataElement, sb);
            }
            sb.append(attribute.getName());
            return sb.toString();
        }

        private void prependParentName(MetadataElement element, StringBuilder sb) {
            MetadataElement owner = element.getParentElement();
            if (owner != null) {
                if (owner != this.rootElement) {
                    this.prependParentName(owner, sb);
                } else if (owner.getName() != null) {
                    sb.insert(0, owner.getName()).append(".");
                }
            }
            if (element.getName() != null) {
                sb.append(element.getName()).append(".");
            }
        }
    }
}

