/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.popup;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import sun.awt.EmbeddedFrame;

public class JidePopup
extends JComponent
implements Accessible,
WindowConstants {
    public static final String CLIENT_PROPERTY_WINDOW_OPACITY = "windowOpacity";
    public static final String CLIENT_PROPERTY_WINDOW_OPAQUE = "windowOpaque";
    public static final String CLIENT_PROPERTY_WINDOW_SHAPE = "windowShape";
    private static final String uiClassID = "JidePopupUI";
    private JRootPane rootPane;
    private boolean rootPaneCheckingEnabled = false;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String TRANSIENT_PROPERTY = "transient";
    public static final String ATTACHABLE_PROPERTY = "attachable";
    private boolean _attachable = true;
    public static final String MOVABLE_PROPERTY = "movable";
    private boolean _movable = false;
    private boolean _returnFocusToOwner = true;
    public static final String DETACHED_PROPERTY = "detached";
    public static final String CLIENT_PROPERTY_POPUP_TYPE = "popupType";
    public static final String CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX = "comboBox";
    protected boolean _detached;
    protected ResizableWindow _window;
    protected ResizablePanel _panel;
    protected ResizableSupport _resizableSupport;
    private ComponentAdapter _componentListener;
    private WindowAdapter _windowListener;
    private ComponentAdapter _ownerComponentListener;
    private HierarchyListener _hierarchyListener;
    private Point _displayStartLocation;
    public static final String CLIENT_PROPERTY_POPUP_ACTUAL_OWNER = "JidePopup.actualOwner";
    public static final String RESIZABLE_PROPERTY = "resizable";
    private boolean _resizable = true;
    private boolean _keepPreviousSize = true;
    public static final String OWNER_PROPERTY = "owner";
    private Component _owner;
    private Border _popupBorder;
    private boolean _transient = true;
    private int _timeout = 0;
    private Timer _timer;
    private Component _defaultFocusComponent;
    public static final int DO_NOTHING_ON_MOVED = -1;
    public static final int HIDE_ON_MOVED = 0;
    public static final int MOVE_ON_MOVED = 1;
    private int _defaultMoveOperation = 0;
    public int DISTANCE_TO_SCREEN_BORDER = 10;
    private List<Component> _excludedComponents;
    private int _gripperLocation = 1;
    public static final String PROPERTY_GRIPPER_LOCATION = "gripperLocation";
    private ComponentAdapter _popupResizeListener;
    protected Dimension _previousSize;
    protected Component _actualOwner;
    protected Point _actualOwnerLocation;
    public static final int LIGHT_WEIGHT_POPUP = 0;
    public static final int HEAVY_WEIGHT_POPUP = 2;
    private int _popupType = 2;
    private ActionListener _escapeActionListener;
    private Object HIDE_POPUP_KEY = null;
    protected Insets _insets = null;
    private boolean _isDragging = false;
    private double _relativeX;
    private double _relativeY;
    private Point _startPoint;
    private Window _currentWindow;
    private JPanel _currentPanel;
    private Insets _backToOriginalInsets = new Insets(10, 10, 10, 10);
    private AWTEventListener _awtEventListener;
    private static boolean checkedUnpostPopup;
    private static boolean unpostPopup;

    public JidePopup() {
        this._excludedComponents = new ArrayList<Component>();
        this.setRootPane(this.createRootPane());
        this.setLayout(new BorderLayout());
        this.setRootPaneCheckingEnabled(true);
        this.setFocusable(false);
        this.updateUI();
        this.initHidePopupProperty();
    }

    private void initHidePopupProperty() {
        Component[] components;
        JComboBox comboBox = new JComboBox();
        comboBox.setEnabled(this.isEnabled());
        comboBox.setEditable(true);
        comboBox.doLayout();
        for (Component component : components = comboBox.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            this.HIDE_POPUP_KEY = ((AbstractButton)component).getClientProperty("doNotCancelPopup");
            break;
        }
    }

    protected JRootPane createRootPane() {
        JRootPane pane = new JRootPane();
        pane.getContentPane().setLayout(new BorderLayout());
        pane.setOpaque(false);
        return pane;
    }

    public PopupUI getUI() {
        return (PopupUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(PopupUI ui) {
        boolean checkingEnabled = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(ui);
        }
        finally {
            this.setRootPaneCheckingEnabled(checkingEnabled);
        }
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void remove(Component comp) {
        int oldCount = this.getComponentCount();
        super.remove(comp);
        if (oldCount == this.getComponentCount()) {
            this.getContentPane().remove(comp);
        }
    }

    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar m) {
        JMenuBar oldValue = this.getJMenuBar();
        this.getRootPane().setJMenuBar(m);
        this.firePropertyChange(MENU_BAR_PROPERTY, oldValue, m);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container c) {
        Container oldValue = this.getContentPane();
        this.getRootPane().setContentPane(c);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, oldValue, c);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane layered) {
        JLayeredPane oldValue = this.getLayeredPane();
        this.getRootPane().setLayeredPane(layered);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, oldValue, layered);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component glass) {
        Component oldValue = this.getGlassPane();
        this.getRootPane().setGlassPane(glass);
        this.firePropertyChange(GLASS_PANE_PROPERTY, oldValue, glass);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.rootPane.removeAll();
            this.remove(this.rootPane);
        }
        JRootPane oldValue = this.getRootPane();
        this.rootPane = root;
        if (this.rootPane != null) {
            boolean checkingEnabled = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(checkingEnabled);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, oldValue, root);
    }

    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        if (visible != old) {
            super.setVisible(visible);
            this.firePropertyChange(VISIBLE_PROPERTY, old, visible);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopup();
        }
        return this.accessibleContext;
    }

    public boolean isKeepPreviousSize() {
        return this._keepPreviousSize;
    }

    public void setKeepPreviousSize(boolean keepPreviousSize) {
        this._keepPreviousSize = keepPreviousSize;
    }

    public Insets getBackToOriginalInsets() {
        return this._backToOriginalInsets;
    }

    public void setBackToOriginalInsets(Insets backToOriginalInsets) {
        this._backToOriginalInsets = backToOriginalInsets;
    }

    public void showPopup() {
        this.showPopup(new Insets(0, 0, 0, 0), null);
    }

    public void showPopup(Component owner) {
        this.showPopup(new Insets(0, 0, 0, 0), owner);
    }

    public void showPopup(Insets insets) {
        this.showPopup(insets, null);
    }

    public void showPopup(Insets insets, Component owner) {
        Component actualOwner;
        this._insets = insets;
        Component component = actualOwner = owner != null ? owner : this.getOwner();
        if (actualOwner != null && actualOwner.isShowing()) {
            Point point = actualOwner.getLocationOnScreen();
            this.internalShowPopup(point.x, point.y, actualOwner);
        } else {
            this.showPopup(0);
        }
    }

    protected Point getPopupLocation(Point point, Dimension size, Component owner) {
        Dimension ownerSize;
        Component actualOwner = owner != null ? owner : this.getOwner();
        Dimension dimension = ownerSize = actualOwner != null ? actualOwner.getSize() : new Dimension(0, 0);
        if (size.width == 0) {
            size = this.getPreferredSize();
        }
        Point p = new Point(point.x + this._insets.left, point.y + ownerSize.height - this._insets.bottom);
        int left = p.x + size.width;
        int bottom = p.y + size.height;
        Rectangle screenBounds = PortingUtils.getContainingScreenBounds(new Rectangle(p, size), true);
        if (bottom > screenBounds.y + screenBounds.height) {
            p.y = point.y + this._insets.top - size.height;
            if (p.y < screenBounds.y) {
                p.y = screenBounds.y;
            }
            if (this.isResizable()) {
                this.setupResizeCorner(4);
            }
        } else if (this.isResizable()) {
            this.setupResizeCorner(16);
        }
        Rectangle bounds = PortingUtils.containsInScreenBounds(actualOwner, new Rectangle(p, size));
        p.x = bounds.x;
        p.y = bounds.y;
        return p;
    }

    public void setupResizeCorner(int corner) {
        switch (corner) {
            case 4: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(4);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                    public boolean condition(Component c) {
                        return c instanceof JideScrollPane;
                    }

                    public void action(Component c) {
                        Resizable.ResizeCorner corner = new Resizable.ResizeCorner(4);
                        corner.addMouseListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        corner.addMouseMotionListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)c).setScrollBarCorner("VERTICAL_TOP", corner);
                        ((JideScrollPane)c).setScrollBarCorner("VERTICAL_BOTTOM", null);
                    }

                    public void postAction(Component c) {
                    }
                });
                break;
            }
            case 16: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(16);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                    public boolean condition(Component c) {
                        return c instanceof JideScrollPane;
                    }

                    public void action(Component c) {
                        Resizable.ResizeCorner corner = new Resizable.ResizeCorner(16);
                        corner.addMouseListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        corner.addMouseMotionListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)c).setScrollBarCorner("VERTICAL_BOTTOM", corner);
                        ((JideScrollPane)c).setScrollBarCorner("VERTICAL_TOP", null);
                    }

                    public void postAction(Component c) {
                    }
                });
                break;
            }
            default: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(corner);
            }
        }
    }

    public static Component getTopLevelAncestor(Component component) {
        if (component == null) {
            return null;
        }
        for (Component p = component; p != null; p = p.getParent()) {
            if (!(p instanceof Window) && !(p instanceof Applet)) continue;
            return p;
        }
        return null;
    }

    public void showPopup(int location) {
        this.showPopup(location, null);
    }

    public void showPopup(int location, Component owner) {
        this.setDetached(true);
        Rectangle screenDim = this.getDisplayScreenBounds(owner);
        Dimension actualSize = this.getSize();
        Dimension size = actualSize.width == 0 ? this.getPreferredSize() : actualSize;
        Point displayLocation = this.getDisplayStartLocation(screenDim, size, location);
        this.internalShowPopup(displayLocation.x, displayLocation.y, owner);
    }

    public void setDisplayStartLocation(Point startLocation) {
        this._displayStartLocation = startLocation;
    }

    protected Point getDisplayStartLocation(Rectangle screenDim, Dimension size, int location) {
        if (this._displayStartLocation != null) {
            return this._displayStartLocation;
        }
        switch (location) {
            case 0: {
                return new Point(screenDim.x + (screenDim.width - size.width) / 2, screenDim.y + (screenDim.height - size.height) / 2);
            }
            case 5: {
                return new Point(screenDim.x + (screenDim.width - size.width) / 2, screenDim.y + screenDim.height - size.height - this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 1: {
                return new Point(screenDim.x + (screenDim.width - size.width) / 2, screenDim.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 3: {
                return new Point(screenDim.x + screenDim.width - size.width - this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + (screenDim.height - size.height) / 2);
            }
            case 7: {
                return new Point(screenDim.x + this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + (screenDim.height - size.height) / 2);
            }
            case 6: {
                return new Point(screenDim.x + this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + screenDim.height - size.height - this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 2: {
                return new Point(screenDim.x + screenDim.width - size.width - this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 8: {
                return new Point(screenDim.x + this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
        }
        return new Point(screenDim.x + screenDim.width - size.width - this.DISTANCE_TO_SCREEN_BORDER, screenDim.y + screenDim.height - size.height - this.DISTANCE_TO_SCREEN_BORDER);
    }

    protected Rectangle getDisplayScreenBounds(Component owner) {
        Rectangle screenDim;
        if (owner != null && owner.isShowing()) {
            screenDim = owner.getBounds();
            Point p = owner.getLocationOnScreen();
            screenDim.x = p.x;
            screenDim.y = p.y;
        } else {
            screenDim = this.getOwner() == null ? PortingUtils.getLocalScreenBounds() : PortingUtils.getScreenBounds(this.getOwner(), true);
        }
        return screenDim;
    }

    public void packPopup() {
        if (this._popupType == 0) {
            if (this._panel == null) {
                return;
            }
            this._panel.setSize(this._panel.getPreferredSize());
        } else if (this._popupType == 2) {
            if (this._window == null) {
                return;
            }
            this._window.pack();
        }
    }

    protected void internalShowPopup(int x, int y) {
        this.internalShowPopup(x, y, null);
    }

    protected void internalShowPopup(int x, int y, Component owner) {
        Component component = this._actualOwner = owner != null ? owner : this.getOwner();
        if (this._actualOwner != null) {
            try {
                this._actualOwnerLocation = this._actualOwner.getLocationOnScreen();
            }
            catch (IllegalComponentStateException e) {
                return;
            }
        }
        this.createWindow(this._actualOwner, x, y);
        this.showPopupImmediately();
    }

    protected Rectangle getAdjustedRectangle(int x, int y, Component owner) {
        boolean useAllDevices = false;
        if (owner instanceof JComponent) {
            for (JComponent comp = (JComponent)owner; comp != null; comp = (JComponent)comp.getParent()) {
                Object property = comp.getClientProperty("useAllMonitorDevices");
                if (property instanceof Boolean) {
                    useAllDevices = (Boolean)property;
                    break;
                }
                if (!(comp.getParent() instanceof JComponent)) break;
            }
        }
        Dimension size = this.getSize();
        return PortingUtils.containsInScreenBounds(owner, new Rectangle(x, y, size.width, size.height), !useAllDevices);
    }

    protected void createWindow(Component owner, int x, int y) {
        if (this._popupType == 0) {
            JRootPane rootPane;
            if (this._panel == null) {
                this._panel = this.createLightweightPopupContainer(owner);
                this._resizableSupport = this._panel;
                this.installListeners();
                this.installBorder();
            }
            if (this._previousSize != null && this.isKeepPreviousSize()) {
                this.setPreferredSize(null);
                if (this._previousSize.width < 0) {
                    this._previousSize.width = this.getPreferredSize().width;
                }
                if (this._previousSize.height < 0) {
                    this._previousSize.height = this.getPreferredSize().height;
                }
                this.setPreferredSize(this._previousSize);
            }
            this._previousSize = null;
            this.packPopup();
            if (this._insets != null) {
                Point p = this.getPopupLocation(new Point(x, y), this._panel.getSize(), owner);
                x = p.x;
                y = p.y;
            }
            if ((rootPane = JideSwingUtilities.getOutermostRootPane(owner)) == null) {
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            Point p = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p, layeredPane);
            layeredPane.add((Component)this._panel, JLayeredPane.PALETTE_LAYER);
            if (SystemInfo.isJdk15Above()) {
                layeredPane.setComponentZOrder(this._panel, 0);
            }
            this._panel.setLocation(p.x, p.y);
        } else if (this._popupType == 2) {
            if (this._window == null) {
                this._window = this.createHeavyweightPopupContainer(owner);
                this._resizableSupport = this._window;
                this.installListeners();
                this.installBorder();
            }
            if (this._previousSize != null && this.isKeepPreviousSize()) {
                this.setPreferredSize(null);
                if (this._previousSize.width < 0) {
                    this._previousSize.width = this.getPreferredSize().width;
                }
                if (this._previousSize.height < 0) {
                    this._previousSize.height = this.getPreferredSize().height;
                }
                this.setPreferredSize(this._previousSize);
            }
            this._previousSize = null;
            this.packPopup();
            if (this._insets != null) {
                Point p = this.getPopupLocation(new Point(x, y), this._window.getSize(), owner);
                x = p.x;
                y = p.y;
            }
            this._window.setLocation(x, y);
        }
    }

    public void showPopup(int x, int y) {
        this.showPopup(x, y, null);
    }

    public void showPopup(int x, int y, Component owner) {
        this.internalShowPopup(x, y, owner);
    }

    protected static Frame getFrame(Component c) {
        Component w;
        for (w = c; !(w instanceof Frame) && w != null; w = w.getParent()) {
        }
        return (Frame)w;
    }

    protected ResizableWindow createHeavyweightPopupContainer(Component owner) {
        Object shape;
        Object opacity;
        ResizableWindow container;
        Component topLevelAncestor = JidePopup.getTopLevelAncestor(owner);
        if (topLevelAncestor instanceof Frame) {
            container = new ResizableWindow((Frame)topLevelAncestor);
        } else if (topLevelAncestor instanceof Window) {
            container = new ResizableWindow((Window)topLevelAncestor);
        } else {
            Frame frame = JidePopup.getFrame(owner);
            container = new ResizableWindow(frame);
        }
        container.setName("JidePopup");
        container.getContentPane().add(this);
        Object opaque = this.getClientProperty(CLIENT_PROPERTY_WINDOW_OPAQUE);
        if (opaque instanceof Boolean) {
            JideSwingUtilities.setWindowOpaque(container, (Boolean)opaque);
        }
        if ((opacity = this.getClientProperty(CLIENT_PROPERTY_WINDOW_OPACITY)) instanceof Float) {
            JideSwingUtilities.setWindowOpacity(container, ((Float)opacity).floatValue());
        }
        if ((shape = this.getClientProperty(CLIENT_PROPERTY_WINDOW_SHAPE)) instanceof Shape) {
            JideSwingUtilities.setWindowShape(container, (Shape)shape);
        }
        return container;
    }

    protected ResizablePanel createLightweightPopupContainer(Component owner) {
        ResizablePanel panel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int resizeCorner, int newX, int newY, int newW, int newH) {
                        this.setBounds(newX, newY, newW, newH);
                    }
                };
            }
        };
        panel.setVisible(false);
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add(this);
        return panel;
    }

    protected void installListeners() {
        Component owner;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JidePopup.this.addMouseEventHandler();
            }
        });
        this._componentListener = new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                JidePopup.this.hidePopup();
            }
        };
        this._escapeActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JidePopup.this.hidePopupImmediately(true);
            }
        };
        this.registerKeyboardAction(this._escapeActionListener, KeyStroke.getKeyStroke(27, 0), 1);
        if (this._popupType == 2) {
            this._window.addComponentListener(this._componentListener);
            this._windowListener = new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JidePopup.this.hidePopupImmediately(true);
                }
            };
            this._window.addWindowListener(this._windowListener);
        }
        if ((owner = this.getActualOwner()) != null) {
            this._ownerComponentListener = new ComponentAdapter(){

                public void componentHidden(ComponentEvent e) {
                    JidePopup.this.ancestorHidden();
                }

                public void componentMoved(ComponentEvent e) {
                    try {
                        if (JidePopup.this._actualOwnerLocation == null || JidePopup.this._actualOwner == null || !JidePopup.this._actualOwner.getLocationOnScreen().equals(JidePopup.this._actualOwnerLocation)) {
                            JidePopup.this.ancestorMoved();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            owner.addComponentListener(this._ownerComponentListener);
            this._hierarchyListener = new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    JidePopup.this.ancestorHidden();
                }
            };
            owner.addHierarchyListener(this._hierarchyListener);
        }
        this._popupResizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JidePopup.this.removeComponentListener(JidePopup.this._popupResizeListener);
                JidePopup.this.contentResized();
                JidePopup.this.addComponentListener(JidePopup.this._popupResizeListener);
            }
        };
        this.addComponentListener(this._popupResizeListener);
    }

    protected void contentResized() {
        this.packPopup();
    }

    protected void installBorder() {
        if (!(this.getPopupBorder() == null || this._resizableSupport instanceof Component && this.getPopupBorder().getBorderInsets((Component)((Object)this._resizableSupport)) == null)) {
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            this._resizableSupport.setBorder(this.getPopupBorder());
        } else if (this.isDetached()) {
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
        } else {
            Border border;
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(56);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            if (!(CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX.equals(this.getClientProperty(CLIENT_PROPERTY_POPUP_TYPE)) || (border = UIDefaultsLookup.getBorder("PopupMenu.border")) == null || this._resizableSupport instanceof Component && border.getBorderInsets((Component)((Object)this._resizableSupport)) == null)) {
                this._resizableSupport.setBorder(border);
            }
        }
    }

    protected void showPopupImmediately() {
        boolean needFireEvents = true;
        if (this._popupType == 0) {
            if (this._panel == null) {
                return;
            }
            this._panel.applyComponentOrientation(this.getComponentOrientation());
            if (this._panel.isVisible()) {
                needFireEvents = false;
            }
            if (needFireEvents) {
                this.firePopupMenuWillBecomeVisible();
            }
            if (!this._panel.isVisible()) {
                this.packPopup();
                this._panel.setVisible(true);
            }
            if (needFireEvents) {
                this.firePropertyChange(VISIBLE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
            if ((this.isFocusable() || this.getDefaultFocusComponent() != null) && this.getDefaultFocusComponent() != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Component c = JidePopup.this.getDefaultFocusComponent();
                        if (c instanceof JComponent) {
                            ((JComponent)c).requestFocus(true);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (this._popupType == 2) {
            JButton defaultButton;
            if (this._window == null) {
                return;
            }
            if (this._window.isVisible()) {
                needFireEvents = false;
            }
            this._window.applyComponentOrientation(this.getComponentOrientation());
            if (needFireEvents) {
                this.firePopupMenuWillBecomeVisible();
            }
            if (!this.isFocusable() && this.getDefaultFocusComponent() == null) {
                this._window.setFocusableWindowState(false);
            } else {
                this.setFocusCycleRoot(true);
            }
            if (!this._window.isVisible()) {
                this._window.pack();
                this._window.setVisible(true);
            }
            if (needFireEvents) {
                this.firePropertyChange(VISIBLE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
            if (this.isFocusable() || this.getDefaultFocusComponent() != null) {
                this._window.setFocusable(true);
                if (this.getDefaultFocusComponent() != null) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            Component c = JidePopup.this.getDefaultFocusComponent();
                            if (c instanceof JComponent) {
                                ((JComponent)c).requestFocus(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            if ((defaultButton = this.getRootPane().getDefaultButton()) != null) {
                this.getRootPane().setDefaultButton(null);
                this.getRootPane().setDefaultButton(defaultButton);
            }
        }
        if (this.getTimeout() != 0) {
            this.startTimeoutTimer();
        }
    }

    protected void movePopup() {
        if (this.isPopupVisible() && !this.isDetached() && this._actualOwner != null) {
            if (this._insets != null) {
                this.showPopup(this._insets, this._actualOwner);
            } else if (this._actualOwnerLocation != null) {
                Point newLocation = this._actualOwner.getLocationOnScreen();
                Point p = null;
                if (this._popupType == 0) {
                    p = this._panel.getLocationOnScreen();
                } else if (this._popupType == 2 && (p = this._window.getLocationOnScreen()) != null) {
                    p.x += newLocation.x - this._actualOwnerLocation.x;
                    p.y += newLocation.y - this._actualOwnerLocation.y;
                }
                if (p != null) {
                    this.showPopup(p.x, p.y, this._actualOwner);
                }
            }
        }
    }

    protected void endDragging() {
        this._isDragging = false;
        if (this._popupType == 0) {
            this._currentPanel = null;
        } else if (this._popupType == 2) {
            if (this._currentWindow instanceof JWindow && ((JWindow)this._currentWindow).getGlassPane() != null) {
                ((JWindow)this._currentWindow).getGlassPane().setVisible(false);
                ((JWindow)this._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
            } else if (this._currentWindow instanceof JDialog && ((JDialog)this._currentWindow).getGlassPane() != null) {
                ((JDialog)this._currentWindow).getGlassPane().setVisible(false);
                ((JDialog)this._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
            this._currentWindow = null;
        }
        this._relativeX = 0.0;
        this._relativeY = 0.0;
    }

    protected void beginDragging(JComponent f, int mouseX, int mouseY, double relativeX, double relativeY) {
        this._relativeX = relativeX;
        this._relativeY = relativeY;
        Component owner = this.getActualOwner();
        if (this._popupType == 0) {
            this._currentPanel = this._panel;
            this._isDragging = true;
            if (this.isDetached() && owner != null) {
                this._startPoint = owner.getLocationOnScreen();
                this._startPoint.y += owner.getHeight();
            } else {
                this._startPoint = this._currentPanel.getLocationOnScreen();
            }
        } else if (this._popupType == 2) {
            if (f.getTopLevelAncestor() instanceof JWindow) {
                this._currentWindow = (JWindow)f.getTopLevelAncestor();
            }
            if (f.getTopLevelAncestor() instanceof JDialog) {
                this._currentWindow = (JDialog)f.getTopLevelAncestor();
            }
            if (this._currentWindow instanceof JWindow && ((JWindow)this._currentWindow).getGlassPane() != null) {
                ((JWindow)this._currentWindow).getGlassPane().setVisible(true);
                ((JWindow)this._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            } else if (this._currentWindow instanceof JDialog && ((JDialog)this._currentWindow).getGlassPane() != null) {
                ((JDialog)this._currentWindow).getGlassPane().setVisible(true);
                ((JDialog)this._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            }
            this._isDragging = true;
            if (this.isDetached() && owner != null) {
                this._startPoint = owner.getLocationOnScreen();
                this._startPoint.y += owner.getHeight();
            } else {
                this._startPoint = this._currentWindow.getLocationOnScreen();
            }
        }
    }

    protected boolean isDragging() {
        return this._isDragging;
    }

    static void convertPointToScreen(Point p, Component c, boolean startInFloat) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || (startInFloat ? c instanceof Window : c instanceof JFrame)) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x += x;
            p.y += y;
            if (!startInFloat ? c instanceof JFrame : c instanceof Window) break;
        } while (!(c instanceof Applet) && (c = c.getParent()) != null);
    }

    protected void drag(JComponent f, int newX, int newY, int mouseModifiers) {
        if (this._popupType == 0) {
            int x = newX - (int)((double)this._currentPanel.getWidth() * this._relativeX);
            int y = newY - (int)((double)this._currentPanel.getHeight() * this._relativeY);
            Rectangle bounds = new Rectangle(x, y, this._currentPanel.getWidth(), this._currentPanel.getHeight());
            Rectangle screenBounds = PortingUtils.getScreenBounds(this._currentPanel, true);
            if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
                bounds.y = screenBounds.y + screenBounds.height - bounds.height;
            }
            if (bounds.y < screenBounds.y) {
                bounds.y = screenBounds.y;
            }
            if (this.isAttachable() && this.isWithinAroundArea(new Point(x, y), this._startPoint)) {
                Point p = new Point(this._startPoint);
                SwingUtilities.convertPointFromScreen(p, this._currentPanel.getParent());
                this._currentPanel.setLocation(p);
                this.setDetached(false);
            } else {
                Point p = new Point(x, y);
                SwingUtilities.convertPointFromScreen(p, this._currentPanel.getParent());
                this._currentPanel.setLocation(p);
                this.setDetached(true);
            }
        } else if (this._popupType == 2) {
            int x = newX - (int)((double)this._currentWindow.getWidth() * this._relativeX);
            int y = newY - (int)((double)this._currentWindow.getHeight() * this._relativeY);
            Rectangle bounds = new Rectangle(x, y, this._currentWindow.getWidth(), this._currentWindow.getHeight());
            Rectangle screenBounds = PortingUtils.getScreenBounds(this._currentWindow, true);
            if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
                bounds.y = screenBounds.y + screenBounds.height - bounds.height;
            }
            if (bounds.y < screenBounds.y) {
                bounds.y = screenBounds.y;
            }
            if (this.isAttachable() && this.isWithinAroundArea(new Point(x, y), this._startPoint)) {
                this._currentWindow.setLocation(this._startPoint);
                this.setDetached(false);
            } else {
                this._currentWindow.setLocation(x, y);
                this.setDetached(true);
            }
        }
    }

    boolean isWithinAroundArea(Point p, Point newPoint) {
        if (this.getBackToOriginalInsets().left == 0 && this.getBackToOriginalInsets().top == 0 && this.getBackToOriginalInsets().right == 0 && this.getBackToOriginalInsets().bottom == 0) {
            return false;
        }
        Rectangle rect = new Rectangle(p.x - this.getBackToOriginalInsets().left, p.y - this.getBackToOriginalInsets().top, p.x + this.getBackToOriginalInsets().right, p.y + this.getBackToOriginalInsets().bottom);
        return rect.contains(newPoint);
    }

    protected void handleMousePressed(MouseEvent e) {
        MenuSelectionManager manager;
        MenuElement[] menuElements;
        Component c = e.getComponent();
        if (c == null) {
            return;
        }
        Component clickedComponent = (Component)e.getSource();
        Object popupMenuToCancel = this.getClientProperty("popupMenuToCancel");
        if (clickedComponent instanceof JComponent && this.HIDE_POPUP_KEY != null && popupMenuToCancel != null && ((JComponent)clickedComponent).getClientProperty("doNotCancelPopup") == this.HIDE_POPUP_KEY && this.isAncestorOf(clickedComponent) && (menuElements = (manager = MenuSelectionManager.defaultManager()).getSelectedPath()) != null) {
            for (MenuElement element : menuElements) {
                if (element != popupMenuToCancel) continue;
                manager.clearSelectedPath();
                break;
            }
        }
        Component component = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY());
        if (!this.isClickOnPopup(e)) {
            if (this.isExcludedComponent(component)) {
                return;
            }
            this.ancestorHidden();
        } else if (this.isPopupVisible()) {
            Window sourceWindow;
            Point point = SwingUtilities.convertPoint(component, e.getPoint(), this);
            Rectangle startingBounds = null;
            if (this._popupType == 0) {
                startingBounds = this._panel.getBounds();
                Container parent = this._panel.getParent();
                if (SystemInfo.isJdk15Above() && this.isClickOnPopup(e) && parent.getComponentZOrder(this._panel) != 0) {
                    parent.setComponentZOrder(this._panel, 0);
                    parent.repaint();
                }
            } else if (this._popupType == 2 && (sourceWindow = SwingUtilities.getWindowAncestor(component)) == this._window) {
                startingBounds = this._window.getBounds();
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() != this._window) {
                    this._window.toFront();
                }
            }
            if (startingBounds != null) {
                this._relativeX = (double)point.x / (double)startingBounds.width;
                this._relativeY = (double)point.y / (double)startingBounds.height;
                Point screenPoint = new Point(e.getX(), e.getY());
                JidePopup.convertPointToScreen(screenPoint, component, true);
                Component gripper = this.getUI().getGripper();
                if (gripper instanceof Container && (gripper == component || ((Container)gripper).isAncestorOf(component))) {
                    this.beginDragging(this, screenPoint.x, screenPoint.y, this._relativeX, this._relativeY);
                    e.consume();
                }
            }
        }
    }

    protected void handleMouseReleased(MouseEvent e) {
        if (this.isDragging()) {
            this.endDragging();
            e.consume();
        }
    }

    protected void handleMouseDragged(MouseEvent e) {
        if (this.isDragging()) {
            Point screenPoint = e.getPoint();
            if (e.getSource() instanceof Component) {
                JidePopup.convertPointToScreen(screenPoint, (Component)e.getSource(), true);
                this.drag(null, screenPoint.x, screenPoint.y, e.getModifiersEx());
                e.consume();
            }
        }
    }

    protected void handleMouseEntered(MouseEvent e) {
        if (this._popupType == 0) {
            if (this._panel != null && e.getSource() instanceof Component && this._panel.isAncestorOf((Component)e.getSource()) && this.getTimeout() != 0) {
                this.stopTimeoutTimer();
            }
        } else if (this._popupType == 2 && this._window != null && e.getSource() instanceof Component && this._window.isAncestorOf((Component)e.getSource()) && this.getTimeout() != 0) {
            this.stopTimeoutTimer();
        }
    }

    protected void handleMouseExited(MouseEvent e) {
        if (this._popupType == 0) {
            if (this._panel != null && e.getSource() instanceof Component && this._panel.isAncestorOf((Component)e.getSource()) && this.getTimeout() != 0) {
                this.startTimeoutTimer();
            }
        } else if (this._popupType == 2 && this._window != null && e.getSource() instanceof Component && this._window.isAncestorOf((Component)e.getSource()) && this.getTimeout() != 0) {
            this.startTimeoutTimer();
        }
    }

    private static boolean doUnpostPopupOnDeactivation() {
        if (!checkedUnpostPopup) {
            unpostPopup = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String pKey = "sun.swing.unpostPopupsOnWindowDeactivation";
                    String value = System.getProperty(pKey, "true");
                    return Boolean.valueOf(value);
                }
            });
            checkedUnpostPopup = true;
        }
        return unpostPopup;
    }

    protected void handleWindowEvent(WindowEvent e) {
        Component owner = this.getActualOwner();
        if (e.getSource() != this.getTopLevelAncestor() && e.getWindow() != null && (e.getWindow() == owner || e.getWindow().isAncestorOf(owner))) {
            if (e.getID() == 201 || e.getID() == 203) {
                this.hidePopup(true);
            } else if (this.isTransient() && e.getID() == 206 && !(e.getWindow() instanceof EmbeddedFrame) && JidePopup.doUnpostPopupOnDeactivation()) {
                JComponent realParent;
                Window oppositeWindow = e.getOppositeWindow();
                if (oppositeWindow == this.getTopLevelAncestor()) {
                    return;
                }
                if (oppositeWindow instanceof RootPaneContainer && (realParent = this.getRealParent((RootPaneContainer)((Object)oppositeWindow))) != null && realParent.getTopLevelAncestor() == this.getTopLevelAncestor()) {
                    return;
                }
                this.hidePopup(true);
            }
        }
    }

    protected JComponent getRealParent(RootPaneContainer rootPaneContainer) {
        Object clientProperty;
        JComponent c = JideSwingUtilities.getFirstJComponent(rootPaneContainer);
        if (c != null && (clientProperty = c.getClientProperty(CLIENT_PROPERTY_POPUP_ACTUAL_OWNER)) instanceof JComponent) {
            return (JComponent)clientProperty;
        }
        return null;
    }

    protected void handleComponentEvent(ComponentEvent e) {
        Component owner = this.getActualOwner();
        if (!(e.getSource() instanceof Container)) {
            return;
        }
        Container container = (Container)e.getSource();
        if (e.getID() == 103 && (container == owner || container.isAncestorOf(owner))) {
            this.ancestorHidden();
        } else if (e.getID() == 100 && (container == owner || container.isAncestorOf(owner))) {
            try {
                if (this._actualOwnerLocation == null || this._actualOwner == null || !this._actualOwner.getLocationOnScreen().equals(this._actualOwnerLocation)) {
                    this.ancestorMoved();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void ancestorHidden() {
        if (this.isTransient()) {
            this.hidePopupImmediately(true);
        }
    }

    protected void ancestorMoved() {
        if (this.getDefaultMoveOperation() == 1) {
            this.movePopup();
        } else if (this.getDefaultMoveOperation() == 0 && this.isTransient()) {
            this.hidePopupImmediately(true);
        }
    }

    public void hidePopup() {
        this.hidePopup(false);
    }

    public void hidePopup(boolean cancelled) {
        if (!this.isPopupVisible()) {
            return;
        }
        this.hidePopupImmediately(cancelled);
    }

    public boolean isPopupVisible() {
        if (this._popupType == 0) {
            return this._panel != null && this._panel.isVisible();
        }
        if (this._popupType == 2) {
            return this._window != null && this._window.isShowing();
        }
        return false;
    }

    public Rectangle getPopupBounds() {
        if (this._popupType == 0) {
            return this.isPopupVisible() ? this._panel.getBounds() : null;
        }
        if (this._popupType == 2) {
            return this.isPopupVisible() ? this._window.getBounds() : null;
        }
        return null;
    }

    public void hidePopupImmediately(boolean cancelled) {
        Component owner = this.getActualOwner();
        if (owner != null) {
            owner.removeHierarchyListener(this._hierarchyListener);
            this._hierarchyListener = null;
            owner.removeComponentListener(this._ownerComponentListener);
            this._ownerComponentListener = null;
        }
        if (this._escapeActionListener != null) {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            this._escapeActionListener = null;
        }
        int insetWidth = 0;
        int insetHeight = 0;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            Insets insets = container.getInsets();
            if (insets != null) {
                insetWidth += insets.left + insets.right;
                insetHeight += insets.top + insets.bottom;
            }
            if (container == this._window || container == this._panel) break;
        }
        if (this._window != null) {
            this._window.removeWindowListener(this._windowListener);
            this._windowListener = null;
            this._window.removeComponentListener(this._componentListener);
            this._componentListener = null;
            this._window.getContentPane().remove(this);
            if (cancelled) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._panel != null) {
            this._panel.remove(this);
            if (cancelled) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._popupResizeListener != null) {
            this.removeComponentListener(this._popupResizeListener);
            this._popupResizeListener = null;
        }
        if (owner != null && this.isReturnFocusToOwner()) {
            owner.requestFocus();
        }
        if (this._window != null) {
            this._previousSize = this._window.getSize();
            this._window.setVisible(false);
            this._window.removeAll();
            this._window.dispose();
            this._window = null;
            this.firePropertyChange(VISIBLE_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (this._panel != null) {
            this._previousSize = this._panel.getSize();
            this._panel.setVisible(false);
            Container parent = this._panel.getParent();
            if (parent != null) {
                parent.remove(this._panel);
            }
            this._panel = null;
            this.firePropertyChange(VISIBLE_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (this._previousSize != null) {
            this._previousSize.width -= insetWidth;
            this._previousSize.height -= insetHeight;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JidePopup.this.removeMouseEventHandler();
            }
        });
        this._resizableSupport = null;
        this._owner = null;
        this._actualOwner = null;
        this._actualOwnerLocation = null;
    }

    public void hidePopupImmediately() {
        this.hidePopupImmediately(false);
    }

    private void addMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        if (this._awtEventListener == null) {
            this._awtEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if ("sun.awt.UngrabEvent".equals(event.getClass().getName())) {
                        JidePopup.this.hidePopupImmediately(true);
                        return;
                    }
                    if (event instanceof MouseEvent) {
                        if (event.getID() == 501) {
                            JidePopup.this.handleMousePressed((MouseEvent)event);
                        } else if (event.getID() == 506) {
                            JidePopup.this.handleMouseDragged((MouseEvent)event);
                        } else if (event.getID() == 502) {
                            JidePopup.this.handleMouseReleased((MouseEvent)event);
                        } else if (event.getID() == 504) {
                            JidePopup.this.handleMouseEntered((MouseEvent)event);
                        } else if (event.getID() == 505) {
                            JidePopup.this.handleMouseExited((MouseEvent)event);
                        }
                    } else if (event instanceof WindowEvent) {
                        JidePopup.this.handleWindowEvent((WindowEvent)event);
                    } else if (event instanceof ComponentEvent) {
                        JidePopup.this.handleComponentEvent((ComponentEvent)event);
                    }
                }
            };
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(JidePopup.this._awtEventListener, 113L);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(JidePopup.this._awtEventListener);
                    JidePopup.this._awtEventListener = null;
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Component getOwner() {
        return this._owner;
    }

    public void setOwner(Component owner) {
        if (this._owner != owner) {
            Component old = this._owner;
            this._owner = owner;
            this.firePropertyChange(OWNER_PROPERTY, old, this._owner);
            this.removeExcludedComponent(old);
            this.addExcludedComponent(this._owner);
        }
    }

    public boolean isMovable() {
        return this._movable;
    }

    public void setMovable(boolean movable) {
        boolean old = this._movable;
        if (old != movable) {
            this._movable = movable;
            this.firePropertyChange(MOVABLE_PROPERTY, old, this._movable);
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        if (this._resizable != resizable) {
            boolean old = this._resizable;
            this._resizable = resizable;
            this.firePropertyChange(RESIZABLE_PROPERTY, old, this._resizable);
        }
    }

    public boolean isAttachable() {
        return this._attachable;
    }

    public void setAttachable(boolean attachable) {
        if (this._attachable != attachable) {
            boolean old = this._attachable;
            this._attachable = attachable;
            this.firePropertyChange(ATTACHABLE_PROPERTY, old, this._attachable);
        }
    }

    public boolean isDetached() {
        return this._detached;
    }

    public void setDetached(boolean detached) {
        if (this._detached != detached) {
            boolean old = this._detached;
            this._detached = detached;
            this.firePropertyChange("detacted", old, this._detached);
            if (this._resizableSupport != null) {
                if (this._detached) {
                    if (this.getPopupBorder() == null) {
                        this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
                    } else {
                        this._resizableSupport.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._resizableSupport.getResizable().setResizableCorners(255);
                    } else {
                        this._resizableSupport.getResizable().setResizableCorners(0);
                    }
                } else {
                    if (this.getPopupBorder() == null) {
                        if (!CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX.equals(this.getClientProperty(CLIENT_PROPERTY_POPUP_TYPE))) {
                            this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
                        }
                    } else {
                        this._resizableSupport.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._resizableSupport.getResizable().setResizableCorners(56);
                    } else {
                        this._resizableSupport.getResizable().setResizableCorners(0);
                    }
                }
            }
        }
    }

    public Border getPopupBorder() {
        return this._popupBorder;
    }

    public void setPopupBorder(Border popupBorder) {
        this._popupBorder = popupBorder;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean isTransient) {
        boolean old = this._transient;
        if (old != isTransient) {
            this._transient = isTransient;
            this.firePropertyChange(TRANSIENT_PROPERTY, old, isTransient);
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        if (timeout != 0) {
            this.startTimeoutTimer();
        } else {
            this.stopTimeoutTimer();
        }
    }

    private void stopTimeoutTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void startTimeoutTimer() {
        this.stopTimeoutTimer();
        this._timer = new Timer(this.getTimeout(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JidePopup.this.hidePopup();
            }
        });
        this._timer.setRepeats(false);
        this._timer.start();
    }

    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this._defaultFocusComponent = defaultFocusComponent;
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.listenerList.add(PopupMenuListener.class, l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.listenerList.remove(PopupMenuListener.class, l);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeVisible(e);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeInvisible(e);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuCanceled(e);
        }
    }

    public int getDefaultMoveOperation() {
        return this._defaultMoveOperation;
    }

    public void setDefaultMoveOperation(int defaultMoveOperation) {
        this._defaultMoveOperation = defaultMoveOperation;
    }

    public void addExcludedComponent(Component component) {
        if (component != null && !this._excludedComponents.contains(component)) {
            this._excludedComponents.add(component);
        }
    }

    public void removeExcludedComponent(Component component) {
        this._excludedComponents.remove(component);
    }

    public void removeAllExcludedComponents() {
        this._excludedComponents.clear();
    }

    public boolean isExcludedComponent(Component component) {
        boolean contain = this._excludedComponents.contains(component);
        if (!contain) {
            JComponent realParent;
            Container c;
            for (Component c2 : this._excludedComponents) {
                if (!(c2 instanceof Container) || !((Container)c2).isAncestorOf(component)) continue;
                return true;
            }
            if (component instanceof JComponent && (c = ((JComponent)component).getTopLevelAncestor()) instanceof RootPaneContainer && (realParent = this.getRealParent((RootPaneContainer)((Object)c))) != null && realParent.getTopLevelAncestor() == this.getTopLevelAncestor()) {
                return true;
            }
        }
        return contain;
    }

    public int getGripperLocation() {
        return this._gripperLocation;
    }

    public void setGripperLocation(int gripperLocation) {
        int old = this._gripperLocation;
        if (old != gripperLocation) {
            this._gripperLocation = gripperLocation;
            this.firePropertyChange(PROPERTY_GRIPPER_LOCATION, old, gripperLocation);
        }
    }

    public int getPopupType() {
        return this._popupType;
    }

    public void setPopupType(int popupType) {
        if (popupType != 0 && popupType != 2) {
            throw new IllegalArgumentException("invalid popup type. It must be JidePopup.HEAVY_WEIGHT_POPUP or JidePopup.LIGHT_WEIGHT_POPUP.");
        }
        this._popupType = popupType;
    }

    public boolean isClickOnPopup(MouseEvent e) {
        Component c = e.getComponent();
        if (c == null) {
            return false;
        }
        Component component = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY());
        return this.getPopupType() == 2 ? this._window != null && (this._window == component || this._window.isAncestorOf(component)) : this._panel != null && (this._panel == component || this._panel.isAncestorOf(component));
    }

    protected Component getActualOwner() {
        if (this._actualOwner != null) {
            return this._actualOwner;
        }
        return this.getOwner();
    }

    public void setPreferredPopupSize(Dimension size) {
        this._previousSize = size;
    }

    public static boolean isPopupAncestorOf(JidePopup popup, Component c) {
        Container p;
        if (c == null || (p = c.getParent()) == null) {
            return false;
        }
        while (p != null) {
            if (p == popup) {
                return true;
            }
            if (p instanceof JidePopup) {
                return false;
            }
            p = p.getParent();
        }
        return false;
    }

    public boolean isReturnFocusToOwner() {
        return this._returnFocusToOwner;
    }

    public void setReturnFocusToOwner(boolean returnFocusToOwner) {
        this._returnFocusToOwner = returnFocusToOwner;
    }

    protected class AccessiblePopup
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -1095213042773793649L;

        protected AccessiblePopup() {
            super(JidePopup.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return JidePopup.this.getName();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            if (this.isVisible()) {
                return 1;
            }
            return 0;
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (n instanceof Integer) {
                if (n.intValue() == 0) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                }
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }
}

