/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;

public class GeographicHandlerFactory
implements ProjectionHandlerFactory {
    static final double MAX_LATITUDE = 89.99;
    static final double MIN_LATITUDE = -89.99;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
        if (renderingEnvelope != null && crs instanceof GeographicCRS) {
            GeographicCRS geogCrs = (GeographicCRS)CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
            SingleCRS horizontalSourceCrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)sourceCrs);
            ReferencedEnvelope validArea = null;
            if (horizontalSourceCrs instanceof GeographicCRS && !CRS.equalsIgnoreMetadata((Object)horizontalSourceCrs, (Object)geogCrs) && !CRS.equalsIgnoreMetadata((Object)horizontalSourceCrs, (Object)geogCrs)) {
                validArea = CRS.getAxisOrder((CoordinateReferenceSystem)sourceCrs) == CRS.AxisOrder.NORTH_EAST ? new ReferencedEnvelope(-89.99, 89.99, 3.4028234663852886E38, -3.4028234663852886E38, (CoordinateReferenceSystem)horizontalSourceCrs) : new ReferencedEnvelope(3.4028234663852886E38, -3.4028234663852886E38, -89.99, 89.99, (CoordinateReferenceSystem)horizontalSourceCrs);
            }
            if (wrap && maxWraps > 0) {
                double centralMeridian = geogCrs.getDatum().getPrimeMeridian().getGreenwichLongitude();
                return new WrappingProjectionHandler(renderingEnvelope, validArea, sourceCrs, centralMeridian, maxWraps);
            }
            return new ProjectionHandler(sourceCrs, (Envelope)validArea, renderingEnvelope);
        }
        return null;
    }
}

