/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.tile;

import java.awt.Dimension;
import java.util.List;
import org.esa.snap.netbeans.tile.Bundle;
import org.esa.snap.netbeans.tile.TileUtilities;
import org.esa.snap.netbeans.tile.Tileable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.windows.TopComponent;

class TileableImpl
implements Tileable {
    TileableImpl() {
    }

    @Override
    public boolean canTile() {
        return TileUtilities.countOpenEditorWindows() >= 2;
    }

    @Override
    public void tileEvenly() {
        this.tile(editorWindows -> {
            int windowCount = editorWindows.size();
            Dimension matrixSize = TileUtilities.computeMatrixSizeForEqualAreaTiling(windowCount);
            int windowIndex = 0;
            for (int rowIndex = 0; rowIndex < matrixSize.height; ++rowIndex) {
                for (int colIndex = 0; colIndex < matrixSize.width; ++colIndex) {
                    TopComponent editorWindow;
                    if (windowIndex >= windowCount || !TileUtilities.openInEditorMode(editorWindow = (TopComponent)editorWindows.get(windowIndex), rowIndex, colIndex)) continue;
                    ++windowIndex;
                }
            }
            return windowIndex;
        });
    }

    @Override
    public void tileHorizontally() {
        this.tile(editorWindows -> {
            int windowCount = editorWindows.size();
            int colCount = Math.min(windowCount, 16);
            int windowIndex = 0;
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                TopComponent editorWindow;
                if (windowIndex >= windowCount || !TileUtilities.openInEditorMode(editorWindow = (TopComponent)editorWindows.get(windowIndex), 0, colIndex)) continue;
                ++windowIndex;
            }
            return windowIndex;
        });
    }

    @Override
    public void tileVertically() {
        this.tile(editorWindows -> {
            int windowCount = editorWindows.size();
            int rowCount = Math.min(windowCount, 16);
            int windowIndex = 0;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                TopComponent editorWindow;
                if (windowIndex >= windowCount || !TileUtilities.openInEditorMode(editorWindow = (TopComponent)editorWindows.get(windowIndex), rowIndex, 0)) continue;
                ++windowIndex;
            }
            return windowIndex;
        });
    }

    @Override
    public void tileSingle() {
        this.tile(editorWindows -> {
            int windowIndex = 0;
            for (TopComponent editorWindow : editorWindows) {
                if (!TileUtilities.openInMode(editorWindow, "editor")) continue;
                ++windowIndex;
            }
            return windowIndex;
        });
    }

    private void tile(Tiler tiler) {
        TopComponent selectedWindow = TopComponent.getRegistry().getActivated();
        List<TopComponent> editorWindows = TileUtilities.findOpenEditorWindows();
        if (editorWindows.size() < 2) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_TileableImplNothingToDo());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        int totalWindowCount = editorWindows.size();
        int tiledWindowCount = tiler.tile(editorWindows);
        if (selectedWindow != null) {
            selectedWindow.requestActive();
        }
        if (tiledWindowCount < totalWindowCount) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_TileableImplNotComplete());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private static interface Tiler {
        public int tile(List<TopComponent> var1);
    }
}

