/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class Header
implements Cloneable {
    private final Map<String, HeaderField> headers = new HashMap<String, HeaderField>();
    private int lineNumber;

    public Header(int lineNumer) {
        this.lineNumber = lineNumer;
    }

    public void addHeader(String name, String value, int lineNumber) {
        HeaderField headerField = this.getHeaderFieldOrDefault(name, lineNumber);
        List<String> headerValues = headerField.getValues();
        if (!headerValues.contains(value)) {
            headerValues.add(value);
        }
    }

    public void addHeader(String name, List<String> values, int lineNumber) {
        HeaderField headerField = this.getHeaderFieldOrDefault(name, lineNumber);
        List<String> headerValues = headerField.getValues();
        for (String value : values) {
            if (headerValues.contains(value)) continue;
            headerValues.add(value);
        }
    }

    public boolean isHeaderMatching(String name, Pattern pattern) {
        if (this.getHeaders(name).size() != 1) {
            return false;
        }
        return pattern.matcher(this.getHeaders(name).get(0)).matches();
    }

    public void removeHeader(String name) {
        this.headers.remove(name.toLowerCase(Locale.ENGLISH));
    }

    public String getHeader(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? null : headerField.getValue();
    }

    public String getHeaderNotNull(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? "" : headerField.getValueNotNull();
    }

    public List<String> getHeaders(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? new ArrayList() : headerField.getValues();
    }

    public HeaderField getHeaderField(String name) {
        return this.headers.get(name.toLowerCase(Locale.ENGLISH));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Map<String, String> toSingleMap() {
        HashMap<String, String> singleMap = new HashMap<String, String>();
        for (String key : this.headers.keySet()) {
            HeaderField field = this.headers.get(key);
            singleMap.put(field.getFieldName(), this.getHeader(key));
        }
        return singleMap;
    }

    public Map<String, List<String>> toMultiMap() {
        HashMap<String, List<String>> singleMap = new HashMap<String, List<String>>();
        for (String key : this.headers.keySet()) {
            HeaderField field = this.headers.get(key);
            singleMap.put(field.getFieldName(), field.getValues());
        }
        return singleMap;
    }

    private HeaderField getHeaderFieldOrDefault(String name, int lineNumber) {
        HeaderField headerField = this.headers.get(name.toLowerCase(Locale.ENGLISH));
        if (headerField == null) {
            headerField = new HeaderField(name, lineNumber);
            this.headers.put(name.toLowerCase(Locale.ENGLISH), headerField);
        }
        return headerField;
    }

    public Header clone() {
        Header newInstance = new Header(this.lineNumber);
        for (String key : this.headers.keySet()) {
            newInstance.headers.put(key, this.headers.get(key).clone());
        }
        return newInstance;
    }

    public static List<String> splitValuesByComma(String headerValue) {
        String[] parts;
        ArrayList<String> singleValues = new ArrayList<String>();
        for (String value : parts = headerValue.split(",")) {
            singleValues.add(value.trim());
        }
        return singleValues;
    }

    public static class HeaderField
    implements Cloneable {
        private final String fieldName;
        private final List<String> values;
        private final int lineNumber;

        public HeaderField(String fieldName, int lineNumber) {
            this(fieldName, new ArrayList<String>(), lineNumber);
        }

        public HeaderField(String fieldName, List<String> values, int lineNumber) {
            this.fieldName = fieldName;
            this.values = values;
            this.lineNumber = lineNumber;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public List<String> getValues() {
            return this.values;
        }

        public String getValue() {
            StringBuilder result = new StringBuilder();
            for (String value : this.values) {
                result.append(value);
                result.append(", ");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 2, result.length());
            }
            return result.toString();
        }

        public String getValueNotNull() {
            String value = this.getValue();
            return value == null ? "" : value;
        }

        public HeaderField clone() {
            ArrayList<String> newValues = new ArrayList<String>();
            newValues.addAll(this.values);
            return new HeaderField(this.fieldName, newValues, this.lineNumber);
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result = 31 * result + this.lineNumber;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeaderField other = (HeaderField)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (this.lineNumber != other.lineNumber) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }
    }
}

