/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import com.bc.ceres.core.Assert;
import java.util.Arrays;

public abstract class GeneralFilterFunction {
    protected final int width;
    protected final int height;
    protected final int xOrigin;
    protected final int yOrigin;
    protected final boolean[] structuringElement;

    protected GeneralFilterFunction(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
        Assert.argument((width > 0 ? 1 : 0) != 0, (String)"width must be positive");
        Assert.argument((height > 0 ? 1 : 0) != 0, (String)"height must be positive");
        Assert.argument((xOrigin >= 0 && xOrigin < width ? 1 : 0) != 0, (String)"xOrigin out of bounds");
        Assert.argument((yOrigin >= 0 && yOrigin < height ? 1 : 0) != 0, (String)"yOrigin out of bounds");
        this.width = width;
        this.height = height;
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        if (structuringElement != null) {
            Assert.argument((structuringElement.length == width * height ? 1 : 0) != 0, (String)"structuringElement has illegal size");
            this.structuringElement = (boolean[])structuringElement.clone();
        } else {
            this.structuringElement = null;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getXOrigin() {
        return this.xOrigin;
    }

    public final int getYOrigin() {
        return this.yOrigin;
    }

    public final int getLeftPadding() {
        return this.xOrigin;
    }

    public final int getRightPadding() {
        return this.width - this.xOrigin - 1;
    }

    public final int getTopPadding() {
        return this.yOrigin;
    }

    public final int getBottomPadding() {
        return this.height - this.yOrigin - 1;
    }

    public boolean[] getStructuringElement() {
        return this.structuringElement;
    }

    public abstract float filter(float[] var1);

    public static final class Dilation
    extends GeneralFilterFunction {
        public Dilation(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float max = Float.NEGATIVE_INFINITY;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || !(v > max)) continue;
                max = v;
                ++n;
            }
            return n > 0 ? max : Float.NaN;
        }
    }

    public static final class Erosion
    extends GeneralFilterFunction {
        public Erosion(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float min = Float.POSITIVE_INFINITY;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || !(v < min)) continue;
                min = v;
                ++n;
            }
            return n > 0 ? min : Float.NaN;
        }
    }

    public static final class StdDev
    extends GeneralFilterFunction {
        public StdDev(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float sum = 0.0f;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || Float.isNaN(v)) continue;
                sum += v;
                ++n;
            }
            if (n > 0) {
                float mean = sum / (float)n;
                float sqrSum = 0.0f;
                for (int i = 0; i < fdata.length; ++i) {
                    float v = fdata[i];
                    if (se != null && !se[i] || Float.isNaN(v)) continue;
                    float delta = v - mean;
                    sqrSum += delta * delta;
                }
                return (float)Math.sqrt(sqrSum / (float)n);
            }
            return Float.NaN;
        }
    }

    public static final class Mean
    extends GeneralFilterFunction {
        public Mean(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float sum = 0.0f;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || Float.isNaN(v)) continue;
                sum += v;
                ++n;
            }
            return n > 0 ? sum / (float)n : Float.NaN;
        }
    }

    public static final class Median
    extends GeneralFilterFunction {
        public Median(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            Arrays.sort(fdata);
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || Float.isNaN(v)) continue;
                ++n;
            }
            if (n == 0) {
                return Float.NaN;
            }
            if (n == 1) {
                return fdata[0];
            }
            if (n % 2 == 1) {
                return fdata[n / 2];
            }
            return 0.5f * (fdata[n / 2 - 1] + fdata[n / 2]);
        }
    }

    public static final class Max
    extends GeneralFilterFunction {
        public Max(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float max = Float.NEGATIVE_INFINITY;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || !(v > max)) continue;
                max = v;
                ++n;
            }
            return n > 0 ? max : Float.NaN;
        }
    }

    public static final class Min
    extends GeneralFilterFunction {
        public Min(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        @Override
        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            float min = Float.POSITIVE_INFINITY;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                float v = fdata[i];
                if (se != null && !se[i] || !(v < min)) continue;
                min = v;
                ++n;
            }
            return n > 0 ? min : Float.NaN;
        }
    }
}

