/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PlacemarkClutterFilter;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.snap.worldwind.LayerPanelLayer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AppPanel
extends JPanel {
    private WorldWindowGLCanvas wwd = null;
    private StatusBar statusBar = null;

    public AppPanel(WorldWindowGLCanvas shareWith, boolean includeStatusBar, boolean flatWorld, boolean removeExtraLayers) {
        super(new BorderLayout());
        this.wwd = new WorldWindowGLCanvas(shareWith);
        Model m = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
        this.wwd.setModel(m);
        if (flatWorld) {
            m.setGlobe(new EarthFlat());
            this.wwd.setView(new FlatOrbitView());
        } else {
            m.setGlobe(new Earth());
            this.wwd.setView(new BasicOrbitView());
        }
        if (removeExtraLayers) {
            LayerList layerList = m.getLayers();
            for (Layer layer : layerList) {
                if (!(layer instanceof CompassLayer) && !(layer instanceof WorldMapLayer) && !(layer instanceof StarsLayer) && !(layer instanceof LandsatI3WMSLayer) && !(layer instanceof SkyGradientLayer)) continue;
                layerList.remove(layer);
            }
        }
        this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwd, WorldMapLayer.class));
        this.wwd.getSceneController().setClutterFilter(new PlacemarkClutterFilter());
        this.add((Component)((Object)this.wwd), "Center");
        if (includeStatusBar) {
            this.statusBar = new MinimalStatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource(this.wwd);
        }
    }

    public void addLayerPanelLayer() {
        this.wwd.getModel().getLayers().add((Layer)((Object)new LayerPanelLayer(this.getWwd())));
    }

    public void addElevation() {
        try {
            ElevationModel em = AppPanel.makeElevationModel();
            this.wwd.getModel().getGlobe().setElevationModel(em);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final WorldWindowGLCanvas getWwd() {
        return this.wwd;
    }

    public final StatusBar getStatusBar() {
        return this.statusBar;
    }

    private static ElevationModel makeElevationModel() throws URISyntaxException, ParserConfigurationException, IOException, SAXException {
        URI serverURI = new URI("http://www.nasa.network.com/elev");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        if ((double)Configuration.getJavaVersion() >= 1.6) {
            try {
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                String message = Logging.getMessage("XML.NonvalidatingNotSupported");
                Logging.logger().finest(message);
            }
        }
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        CapabilitiesRequest req = new CapabilitiesRequest(serverURI);
        Document doc = docBuilder.parse(req.toString());
        WMSCapabilities caps = new WMSCapabilities(doc);
        double HEIGHT_OF_MT_EVEREST = 8850.0;
        double DEPTH_OF_MARIANAS_TRENCH = -11000.0;
        AVListImpl params = new AVListImpl();
        params.setValue("gov.nasa.worldwind.avkey.LayerNames", "|srtm3");
        params.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        params.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        params.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", LatLon.fromDegrees(20.0, 20.0));
        params.setValue("gov.nasa.worldwind.avkey.NumLevels", 8);
        params.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", -11000.0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", 8850.0);
        CompoundElevationModel cem = new CompoundElevationModel();
        cem.addElevationModel(new WMSBasicElevationModel(caps, (AVList)params));
        return cem;
    }

    private static class MinimalStatusBar
    extends StatusBar {
        public MinimalStatusBar() {
            this.remove(this.altDisplay);
        }
    }
}

