/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import org.esa.snap.core.util.Guardian;

public abstract class ItemInfo {
    private String _name;
    private final String _description;

    protected ItemInfo(String name, String description) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this._name = name;
        this._description = description != null ? description.intern() : null;
    }

    public final String getName() {
        return this._name;
    }

    public final String getDescription() {
        return this._description;
    }

    public void setNamePrefix(String prefix) {
        Guardian.assertNotNull((String)"prefix", (Object)prefix);
        this._name = prefix + "." + this._name;
    }

    public boolean isNameEqualTo(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ItemInfo[");
        sb.append("'");
        sb.append(this.getName());
        sb.append("','");
        sb.append(this.getDescription());
        sb.append("']");
        return sb.toString();
    }
}

