/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.LineTimeCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PointingFactory;
import org.esa.snap.core.datamodel.PointingFactoryRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.TimeCoding;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.envisat.BandInfo;
import org.esa.snap.dataio.envisat.BandLineReader;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.EnvisatConstants;
import org.esa.snap.dataio.envisat.EnvisatProductReaderPlugIn;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;
import org.esa.snap.runtime.Config;

public class EnvisatProductReader
extends AbstractProductReader {
    private static final String SYSPROP_ENVISAT_USE_PIXEL_GEO_CODING = "snap.envisat.usePixelGeoCoding";
    private ProductFile productFile;
    private int sceneRasterWidth;
    private int sceneRasterHeight;
    private Map<Band, BandLineReader> bandlineReaderMap;

    public EnvisatProductReader(EnvisatProductReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    public ProductFile getProductFile() {
        return this.productFile;
    }

    public int getSceneRasterWidth() {
        return this.sceneRasterWidth;
    }

    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    protected Product readProductNodesImpl() throws IOException {
        Object input = this.getInput();
        if (input instanceof String || input instanceof File) {
            File file = new File(input.toString());
            try {
                this.productFile = ProductFile.open(file);
            }
            catch (IOException e) {
                InputStream inputStream;
                try {
                    inputStream = EnvisatProductReaderPlugIn.getInflaterInputStream(file);
                }
                catch (IOException ignored) {
                    throw e;
                }
                this.productFile = ProductFile.open(file, new FileCacheImageInputStream(inputStream, null));
            }
        } else if (input instanceof ImageInputStream) {
            this.productFile = ProductFile.open((ImageInputStream)input);
        } else if (input instanceof ProductFile) {
            this.productFile = (ProductFile)input;
        }
        Debug.assertNotNull((Object)this.productFile);
        this.sceneRasterWidth = this.productFile.getSceneRasterWidth();
        this.sceneRasterHeight = this.productFile.getSceneRasterHeight();
        if (this.getSubsetDef() != null) {
            Dimension s = this.getSubsetDef().getSceneRasterSize(this.sceneRasterWidth, this.sceneRasterHeight);
            this.sceneRasterWidth = s.width;
            this.sceneRasterHeight = s.height;
        }
        return this.createProduct();
    }

    public void close() throws IOException {
        if (this.productFile != null) {
            this.productFile.close();
            this.productFile = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        BandLineReader bandLineReader = this.bandlineReaderMap.get(destBand);
        int sourceMinX = sourceOffsetX;
        int sourceMinY = sourceOffsetY;
        int sourceMaxX = Math.min(destBand.getRasterWidth() - 1, sourceMinX + sourceWidth - 1);
        int sourceMaxY = sourceMinY + sourceHeight - 1;
        pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceMinY + 1);
        try {
            int destArrayPos = 0;
            for (int sourceY = sourceMinY; sourceY <= sourceMaxY && !pm.isCanceled(); sourceY += sourceStepY) {
                bandLineReader.readRasterLine(sourceMinX, sourceMaxX, sourceStepX, sourceY, destBuffer, destArrayPos);
                destArrayPos += destWidth;
                pm.worked(sourceStepY);
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private Product createProduct() throws IOException {
        Debug.assertNotNull((Object)this.getProductFile());
        File file = this.getProductFile().getFile();
        String productName = file != null ? file.getName() : this.getProductFile().getProductId();
        productName = FileUtils.createValidFilename((String)productName);
        int sceneRasterHeight = this.getSceneRasterHeight();
        Product product = new Product(productName, this.getProductFile().getProductType(), this.getSceneRasterWidth(), sceneRasterHeight, (ProductReader)this);
        product.setFileLocation(this.getProductFile().getFile());
        product.setDescription(this.getProductFile().getProductDescription());
        ProductData.UTC startTime = this.getProductFile().getSceneRasterStartTime();
        ProductData.UTC endTime = this.getProductFile().getSceneRasterStopTime();
        product.setStartTime(startTime);
        product.setEndTime(endTime);
        if (startTime != null && endTime != null && sceneRasterHeight > 0) {
            product.setSceneTimeCoding((TimeCoding)new LineTimeCoding(sceneRasterHeight, startTime.getMJD(), endTime.getMJD()));
        }
        product.setAutoGrouping(this.getProductFile().getAutoGroupingPattern());
        this.addBandsToProduct(product);
        if (!this.isMetadataIgnored()) {
            this.addHeaderAnnotationsToProduct(product);
            this.addDatasetAnnotationsToProduct(product);
            this.addTiePointGridsToProduct(product);
            EnvisatProductReader.addGeoCodingToProduct(product);
            EnvisatProductReader.initPointingFactory(product);
        }
        this.addDefaultMasksToProduct(product);
        this.addDefaultMasksDefsToBands(product);
        this.productFile.addCustomMetadata(product);
        return product;
    }

    private void addBandsToProduct(Product product) {
        Debug.assertNotNull((Object)this.productFile);
        Debug.assertNotNull((Object)product);
        BandLineReader[] bandLineReaders = this.productFile.getBandLineReaders();
        this.bandlineReaderMap = new HashMap<Band, BandLineReader>(bandLineReaders.length);
        for (BandLineReader bandLineReader : bandLineReaders) {
            String expression;
            VirtualBand band;
            String bandName;
            if (bandLineReader.isTiePointBased() || !(bandLineReader instanceof BandLineReader.Virtual) && (bandLineReader.getPixelDataReader().getDSD().getDatasetSize() == 0L || bandLineReader.getPixelDataReader().getDSD().getNumRecords() == 0) || !this.isNodeAccepted(bandName = bandLineReader.getBandName())) continue;
            BandInfo bandInfo = bandLineReader.getBandInfo();
            int width = bandInfo.getWidth();
            int height = bandInfo.getHeight();
            if (this.getSubsetDef() != null) {
                Dimension s = this.getSubsetDef().getSceneRasterSize(width, height);
                width = s.width;
                height = s.height;
            }
            if (bandLineReader instanceof BandLineReader.Virtual) {
                BandLineReader.Virtual virtual = (BandLineReader.Virtual)bandLineReader;
                band = new VirtualBand(bandName, 31, width, height, virtual.getExpression());
            } else {
                band = new Band(bandName, bandInfo.getDataType() < 30 ? bandInfo.getDataType() : bandLineReader.getPixelDataField().getDataType(), width, height);
            }
            band.setScalingOffset(bandInfo.getScalingOffset());
            this.productFile.setInvalidPixelExpression((Band)band);
            band.setScalingFactor(bandInfo.getScalingFactor());
            band.setLog10Scaled(bandInfo.getScalingMethod() == 12);
            band.setSpectralBandIndex(bandInfo.getSpectralBandIndex());
            if (bandInfo.getPhysicalUnit() != null) {
                band.setUnit(bandInfo.getPhysicalUnit());
            }
            if (bandInfo.getDescription() != null) {
                band.setDescription(bandInfo.getDescription());
            }
            if (bandInfo.getFlagCoding() != null) {
                product.getFlagCodingGroup().add((ProductNode)bandInfo.getFlagCoding());
                band.setSampleCoding((SampleCoding)bandInfo.getFlagCoding());
            }
            if ((expression = bandInfo.getValidExpression()) != null && expression.trim().length() > 0) {
                band.setValidPixelExpression(expression.trim());
            }
            this.bandlineReaderMap.put((Band)band, bandLineReader);
            product.addBand((Band)band);
        }
        this.setSpectralBandInfo(product);
    }

    private void addDefaultMasksToProduct(Product product) {
        Vector<Band> flagDsList = new Vector<Band>();
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            if (band.getFlagCoding() == null) continue;
            flagDsList.add(band);
        }
        if (!flagDsList.isEmpty()) {
            for (Band flagDs : flagDsList) {
                String flagDsName = flagDs.getName();
                Mask[] masks = this.productFile.createDefaultMasks(flagDsName);
                ProductNodeGroup maskGroup = product.getMaskGroup();
                for (Mask mask : masks) {
                    maskGroup.add((ProductNode)mask);
                }
            }
        }
    }

    private void addDefaultMasksDefsToBands(Product product) {
        for (Band band : product.getBands()) {
            String[] maskNames = this.getDefaultBitmaskNames(band.getName());
            if (maskNames == null) continue;
            for (String maskName : maskNames) {
                Mask mask = (Mask)product.getMaskGroup().get(maskName);
                if (mask == null) continue;
                band.getOverlayMaskGroup().add((ProductNode)mask);
            }
        }
    }

    private String[] getDefaultBitmaskNames(String bandName) {
        return this.productFile.getDefaultBitmaskNames(bandName);
    }

    private void setSpectralBandInfo(Product product) {
        float[] wavelengths = this.productFile.getSpectralBandWavelengths();
        float[] bandwidths = this.productFile.getSpectralBandBandwidths();
        float[] solar_fluxes = this.productFile.getSpectralBandSolarFluxes();
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            int sbi = band.getSpectralBandIndex();
            if (sbi < 0) continue;
            if (wavelengths != null) {
                band.setSpectralWavelength(wavelengths[sbi % wavelengths.length]);
            }
            if (bandwidths != null) {
                band.setSpectralBandwidth(bandwidths[sbi % bandwidths.length]);
            }
            if (solar_fluxes == null) continue;
            band.setSolarFlux(solar_fluxes[sbi % solar_fluxes.length]);
        }
    }

    private void addTiePointGridsToProduct(Product product) throws IOException {
        BandLineReader[] bandLineReaders;
        for (BandLineReader bandLineReader : bandLineReaders = this.getProductFile().getBandLineReaders()) {
            if (!bandLineReader.isTiePointBased()) continue;
            TiePointGrid tiePointGrid = this.createTiePointGrid(bandLineReader);
            product.addTiePointGrid(tiePointGrid);
        }
    }

    private static void addGeoCodingToProduct(Product product) {
        EnvisatProductReader.initTiePointGeoCoding(product);
        Preferences preferences = Config.instance((String)"snap").preferences();
        boolean usePixelGeoCoding = preferences.getBoolean(SYSPROP_ENVISAT_USE_PIXEL_GEO_CODING, false);
        if (usePixelGeoCoding) {
            Band lonBand;
            Band latBand = product.getBand("latitude");
            if (latBand == null) {
                latBand = product.getBand("corr_latitude");
            }
            if ((lonBand = product.getBand("longitude")) == null) {
                lonBand = product.getBand("corr_longitude");
            }
            if (latBand != null && lonBand != null) {
                String validMask = EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(product.getProductType()).matches() ? "NOT l1_flags.INVALID" : "l2_flags.LAND or l2_flags.CLOUD or l2_flags.WATER";
                product.setSceneGeoCoding((GeoCoding)GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)validMask, (int)6));
            }
        }
    }

    public static void initTiePointGeoCoding(Product product) {
        TiePointGrid latGrid = product.getTiePointGrid("latitude");
        TiePointGrid lonGrid = product.getTiePointGrid("longitude");
        if (latGrid != null && lonGrid != null) {
            product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        }
    }

    public static void initPointingFactory(Product product) {
        PointingFactoryRegistry registry = PointingFactoryRegistry.getInstance();
        PointingFactory pointingFactory = registry.getPointingFactory(product.getProductType());
        product.setPointingFactory(pointingFactory);
    }

    private void addHeaderAnnotationsToProduct(Product product) {
        Debug.assertNotNull((Object)this.productFile);
        Debug.assertNotNull((Object)product);
        MetadataElement metaRoot = product.getMetadataRoot();
        metaRoot.addElement(EnvisatProductReader.createMetadataGroup("MPH", this.productFile.getMPH().getParams()));
        metaRoot.addElement(EnvisatProductReader.createMetadataGroup("SPH", this.productFile.getSPH().getParams()));
        DSD[] dsds = this.productFile.getDsds();
        MetadataElement dsdsGroup = new MetadataElement("DSD");
        for (int i = 0; i < dsds.length; ++i) {
            DSD dsd = dsds[i];
            if (dsd == null) continue;
            MetadataElement dsdGroup = new MetadataElement("DSD." + (i + 1));
            dsdGroup.addAttribute(new MetadataAttribute("DATASET_NAME", ProductData.createInstance((String)EnvisatProductReader.getNonNullString(dsd.getDatasetName())), true));
            dsdGroup.addAttribute(new MetadataAttribute("DATASET_TYPE", ProductData.createInstance((String)new String(new char[]{dsd.getDatasetType()})), true));
            dsdGroup.addAttribute(new MetadataAttribute("FILE_NAME", ProductData.createInstance((String)EnvisatProductReader.getNonNullString(dsd.getFileName())), true));
            dsdGroup.addAttribute(new MetadataAttribute("OFFSET", ProductData.createInstance((long[])new long[]{dsd.getDatasetOffset()}), true));
            dsdGroup.addAttribute(new MetadataAttribute("SIZE", ProductData.createInstance((long[])new long[]{dsd.getDatasetSize()}), true));
            dsdGroup.addAttribute(new MetadataAttribute("NUM_RECORDS", ProductData.createInstance((int[])new int[]{dsd.getNumRecords()}), true));
            dsdGroup.addAttribute(new MetadataAttribute("RECORD_SIZE", ProductData.createInstance((int[])new int[]{dsd.getRecordSize()}), true));
            dsdsGroup.addElement(dsdGroup);
        }
        metaRoot.addElement(dsdsGroup);
    }

    private static String getNonNullString(String s) {
        return s != null ? s : "";
    }

    private void addDatasetAnnotationsToProduct(Product product) throws IOException {
        String[] datasetNames;
        Debug.assertNotNull((Object)this.productFile);
        Debug.assertNotNull((Object)product);
        MetadataElement metaRoot = product.getMetadataRoot();
        for (String datasetName : datasetNames = this.productFile.getValidDatasetNames()) {
            DSD dsd = this.productFile.getDSD(datasetName);
            char dsdType = dsd.getDatasetType();
            if (dsdType != 'A' && dsdType != 'G') continue;
            RecordReader recordReader = this.productFile.getRecordReader(datasetName);
            MetadataElement element = EnvisatProductReader.createMetadataElement(datasetName, recordReader);
            metaRoot.addElement(element);
        }
    }

    static MetadataElement createMetadataElement(String datasetName, RecordReader recordReader) throws IOException {
        int numRecords = recordReader.getNumRecords();
        if (numRecords > 1) {
            return EnvisatProductReader.createMetadataTableGroup(datasetName, recordReader);
        }
        if (numRecords == 1) {
            return EnvisatProductReader.createDatasetTable(datasetName, recordReader);
        }
        return null;
    }

    private TiePointGrid createTiePointGrid(BandLineReader bandLineReader) throws IOException {
        BandInfo bandInfo = bandLineReader.getBandInfo();
        String bandName = bandLineReader.getBandName();
        int gridWidth = bandLineReader.getRasterWidth();
        int gridHeight = bandLineReader.getRasterHeight();
        int pixelDataType = bandLineReader.getPixelDataField().getDataType();
        int tiePointIndex = 0;
        double scalingOffset = bandInfo.getScalingOffset();
        double scalingFactor = bandInfo.getScalingFactor();
        float[] tiePoints = new float[gridWidth * gridHeight];
        for (int y = 0; y < gridHeight; ++y) {
            int x;
            Object[] pixelData;
            bandLineReader.readLineRecord(y);
            if (pixelDataType == 10) {
                pixelData = (byte[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((byte[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)pixelData[x]);
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 20) {
                pixelData = (byte[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((byte[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)(pixelData[x] & 0xFF));
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 11) {
                pixelData = (short[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((short[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)pixelData[x]);
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 21) {
                pixelData = (short[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((short[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)(pixelData[x] & 0xFFFF));
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 12) {
                pixelData = (int[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((int[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)pixelData[x]);
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 22) {
                pixelData = (int[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((int[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)((long)pixelData[x] & 0xFFFFFFFFL));
                    ++tiePointIndex;
                }
                continue;
            }
            if (pixelDataType == 30) {
                pixelData = (float[])bandLineReader.getPixelDataField().getElems();
                if (this.getProductFile().storesPixelsInChronologicalOrder()) {
                    ArrayUtils.swapArray((float[])pixelData);
                }
                for (x = 0; x < gridWidth; ++x) {
                    tiePoints[tiePointIndex] = (float)(scalingOffset + scalingFactor * (double)pixelData[x]);
                    ++tiePointIndex;
                }
                continue;
            }
            throw new IllegalFileFormatException("unhandled tie-point data type");
        }
        double offsetX = this.getProductFile().getTiePointGridOffsetX(gridWidth);
        double offsetY = this.getProductFile().getTiePointGridOffsetY(gridWidth);
        double subSamplingX = this.getProductFile().getTiePointSubSamplingX(gridWidth);
        double subSamplingY = this.getProductFile().getTiePointSubSamplingY(gridWidth);
        TiePointGrid tiePointGrid = this.createTiePointGrid(bandName, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints);
        if (bandInfo.getPhysicalUnit() != null) {
            tiePointGrid.setUnit(bandInfo.getPhysicalUnit());
        }
        if (bandInfo.getDescription() != null) {
            tiePointGrid.setDescription(bandInfo.getDescription());
        }
        return tiePointGrid;
    }

    static MetadataElement createDatasetTable(String name, RecordReader recordReader) throws IOException {
        Debug.assertTrue((name != null ? 1 : 0) != 0);
        Debug.assertTrue((recordReader != null ? 1 : 0) != 0);
        Record record = recordReader.readRecord();
        return EnvisatProductReader.createMetadataGroup(name, record);
    }

    static MetadataElement createMetadataTableGroup(String name, RecordReader recordReader) throws IOException {
        Debug.assertTrue((name != null ? 1 : 0) != 0);
        Debug.assertTrue((recordReader != null ? 1 : 0) != 0);
        MetadataElement metadataTableGroup = new MetadataElement(name);
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < recordReader.getNumRecords(); ++i) {
            Record record = recordReader.readRecord(i);
            sb.setLength(0);
            sb.append(name);
            sb.append('.');
            sb.append(i + 1);
            metadataTableGroup.addElement(EnvisatProductReader.createMetadataGroup(sb.toString(), record));
        }
        return metadataTableGroup;
    }

    static MetadataElement createMetadataGroup(String name, Record record) {
        Debug.assertNotNullOrEmpty((String)name);
        Debug.assertNotNull((Object)record);
        MetadataElement metadataGroup = new MetadataElement(name);
        for (int i = 0; i < record.getNumFields(); ++i) {
            Field field = record.getFieldAt(i);
            String description = field.getInfo().getDescription();
            if (description != null && "Spare".equalsIgnoreCase(description)) continue;
            MetadataAttribute attribute = new MetadataAttribute(field.getName(), field.getData(), true);
            if (field.getInfo().getPhysicalUnit() != null) {
                attribute.setUnit(field.getInfo().getPhysicalUnit());
            }
            if (description != null) {
                attribute.setDescription(field.getInfo().getDescription());
            }
            metadataGroup.addAttribute(attribute);
        }
        return metadataGroup;
    }

    protected int getGridDiscontinutity(String name) {
        if (name.equalsIgnoreCase("sun_azimuth") || name.equalsIgnoreCase("view_azimuth")) {
            return 360;
        }
        if (name.equalsIgnoreCase("longitude") || name.equalsIgnoreCase("sun_azimuth_nadir") || name.equalsIgnoreCase("view_azimuth_nadir") || name.equalsIgnoreCase("sun_azimuth_fward") || name.equalsIgnoreCase("view_azimuth_fward")) {
            return 180;
        }
        return 0;
    }
}

