/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.dataio.netcdf.util.DimKey;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class NetcdfOpImage
extends SingleBandedOpImage {
    private final Variable variable;
    private final boolean flipY;
    private final int sourceHeight;
    private final int[] imageOrigin;
    private final Object readLock;
    private final ArrayConverter arrayConverter;
    private final int xIndex;
    private final int yIndex;
    private final int startIndexToCopy;
    private int halfSourceWidth;

    public static RenderedImage createLsbImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return new NetcdfOpImage(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.LSB);
    }

    public static RenderedImage createMsbImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return new NetcdfOpImage(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.MSB);
    }

    public NetcdfOpImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        this(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, ArrayConverter.IDENTITY);
    }

    private NetcdfOpImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, ArrayConverter arrayConverter) {
        this(variable, imageOrigin, flipY, readLock, dataBufferType, sourceWidth, sourceHeight, tileSize, level, arrayConverter, NetcdfOpImage.computeDefaultDimensionIndices(variable));
    }

    protected NetcdfOpImage(Variable variable, int[] imageOrigin, boolean flipY, Object readLock, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, ArrayConverter arrayConverter, DimensionIndices indices) {
        super(dataBufferType, sourceWidth, sourceHeight, tileSize, null, level);
        this.variable = variable;
        this.imageOrigin = (int[])imageOrigin.clone();
        this.readLock = readLock;
        this.flipY = flipY;
        this.halfSourceWidth = sourceWidth / 2;
        this.sourceHeight = sourceHeight;
        this.arrayConverter = arrayConverter;
        this.xIndex = indices.getIndexX();
        this.yIndex = indices.getIndexY();
        this.startIndexToCopy = indices.getStartIndexToCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        Array array;
        Rectangle sourceRect = this.getLevel() != 0 ? this.getSourceRect(destRect) : destRect;
        int rank = this.variable.getRank();
        int[] origin = new int[rank];
        int[] shape = new int[rank];
        int[] stride = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shape[i] = 1;
            origin[i] = 0;
            stride[i] = 1;
        }
        shape[this.yIndex] = sourceRect.height;
        shape[this.xIndex] = sourceRect.width;
        if (this.imageOrigin.length >= 0) {
            System.arraycopy(this.imageOrigin, 0, origin, this.startIndexToCopy, this.imageOrigin.length);
        }
        origin[this.yIndex] = this.flipY ? this.sourceHeight - sourceRect.y - sourceRect.height : sourceRect.y;
        origin[this.xIndex] = sourceRect.x;
        if (this.isGlobalShifted180()) {
            if (sourceRect.x < this.halfSourceWidth && sourceRect.x + sourceRect.width > this.halfSourceWidth) {
                this.computeRect180degShifted(tile, sourceRect, destRect);
                return;
            }
            origin[this.xIndex] = sourceRect.x < this.halfSourceWidth ? sourceRect.x + this.halfSourceWidth : sourceRect.x - this.halfSourceWidth;
        }
        double scale = this.getScale();
        stride[this.yIndex] = (int)scale;
        stride[this.xIndex] = (int)scale;
        Object object = this.readLock;
        synchronized (object) {
            try {
                Section section = new Section(origin, shape, stride);
                array = this.variable.read(section);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.xIndex < this.yIndex) {
            array = array.transpose(this.xIndex, this.yIndex);
        }
        Array convertedArray = this.arrayConverter.convert(array);
        if (this.flipY) {
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, convertedArray.flip(this.yIndex).copyTo1DJavaArray());
        } else {
            Object data = this.xIndex < this.yIndex ? convertedArray.copyTo1DJavaArray() : convertedArray.getStorage();
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, data);
        }
    }

    private boolean isGlobalShifted180() {
        for (Attribute attribute : this.variable.getAttributes()) {
            if (!attribute.getShortName().equals("LONGITUDE_SHIFTED_180")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRect180degShifted(WritableRaster tile, Rectangle sourceRect, Rectangle destRect) {
        Array arrayRight;
        Array arrayLeft;
        int rank = this.variable.getRank();
        int[] originLeft = new int[rank];
        int[] originRight = new int[rank];
        int[] shapeLeft = new int[rank];
        int[] shapeRight = new int[rank];
        int[] stride = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shapeLeft[i] = 1;
            shapeRight[i] = 1;
            originLeft[i] = 0;
            originRight[i] = 0;
            stride[i] = 1;
        }
        shapeLeft[this.yIndex] = sourceRect.height;
        shapeRight[this.yIndex] = sourceRect.height;
        shapeRight[this.xIndex] = this.halfSourceWidth - sourceRect.x;
        shapeLeft[this.xIndex] = sourceRect.width - shapeRight[this.xIndex];
        if (this.imageOrigin.length >= 0) {
            System.arraycopy(this.imageOrigin, 0, originLeft, this.startIndexToCopy, this.imageOrigin.length);
            System.arraycopy(this.imageOrigin, 0, originRight, this.startIndexToCopy, this.imageOrigin.length);
        }
        originLeft[this.yIndex] = this.flipY ? this.sourceHeight - sourceRect.y - sourceRect.height : sourceRect.y;
        originRight[this.yIndex] = this.flipY ? this.sourceHeight - sourceRect.y - sourceRect.height : sourceRect.y;
        originLeft[this.xIndex] = 0;
        originRight[this.xIndex] = sourceRect.x + this.halfSourceWidth;
        double scale = this.getScale();
        stride[this.yIndex] = (int)scale;
        stride[this.xIndex] = (int)scale;
        int halfDestWidth = (int)((double)this.halfSourceWidth / scale);
        Object object = this.readLock;
        synchronized (object) {
            try {
                Section sectionLeft = new Section(originLeft, shapeLeft, stride);
                Section sectionRight = new Section(originRight, shapeRight, stride);
                arrayLeft = this.variable.read(sectionLeft);
                arrayRight = this.variable.read(sectionRight);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.xIndex < this.yIndex) {
            arrayLeft = arrayLeft.transpose(this.xIndex, this.yIndex);
            arrayRight = arrayRight.transpose(this.xIndex, this.yIndex);
        }
        Array convertedArrayLeft = this.arrayConverter.convert(arrayLeft);
        Array convertedArrayRight = this.arrayConverter.convert(arrayRight);
        if (this.flipY) {
            tile.setDataElements(destRect.x, destRect.y, halfDestWidth - destRect.x, destRect.height, convertedArrayRight.flip(this.yIndex).copyTo1DJavaArray());
            tile.setDataElements(halfDestWidth, destRect.y, destRect.width - (halfDestWidth - destRect.x), destRect.height, convertedArrayLeft.flip(this.yIndex).copyTo1DJavaArray());
        } else {
            Object dataRight;
            Object dataLeft;
            if (this.xIndex < this.yIndex) {
                dataLeft = convertedArrayLeft.copyTo1DJavaArray();
                dataRight = convertedArrayRight.copyTo1DJavaArray();
            } else {
                dataLeft = convertedArrayLeft.getStorage();
                dataRight = convertedArrayRight.getStorage();
            }
            tile.setDataElements(destRect.x, destRect.y, halfDestWidth - destRect.x, destRect.height, dataRight);
            tile.setDataElements(halfDestWidth, destRect.y, destRect.width - (halfDestWidth - destRect.x), destRect.height, dataLeft);
        }
    }

    private Rectangle getSourceRect(Rectangle rect) {
        int sourceX = this.getSourceX(rect.x);
        int sourceY = this.getSourceY(rect.y);
        int sourceWidth = this.getSourceWidth(rect.width);
        int sourceHeight = this.getSourceHeight(rect.height);
        return new Rectangle(sourceX, sourceY, sourceWidth, sourceHeight);
    }

    private static DimensionIndices computeDefaultDimensionIndices(Variable variable) {
        List<ucar.nc2.Dimension> variableDimensions = variable.getDimensions();
        DimKey rasterDim = new DimKey(variableDimensions.toArray(new ucar.nc2.Dimension[variableDimensions.size()]));
        int xDimensionIndex = rasterDim.findXDimensionIndex();
        int yDimensionIndex = rasterDim.findYDimensionIndex();
        int startIndexOfBandVariables = DimKey.findStartIndexOfBandVariables(variableDimensions);
        return new DimensionIndices(xDimensionIndex, yDimensionIndex, startIndexOfBandVariables);
    }

    protected static class DimensionIndices {
        private final int xIndex;
        private final int yIndex;
        private final int startIndexToCopy;

        public DimensionIndices(int xDimensionIndex, int yDimensionIndex, int startIndexOfBandVariables) {
            this.xIndex = xDimensionIndex;
            this.yIndex = yDimensionIndex;
            this.startIndexToCopy = startIndexOfBandVariables;
        }

        protected int getIndexX() {
            return this.xIndex;
        }

        protected int getIndexY() {
            return this.yIndex;
        }

        protected int getStartIndexToCopy() {
            return this.startIndexToCopy;
        }
    }

    protected static interface ArrayConverter {
        public static final ArrayConverter IDENTITY = array -> array;
        public static final ArrayConverter LSB = array -> {
            Array convertedArray = Array.factory(DataType.INT, array.getShape());
            int i = 0;
            while ((long)i < convertedArray.getSize()) {
                convertedArray.setInt(i, (int)(array.getLong(i) & 0xFFFFFFFFL));
                ++i;
            }
            return convertedArray;
        };
        public static final ArrayConverter MSB = array -> {
            Array convertedArray = Array.factory(DataType.INT, array.getShape());
            int i = 0;
            while ((long)i < convertedArray.getSize()) {
                convertedArray.setInt(i, (int)(array.getLong(i) >>> 32));
                ++i;
            }
            return convertedArray;
        };

        public Array convert(Array var1);
    }
}

