/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfHdfEosGeoInfoExtractor;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGeocodingPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DimKey;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CfGeocodingPart
extends ProfilePartIO {
    private boolean geographicCRS;
    private boolean latLonVarsAddedByGeocoding;
    private String latVarName;
    private String lonVarName;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        GeoCoding geoCoding = CfGeocodingPart.readConventionBasedMapGeoCoding(ctx, p);
        if (geoCoding == null) {
            geoCoding = CfGeocodingPart.readPixelGeoCoding(p);
        }
        if (geoCoding == null && this.hasHdfMetadataOrigin(ctx.getNetcdfFile().getGlobalAttributes())) {
            this.hdfDecode(ctx, p);
        }
        if (geoCoding != null) {
            p.setSceneGeoCoding(geoCoding);
        }
    }

    private void hdfDecode(ProfileReadContext ctx, Product p) throws IOException {
        CfHdfEosGeoInfoExtractor cfHdfEosGeoInfoExtractor = new CfHdfEosGeoInfoExtractor(ctx.getNetcdfFile().getGlobalAttributes());
        cfHdfEosGeoInfoExtractor.extractInfo();
        String projection = cfHdfEosGeoInfoExtractor.getProjection();
        double upperLeftLon = cfHdfEosGeoInfoExtractor.getUlLon();
        double upperLeftLat = cfHdfEosGeoInfoExtractor.getUlLat();
        double lowerRightLon = cfHdfEosGeoInfoExtractor.getLrLon();
        double lowerRightLat = cfHdfEosGeoInfoExtractor.getLrLat();
        HdfEosGeocodingPart.attachGeoCoding(p, upperLeftLon, upperLeftLat, lowerRightLon, lowerRightLat, projection, null);
    }

    private boolean hasHdfMetadataOrigin(List<Attribute> netcdfAttributes) {
        for (Attribute att : netcdfAttributes) {
            if (!att.getShortName().startsWith("StructMetadata")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product product) throws IOException {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return;
        }
        this.geographicCRS = CfGeocodingPart.isGeographicCRS(geoCoding);
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        boolean latLonPresent = this.isLatLonPresent(ncFile);
        if (!latLonPresent) {
            if (this.geographicCRS) {
                GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.5, 0.5), null);
                int w = product.getSceneRasterWidth();
                int h = product.getSceneRasterHeight();
                GeoPos br = geoCoding.getGeoPos(new PixelPos((double)((float)w - 0.5f), (double)((float)h - 0.5f)), null);
                this.latVarName = "lat";
                this.lonVarName = "lon";
                this.addGeographicCoordinateVariables(ncFile, ul, br, this.latVarName, this.lonVarName);
            } else {
                this.addLatLonBands(ncFile, ImageManager.getPreferredTileSize((Product)product));
            }
            this.latLonVarsAddedByGeocoding = true;
        } else if (this.geographicCRS) {
            GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.5, 0.5), null);
            int w = product.getSceneRasterWidth();
            int h = product.getSceneRasterHeight();
            GeoPos br = geoCoding.getGeoPos(new PixelPos((double)((float)w - 0.5f), (double)((float)h - 0.5f)), null);
            this.latVarName = "lat_intern";
            this.lonVarName = "lon_intern";
            this.latLonVarsAddedByGeocoding = true;
            this.addGeographicCoordinateVariables(ncFile, ul, br, this.latVarName, this.lonVarName);
        }
        ctx.setProperty("yFlipped", false);
    }

    private boolean isLatLonPresent(NFileWriteable ncFile) {
        return ncFile.findVariable("lat") != null && ncFile.findVariable("lon") != null;
    }

    @Override
    public void encode(ProfileWriteContext ctx, Product product) throws IOException {
        if (!this.latLonVarsAddedByGeocoding) {
            return;
        }
        int h = product.getSceneRasterHeight();
        int w = product.getSceneRasterWidth();
        GeoCoding geoCoding = product.getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        NVariable latVariable = ncFile.findVariable(this.latVarName);
        NVariable lonVariable = ncFile.findVariable(this.lonVarName);
        if (this.geographicCRS) {
            double[] lat = new double[h];
            double[] lon = new double[w];
            pixelPos.x = 0.5;
            for (int y = 0; y < h; ++y) {
                pixelPos.y = (float)y + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                lat[y] = geoPos.getLat();
            }
            pixelPos.y = 0.5;
            for (int x = 0; x < w; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                lon[x] = geoPos.getLon();
            }
            latVariable.writeFully(Array.factory(lat));
            lonVariable.writeFully(Array.factory(lon));
        } else {
            double[] lat = new double[w];
            double[] lon = new double[w];
            boolean isYFlipped = (Boolean)ctx.getProperty("yFlipped");
            for (int y = 0; y < h; ++y) {
                pixelPos.y = (float)y + 0.5f;
                for (int x = 0; x < w; ++x) {
                    pixelPos.x = (float)x + 0.5f;
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    lat[x] = geoPos.getLat();
                    lon[x] = geoPos.getLon();
                }
                latVariable.write(0, y, w, 1, isYFlipped, ProductData.createInstance((double[])lat));
                lonVariable.write(0, y, w, 1, isYFlipped, ProductData.createInstance((double[])lon));
            }
        }
    }

    static boolean isGeographicCRS(GeoCoding geoCoding) {
        return (geoCoding instanceof CrsGeoCoding || geoCoding instanceof MapGeoCoding) && CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
    }

    private void addGeographicCoordinateVariables(NFileWriteable ncFile, GeoPos ul, GeoPos br, String latVarName, String lonVarName) throws IOException {
        NVariable lat = ncFile.addVariable(latVarName, DataType.DOUBLE, null, latVarName);
        lat.addAttribute("units", "degrees_north");
        lat.addAttribute("long_name", "latitude");
        lat.addAttribute("standard_name", "latitude");
        lat.addAttribute("valid_min", br.getLat());
        lat.addAttribute("valid_max", ul.getLat());
        NVariable lon = ncFile.addVariable(lonVarName, DataType.DOUBLE, null, lonVarName);
        lon.addAttribute("units", "degrees_east");
        lon.addAttribute("long_name", "longitude");
        lon.addAttribute("standard_name", "longitude");
        lon.addAttribute("valid_min", ul.getLon());
        lon.addAttribute("valid_max", br.getLon());
    }

    private void addLatLonBands(NFileWriteable ncFile, Dimension tileSize) throws IOException {
        NVariable lat = ncFile.addVariable("lat", DataType.DOUBLE, tileSize, "y x");
        lat.addAttribute("units", "degrees_north");
        lat.addAttribute("long_name", "latitude coordinate");
        lat.addAttribute("standard_name", "latitude");
        NVariable lon = ncFile.addVariable("lon", DataType.DOUBLE, tileSize, "y x");
        lon.addAttribute("units", "degrees_east");
        lon.addAttribute("long_name", "longitude coordinate");
        lon.addAttribute("standard_name", "longitude");
    }

    private static GeoCoding readConventionBasedMapGeoCoding(ProfileReadContext ctx, Product product) {
        String[] cfConvention_lonLatNames = new String[]{"lon", "lat"};
        String[] coardsConvention_lonLatNames = new String[]{"longitude", "latitude"};
        List<Variable> variableList = ctx.getNetcdfFile().getVariables();
        Variable[] lonLat = ReaderUtils.getVariables(variableList, cfConvention_lonLatNames);
        if (lonLat == null) {
            lonLat = ReaderUtils.getVariables(variableList, coardsConvention_lonLatNames);
        }
        if (lonLat != null) {
            Variable lonVariable = lonLat[0];
            Variable latVariable = lonLat[1];
            DimKey rasterDim = ctx.getRasterDigest().getRasterDim();
            if (rasterDim.fitsTo(lonVariable, latVariable)) {
                try {
                    return CfGeocodingPart.createConventionBasedMapGeoCoding(lonVariable, latVariable, product.getSceneRasterWidth(), product.getSceneRasterHeight(), ctx);
                }
                catch (Exception e) {
                    SystemUtils.LOG.warning("Failed to create NetCDF geo-coding");
                }
            }
        }
        return null;
    }

    private static GeoCoding createConventionBasedMapGeoCoding(Variable lon, Variable lat, int sceneRasterWidth, int sceneRasterHeight, ProfileReadContext ctx) throws Exception {
        double northing;
        boolean yFlipped;
        Array lonData = lon.read();
        if (CfGeocodingPart.isGlobalShifted180(lonData)) {
            List<Variable> variables = ctx.getNetcdfFile().getVariables();
            for (Variable next : variables) {
                next.getAttributes().add(new Attribute("LONGITUDE_SHIFTED_180", 1));
            }
            int i = 0;
            while ((long)i < lonData.getSize()) {
                Index ii = lonData.getIndex().set(i);
                double theLon = lonData.getDouble(ii) - 180.0;
                lonData.setDouble(ii, theLon);
                ++i;
            }
        }
        double sum = 0.0;
        int i = 0;
        while ((long)i < lonData.getSize() - 1L) {
            double delta = (lonData.getDouble(i + 1) - lonData.getDouble(i) + 360.0) % 360.0;
            sum += delta;
            ++i;
        }
        double pixelSizeX = sum / (double)(sceneRasterWidth - 1);
        Index i0 = lonData.getIndex().set(0);
        double easting = lonData.getDouble(i0);
        int latSize = lat.getShape(0);
        Array latData = lat.read();
        Index j0 = latData.getIndex().set(0);
        Index j1 = latData.getIndex().set(latSize - 1);
        double pixelSizeY = (latData.getDouble(j1) - latData.getDouble(j0)) / (double)(sceneRasterHeight - 1);
        double pixelX = 0.5;
        double pixelY = 0.5;
        if (pixelSizeY < 0.0) {
            pixelSizeY = -pixelSizeY;
            yFlipped = false;
            northing = latData.getDouble(latData.getIndex().set(0));
        } else {
            yFlipped = true;
            northing = latData.getDouble(latData.getIndex().set(latSize - 1));
        }
        if (pixelSizeX <= 0.0 || pixelSizeY <= 0.0) {
            return null;
        }
        ctx.setProperty("yFlipped", yFlipped);
        return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, sceneRasterWidth, sceneRasterHeight, easting, northing, pixelSizeX, pixelSizeY, pixelX, pixelY);
    }

    static boolean isGlobalShifted180(Array lonData) {
        Index i0 = lonData.getIndex().set(0);
        Index i1 = lonData.getIndex().set(1);
        Index iN = lonData.getIndex().set((int)lonData.getSize() - 1);
        double lonDelta = lonData.getDouble(i1) - lonData.getDouble(i0);
        double firstValue = lonData.getDouble(0);
        double lastValue = lonData.getDouble(iN);
        return firstValue >= 0.0 && firstValue <= lonDelta && lastValue >= 360.0 - lonDelta && lastValue <= 360.0;
    }

    private static GeoCoding readPixelGeoCoding(Product product) throws IOException {
        Band latBand;
        Band lonBand = product.getBand("lon");
        if (lonBand == null) {
            lonBand = product.getBand("longitude");
        }
        if ((latBand = product.getBand("lat")) == null) {
            latBand = product.getBand("latitude");
        }
        if (latBand != null && lonBand != null) {
            return GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)latBand.getValidMaskExpression(), (int)5);
        }
        return null;
    }
}

