/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import com.bc.ceres.binding.PropertyContainer;
import java.awt.Color;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamMaskPart
extends ProfilePartIO {
    public static final String EXPRESSION = "expression";
    public static final String COLOR = "color";
    public static final String MASK_OVERLAYS = "mask_overlays";
    public static final String TRANSPARENCY = "transparency";
    public static final int INDEX_RED = 0;
    public static final int INDEX_GREEN = 1;
    public static final int INDEX_BLUE = 2;
    public static final int INDEX_ALPHA = 3;
    public static final String SUFFIX_MASK = "_mask";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        BeamMaskPart.readMasks(ctx, p);
        BeamMaskPart.readMaskOverlays(ctx, p);
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        BeamMaskPart.writeMasks(p, ncFile);
        BeamMaskPart.writeMaskOverlays(p, ncFile);
    }

    private static void readMasks(ProfileReadContext ctx, Product p) throws ProductIOException {
        for (Variable variable : ctx.getNetcdfFile().getVariables()) {
            Attribute colorAttribute;
            String maskName;
            Attribute expressionAttribute;
            if (variable.getRank() != 0 || !variable.getFullName().endsWith(SUFFIX_MASK) || (expressionAttribute = variable.findAttribute(EXPRESSION)) == null || !expressionAttribute.isString()) continue;
            Attribute nameAttribute = variable.findAttribute("orig_name");
            if (nameAttribute != null) {
                maskName = nameAttribute.getStringValue();
            } else {
                String variableName = variable.getFullName();
                maskName = variableName.substring(0, variableName.lastIndexOf(SUFFIX_MASK));
            }
            Mask mask = new Mask(maskName, p.getSceneRasterWidth(), p.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
            mask.setDescription(variable.getDescription());
            Attribute transparencyAttribute = variable.findAttribute(TRANSPARENCY);
            if (transparencyAttribute != null) {
                mask.setImageTransparency(transparencyAttribute.getNumericValue().doubleValue());
            }
            if ((colorAttribute = variable.findAttribute(COLOR)) != null && colorAttribute.getLength() >= 3 && colorAttribute.getLength() <= 4) {
                mask.setImageColor(BeamMaskPart.createColor(colorAttribute));
            }
            PropertyContainer imageConfig = mask.getImageConfig();
            String expression = expressionAttribute.getStringValue();
            imageConfig.setValue(EXPRESSION, (Object)expression);
            p.getMaskGroup().add((ProductNode)mask);
        }
    }

    private static Color createColor(Attribute colorAttribute) {
        Color color;
        int r = colorAttribute.getNumericValue(0).intValue();
        int g = colorAttribute.getNumericValue(1).intValue();
        int b = colorAttribute.getNumericValue(2).intValue();
        if (colorAttribute.getLength() > 3) {
            int a = colorAttribute.getNumericValue(3).intValue();
            color = new Color(r, g, b, a);
        } else {
            color = new Color(r, g, b);
        }
        return color;
    }

    private static void readMaskOverlays(ProfileReadContext ctx, Product p) {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        for (Band band : p.getBands()) {
            String[] maskNames;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Variable variable = netcdfFile.getRootGroup().findVariable(variableName);
            Attribute attribute = variable.findAttribute(MASK_OVERLAYS);
            if (attribute == null) continue;
            ProductNodeGroup maskGroup = p.getMaskGroup();
            for (String maskName : maskNames = attribute.getStringValue().split(" ")) {
                Mask mask = (Mask)maskGroup.get(maskName);
                if (mask == null) continue;
                band.getOverlayMaskGroup().add((ProductNode)mask);
            }
        }
    }

    private static void writeMasks(Product p, NFileWriteable ncFile) throws IOException {
        String[] maskNames;
        ProductNodeGroup maskGroup = p.getMaskGroup();
        for (String maskName : maskNames = maskGroup.getNodeNames()) {
            Mask mask = (Mask)maskGroup.get(maskName);
            if (Mask.BandMathsType.INSTANCE == mask.getImageType()) {
                String description;
                String variableName = ReaderUtils.getVariableName((RasterDataNode)mask);
                NVariable variable = ncFile.addScalarVariable(variableName + SUFFIX_MASK, DataType.BYTE);
                if (!variableName.equals(maskName)) {
                    variable.addAttribute("orig_name", maskName);
                }
                if ((description = mask.getDescription()) != null && description.trim().length() > 0) {
                    variable.addAttribute("title", description);
                }
                PropertyContainer imageConfig = mask.getImageConfig();
                String expression = (String)imageConfig.getValue(EXPRESSION);
                variable.addAttribute(EXPRESSION, expression);
                Color color = mask.getImageColor();
                int[] colorValues = new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
                variable.addAttribute(COLOR, Array.factory(colorValues));
                double transparency = mask.getImageTransparency();
                variable.addAttribute(TRANSPARENCY, transparency);
                continue;
            }
            if (Mask.RangeType.INSTANCE != mask.getImageType() && Mask.VectorDataType.INSTANCE != mask.getImageType()) continue;
        }
    }

    private static void writeMaskOverlays(Product p, NFileWriteable ncFile) throws IOException {
        for (Band band : p.getBands()) {
            ProductNodeGroup maskGroup = band.getOverlayMaskGroup();
            if (maskGroup.getNodeCount() < 1) continue;
            String[] maskNames = maskGroup.getNodeNames();
            StringBuilder overlayNames = new StringBuilder();
            for (String maskName : maskNames) {
                overlayNames.append(maskName).append(" ");
            }
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            NVariable variable = ncFile.findVariable(variableName);
            if (variable == null) continue;
            variable.addAttribute(MASK_OVERLAYS, overlayNames.toString().trim());
        }
    }
}

