/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.normalize;

import java.util.Iterator;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.core.SparseInstance;
import net.sf.javaml.core.exception.TrainingRequiredException;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.filter.instance.ReplaceValueFilter;
import net.sf.javaml.tools.DatasetTools;

public class NormalizeMidrange
extends AbstractFilter {
    private double normalMiddle;
    private double normalRange;
    private Instance currentRange = null;
    private Instance currentMiddle = null;

    public NormalizeMidrange() {
        this(0.0, 2.0);
    }

    public NormalizeMidrange(double middle, double range) {
        this.normalMiddle = middle;
        this.normalRange = range;
    }

    @Override
    public void build(Dataset data) {
        Instance max = DatasetTools.maxAttributes(data);
        Instance min = DatasetTools.minAttributes(data);
        this.currentRange = max.minus(min);
        this.currentMiddle = min.add(max).divide(2.0);
    }

    @Override
    public void filter(Instance instance) {
        if (this.currentRange == null || this.currentMiddle == null) {
            throw new TrainingRequiredException();
        }
        if (instance instanceof DenseInstance) {
            Instance tmp = instance.minus(this.currentMiddle).divide(this.currentRange).multiply(this.normalRange).add(this.normalMiddle);
            instance.clear();
            instance.putAll(tmp);
        }
        if (instance instanceof SparseInstance) {
            Iterator i$ = instance.keySet().iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                instance.put(index, (instance.value(index) - this.currentMiddle.value(index)) / this.currentRange.value(index) * this.normalRange + this.normalMiddle);
            }
        }
        new ReplaceValueFilter(Double.NEGATIVE_INFINITY, this.normalMiddle).filter(instance);
        new ReplaceValueFilter(Double.POSITIVE_INFINITY, this.normalMiddle).filter(instance);
        new ReplaceValueFilter(Double.NaN, this.normalMiddle).filter(instance);
    }

    @Override
    public void filter(Dataset data) {
        if (this.currentRange == null || this.currentMiddle == null) {
            this.build(data);
        }
        for (Instance i : data) {
            this.filter(i);
        }
    }
}

