/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.scoring;

import java.util.Vector;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.featureselection.FeatureScoring;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.filter.discretize.EqualWidthBinning;
import net.sf.javaml.tools.DatasetTools;
import net.sf.javaml.utils.ContingencyTables;

public class SymmetricalUncertainty
implements FeatureScoring {
    private Dataset training;
    private int bins = 10;

    @Override
    public void build(Dataset data) {
        EqualWidthBinning discretize = new EqualWidthBinning(this.bins);
        ((AbstractFilter)discretize).build(data);
        ((AbstractFilter)discretize).filter(data);
        Instance min = DatasetTools.minAttributes(data);
        Instance max = DatasetTools.maxAttributes(data);
        for (int i = 0; i < data.noAttributes(); ++i) {
            if (min.value(i) == 0.0 && max.value(i) == 9.0) continue;
            System.err.println(i + " " + min.value(i) + "\t" + max.value(i));
        }
        this.training = data;
    }

    @Override
    public double score(int attribute) {
        double[][] counts = new double[this.bins][this.training.classes().size()];
        Vector<Object> classes = new Vector<Object>();
        classes.addAll(this.training.classes());
        for (Instance inst : this.training) {
            if ((int)inst.value(attribute) >= this.bins) {
                System.err.println("Exceeding bins: " + this.bins);
            }
            if (classes.indexOf(inst.classValue()) >= this.training.classes().size()) {
                System.err.println("Exceeding classes: " + this.training.classes().size());
            }
            double[] dArray = counts[(int)inst.value(attribute)];
            int n = classes.indexOf(inst.classValue());
            dArray[n] = dArray[n] + 1.0;
        }
        return ContingencyTables.symmetricalUncertainty(counts);
    }

    @Override
    public int noAttributes() {
        return this.training.noAttributes();
    }
}

