/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw.dtw;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import net.sf.javaml.distance.fastdtw.dtw.CostMatrix;
import net.sf.javaml.distance.fastdtw.dtw.SearchWindow;
import net.sf.javaml.distance.fastdtw.lang.TypeConversions;

class SwapFileMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private static final Random RAND_GEN = new Random();
    private final SearchWindow window;
    private double[] lastCol;
    private double[] currCol;
    private int currColIndex;
    private int minLastRow;
    private int minCurrRow;
    private File swapFile;
    private RandomAccessFile cellValuesFile;
    private boolean isSwapFileFreed;
    private long[] colOffsets;

    SwapFileMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        if (this.window.maxI() > 0) {
            this.currCol = new double[this.window.maxJforI(1) - this.window.minJforI(1) + 1];
            this.currColIndex = 1;
            this.minLastRow = this.window.minJforI(this.currColIndex - 1);
        } else {
            this.currColIndex = 0;
        }
        this.minCurrRow = this.window.minJforI(this.currColIndex);
        this.lastCol = new double[this.window.maxJforI(0) - this.window.minJforI(0) + 1];
        try {
            this.swapFile = File.createTempFile("swap", "dat");
            this.swapFile.deleteOnExit();
            this.isSwapFileFreed = false;
            this.colOffsets = new long[this.window.maxI() + 1];
            this.cellValuesFile = new RandomAccessFile(this.swapFile, "rw");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void put(int col, int row, double value) {
        if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
            throw new InternalError("CostMatrix is filled in a cell (col=" + col + ", row=" + row + ") that is not in the " + "search window");
        }
        if (col == this.currColIndex) {
            this.currCol[row - this.minCurrRow] = value;
        } else if (col == this.currColIndex - 1) {
            this.lastCol[row - this.minLastRow] = value;
        } else if (col == this.currColIndex + 1) {
            try {
                if (this.isSwapFileFreed) {
                    throw new InternalError("The SwapFileMatrix has been freeded by the freeMem() method");
                }
                this.cellValuesFile.seek(this.cellValuesFile.length());
                this.colOffsets[this.currColIndex - 1] = this.cellValuesFile.getFilePointer();
                this.cellValuesFile.write(TypeConversions.doubleArrayToByteArray(this.lastCol));
            }
            catch (IOException e) {
                throw new InternalError("Unable to fill the CostMatrix in the Swap file (IOException)");
            }
            this.lastCol = this.currCol;
            this.minLastRow = this.minCurrRow;
            this.minCurrRow = this.window.minJforI(col);
            ++this.currColIndex;
            this.currCol = new double[this.window.maxJforI(col) - this.window.minJforI(col) + 1];
            this.currCol[row - this.minCurrRow] = value;
        } else {
            throw new InternalError("A SwapFileMatrix can only fill in 2 adjacentcolumns at a time");
        }
    }

    @Override
    public double get(int col, int row) {
        try {
            if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
                return Double.POSITIVE_INFINITY;
            }
            if (col == this.currColIndex) {
                return this.currCol[row - this.minCurrRow];
            }
            if (col == this.currColIndex - 1) {
                return this.lastCol[row - this.minLastRow];
            }
            if (this.isSwapFileFreed) {
                throw new InternalError("The SwapFileMatrix has been freeded by the freeMem() method");
            }
            this.cellValuesFile.seek(this.colOffsets[col] + (long)(8 * (row - this.window.minJforI(col))));
            return this.cellValuesFile.readDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (col > this.currColIndex) {
                throw new InternalError("The requested value is in the search window but has not been entered into the matrix: (col=" + col + "row=" + row + ").");
            }
            throw new InternalError("Unable to read CostMatrix in the Swap file (IOException)");
        }
    }

    @Override
    public int size() {
        return this.window.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeMem() {
        try {
            this.cellValuesFile.close();
        }
        catch (IOException e) {
            System.err.println("unable to close swap file '" + this.swapFile.getPath() + "'");
        }
        finally {
            if (!this.swapFile.delete()) {
                System.err.println("unable to delete swap file '" + this.swapFile.getPath() + "'");
            }
        }
    }
}

