/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import java.util.Random;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class FarthestFirst
implements Clusterer {
    private Dataset data;
    private int m_NumClusters = 2;
    private Instance[] centroids;
    private DistanceMeasure dm;
    private Random rg;

    private void updateMinDistance(double[] minDistance, boolean[] selected, Instance center) {
        for (int i = 0; i < selected.length; ++i) {
            double d;
            if (selected[i] || !((d = this.dm.measure(center, this.data.instance(i))) < minDistance[i])) continue;
            minDistance[i] = d;
        }
    }

    private int farthestAway(double[] minDistance, boolean[] selected) {
        double maxDistance = -1.0;
        int maxI = -1;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] || !(maxDistance < minDistance[i])) continue;
            maxDistance = minDistance[i];
            maxI = i;
        }
        return maxI;
    }

    public FarthestFirst() {
        this(4, new EuclideanDistance());
    }

    public FarthestFirst(int numClusters, DistanceMeasure dm) {
        this.m_NumClusters = numClusters;
        this.dm = dm;
        this.rg = new Random(System.currentTimeMillis());
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        int i;
        this.data = data;
        this.centroids = new Instance[this.m_NumClusters];
        int n = data.size();
        boolean[] selected = new boolean[n];
        double[] minDistance = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            minDistance[i2] = Double.MAX_VALUE;
        }
        int firstI = this.rg.nextInt(n);
        this.centroids[0] = data.instance(firstI);
        selected[firstI] = true;
        this.updateMinDistance(minDistance, selected, data.instance(firstI));
        if (this.m_NumClusters > n) {
            this.m_NumClusters = n;
        }
        for (int i3 = 1; i3 < this.m_NumClusters; ++i3) {
            int nextI = this.farthestAway(minDistance, selected);
            this.centroids[i3] = data.instance(nextI);
            selected[nextI] = true;
            this.updateMinDistance(minDistance, selected, data.instance(nextI));
        }
        Dataset[] clusters = new Dataset[this.m_NumClusters];
        for (i = 0; i < this.m_NumClusters; ++i) {
            clusters[i] = new DefaultDataset();
        }
        for (i = 0; i < data.size(); ++i) {
            Instance inst = data.instance(i);
            double min = this.dm.measure(inst, this.centroids[0]);
            int index = 0;
            for (int j = 1; j < this.m_NumClusters; ++j) {
                double tmp = this.dm.measure(inst, this.centroids[j]);
                if (!(tmp < min)) continue;
                min = tmp;
                index = j;
            }
            clusters[index].add(inst);
        }
        return clusters;
    }
}

