/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import java.util.Vector;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;
import net.sf.javaml.utils.GammaFunction;
import net.sf.javaml.utils.MathUtils;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;

public class AQBC
implements Clusterer {
    private double RADNW;
    private int E;
    private Dataset data;
    private boolean normalize;
    private Vector<Dataset> clusters = new Vector();
    private DistanceMeasure dm;
    private double S = 0.95f;
    private double EXTTRESH2;
    private double[] ME;

    @Override
    public Dataset[] cluster(Dataset data) {
        this.data = data;
        this.dm = new EuclideanDistance();
        Vector<TaggedInstance> SP = this.normalize ? this.normalize(data) : this.dontnormalize(data);
        System.out.println("Remaining datapoints = " + SP.size());
        int NRNOCONV = 0;
        int maxNRNOCONV = 2;
        int TOOFEWPOINTS = 0;
        int TFPTH = 10;
        int BPR = 0;
        int RRES = 0;
        int BPRTH = 10;
        double REITERTHR = 0.1;
        this.E = data.noAttributes();
        if (this.E > 170) {
            throw new RuntimeException("AQBC is unable to work for more than 170 dimensions! This is a limitation of the Gamma function");
        }
        double R = Math.sqrt(this.E - 1);
        double EXTTRESH = R / 2.0;
        int MINNRGENES = 2;
        int cluster = 0;
        while (NRNOCONV < maxNRNOCONV && TOOFEWPOINTS < TFPTH && BPR < BPRTH && RRES < 2) {
            boolean clusterLocalisationConverged = this.wan_shr_adap(SP, EXTTRESH);
            if (!clusterLocalisationConverged) continue;
            System.out.println("Found cluster -> EM");
            System.out.println("Starting EM");
            boolean emConverged = this.exp_max(SP, this.ME, this.EXTTRESH2, this.S);
            if (emConverged) {
                System.out.println("EM converged, predicting radius...");
                NRNOCONV = 0;
                if (Math.abs(this.RADNW - EXTTRESH) / EXTTRESH < REITERTHR) {
                    Vector<TaggedInstance> Q = this.retrieveInstances(SP, this.ME, this.RADNW);
                    if (Q.size() == 0) {
                        System.err.println("Significance level not reached");
                    }
                    if (Q.size() > MINNRGENES) {
                        this.outputCluster(Q, ++cluster);
                        this.removeInstances(SP, Q);
                        TOOFEWPOINTS = 0;
                        EXTTRESH = this.RADNW;
                    } else {
                        this.removeInstances(SP, Q);
                        ++TOOFEWPOINTS;
                    }
                } else {
                    EXTTRESH = this.RADNW;
                    if (++BPR == BPRTH) {
                        System.out.println("Radius cannot be predicted!");
                    } else {
                        System.out.println("Trying new radius...");
                    }
                }
            } else if (++NRNOCONV < maxNRNOCONV) {
                EXTTRESH = R / 2.0;
                System.out.println("Resetting radius to: " + EXTTRESH);
                if (++RRES == 2) {
                    System.out.println("No convergence: Algorithm aborted - RRES exceeded!");
                    break;
                }
                BPR = 0;
            } else {
                System.out.println("No convergence: Algorithm aborted - NRNOCONV exceeded!");
                break;
            }
            if (TOOFEWPOINTS != TFPTH) continue;
            System.out.println("No more significant clusters found: Algorithms aborted!");
            break;
        }
        Dataset[] output = new Dataset[this.clusters.size()];
        for (int i = 0; i < this.clusters.size(); ++i) {
            output[i] = this.clusters.get(i);
        }
        return output;
    }

    private Vector<TaggedInstance> dontnormalize(Dataset data) {
        Vector<TaggedInstance> out = new Vector<TaggedInstance>();
        for (int i = 0; i < data.size(); ++i) {
            out.add(new TaggedInstance(data.instance(i), i));
        }
        return out;
    }

    private Vector<TaggedInstance> normalize(Dataset data) {
        Vector<TaggedInstance> out = new Vector<TaggedInstance>();
        for (int i = 0; i < data.size(); ++i) {
            Double[] old = data.instance(i).values().toArray(new Double[0]);
            double[] conv = new double[old.length];
            for (int j = 0; j < old.length; ++j) {
                conv[j] = old[j];
            }
            StandardDeviation std = new StandardDeviation();
            Mean m = new Mean();
            double MU = m.evaluate(conv);
            double SIGM = std.evaluate(conv, MU);
            if (MathUtils.eq(SIGM, 0.0)) continue;
            double[] val = new double[old.length];
            for (int j = 0; j < old.length; ++j) {
                val[j] = (float)((old[j] - MU) / SIGM);
            }
            out.add(new TaggedInstance(new DenseInstance(val, data.instance(i).classValue()), i));
        }
        return out;
    }

    private void removeInstances(Vector<TaggedInstance> sp, Vector<TaggedInstance> q) {
        sp.removeAll(q);
    }

    public AQBC(double significance) {
        this(significance, true);
    }

    public AQBC() {
        this(0.95);
    }

    public AQBC(double sig, boolean normalize) {
        this.normalize = normalize;
        this.S = sig;
    }

    private void outputCluster(Vector<TaggedInstance> q, int index) {
        DefaultDataset tmp = new DefaultDataset();
        for (TaggedInstance i : q) {
            tmp.add(this.data.instance(i.getTag()));
        }
        this.clusters.add(tmp);
    }

    private Vector<TaggedInstance> retrieveInstances(Vector<TaggedInstance> sp, double[] me2, double radnw2) {
        DenseInstance tmp = new DenseInstance(me2);
        Vector<TaggedInstance> out = new Vector<TaggedInstance>();
        for (TaggedInstance inst : sp) {
            if (!(this.dm.measure(inst.inst, tmp) < radnw2)) continue;
            out.add(inst);
        }
        return out;
    }

    private boolean exp_max(Vector<TaggedInstance> AS, double[] CK, double QUAL, double S) {
        double D = this.E - 2;
        double R = Math.sqrt(this.E - 1);
        double[] RD = this.calculateDistances(AS, CK);
        int samples = RD.length;
        int MAXITER = 500;
        double CDIF = 0.001;
        double count = 0.0;
        for (int i = 0; i < RD.length; ++i) {
            if (!(RD[i] < QUAL)) continue;
            count += 1.0;
        }
        double PC = count / (double)RD.length;
        double PB = 1.0 - PC;
        double tmpVAR = 0.0;
        for (int i = 0; i < RD.length; ++i) {
            if (!(RD[i] < QUAL)) continue;
            tmpVAR += RD[i] * RD[i];
        }
        double VAR = 1.0 / D * tmpVAR / count;
        boolean CONV = false;
        for (int i = 0; i < MAXITER && !CONV; ++i) {
            double[] prc = this.clusterdistrib(RD, VAR, D, R);
            double[] prb = this.background(RD, D, R);
            double[] prcpc = new double[prc.length];
            for (int j = 0; j < prc.length; ++j) {
                prcpc[j] = prc[j] * PC;
            }
            double[] prbpb = new double[prb.length];
            for (int j = 0; j < prb.length; ++j) {
                prbpb[j] = prb[j] * PB;
            }
            double[] pr = new double[prcpc.length];
            for (int j = 0; j < prc.length; ++j) {
                pr[j] = prcpc[j] + prbpb[j];
            }
            double[] pcr = new double[prcpc.length];
            for (int j = 0; j < prc.length; ++j) {
                pcr[j] = prcpc[j] / pr[j];
            }
            double SM = 0.0;
            for (int j = 0; j < prc.length; ++j) {
                SM += pcr[j];
            }
            if (MathUtils.eq(SM, 0.0) || Double.isInfinite(SM)) {
                i = MAXITER;
            }
            float tmpVAR_new = 0.0f;
            for (int j = 0; j < prc.length; ++j) {
                tmpVAR_new = (float)((double)tmpVAR_new + RD[j] * RD[j] * pcr[j]);
            }
            double VAR_new = 1.0 / D * (double)tmpVAR_new / SM;
            double PC_new = SM / (double)samples;
            double PB_new = 1.0 - PC_new;
            if (Math.abs(VAR_new - VAR) < CDIF && Math.abs(PC_new - PC) < CDIF) {
                CONV = true;
            }
            PC = PC_new;
            PB = PB_new;
            VAR = VAR_new;
        }
        if (CONV) {
            if (MathUtils.eq(PC, 0.0) || MathUtils.eq(PB, 0.0)) {
                System.out.println("EM: No or incorrect convergence! - PC==0 || PB==0");
                CONV = false;
                this.RADNW = 0.0;
                return false;
            }
            double SD = 2.0 * Math.pow(Math.PI, D / 2.0) / GammaFunction.gamma(D / 2.0);
            double SD1 = 2.0 * Math.pow(Math.PI, (D + 1.0) / 2.0) / GammaFunction.gamma((D + 1.0) / 2.0);
            double CC = SD * (1.0 / Math.pow(Math.PI * 2 * VAR, D / 2.0));
            double CB = SD / (SD1 * Math.pow(Math.sqrt(D + 1.0), D));
            double LO = S / (1.0 - S) * (PB * CB / (PC * CC));
            if (LO <= 0.0) {
                System.out.println("EM: Impossible to calculate radius - LO<0!");
                return false;
            }
            double DIS = -2.0 * VAR * Math.log(LO);
            if (DIS <= 0.0) {
                System.out.println("EM: Impossible to calculate radius - DIS<0!");
                System.out.println();
                return false;
            }
            this.RADNW = (float)Math.sqrt(DIS);
            return true;
        }
        System.out.println("EM: No or incorrect convergence! Probably not enough iterations for EM");
        return false;
    }

    private double[] background(double[] r, double D, double R) {
        double SD = 2.0 * Math.pow(Math.PI, D / 2.0) / GammaFunction.gamma(D / 2.0);
        double SD1 = 2.0 * Math.pow(Math.PI, (D + 1.0) / 2.0) / GammaFunction.gamma((D + 1.0) / 2.0);
        double[] out = new double[r.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = SD / (SD1 * Math.pow(R, D)) * Math.pow(r[i], D - 1.0);
        }
        return out;
    }

    private double[] clusterdistrib(double[] r, double VAR, double D, double R) {
        double[] out = new double[r.length];
        if (MathUtils.eq(VAR, 0.0)) {
            for (int i = 0; i < r.length; ++i) {
                if (!MathUtils.eq(r[i], 0.0)) continue;
                out[i] = Double.POSITIVE_INFINITY;
            }
        } else {
            int i;
            double SD = 2.0 * Math.pow(Math.PI, D / 2.0) / GammaFunction.gamma(D / 2.0);
            double tmp_piVAR = Math.PI * 2 * VAR;
            double tmp_piVARpow = Math.pow(tmp_piVAR, D / 2.0);
            double tmp_piVARpowINV = 1.0 / tmp_piVARpow;
            for (i = 0; i < r.length; ++i) {
                double tmp_exp = -(r[i] * r[i] / (2.0 * VAR));
                out[i] = (float)(SD * tmp_piVARpowINV * Math.pow(r[i], D - 1.0) * Math.exp(tmp_exp));
            }
            for (i = 0; i < r.length; ++i) {
                if (!MathUtils.eq(r[i], 0.0)) continue;
                out[i] = 1.0;
            }
        }
        return out;
    }

    private double[] calculateDistances(Vector<TaggedInstance> as, double[] ck) {
        double[] out = new double[as.size()];
        for (int i = 0; i < as.size(); ++i) {
            Double[] values = as.get((int)i).inst.values().toArray(new Double[0]);
            float sum = 0.0f;
            for (int j = 0; j < values.length; ++j) {
                double dif = values[j] - ck[j];
                sum = (float)((double)sum + dif * dif);
            }
            out[i] = Math.sqrt(sum);
        }
        return out;
    }

    private boolean wan_shr_adap(Vector<TaggedInstance> A, double EXTTRESH) {
        int samples = A.size();
        double[] CE = new double[samples];
        int MAXITER = 100;
        double NRWAN = 30.0;
        double[] ME1 = this.mean(A);
        double[] DMI = this.calculateDistances(A, ME1);
        double maxDMI = DMI[0];
        double minDMI = DMI[0];
        for (int i = 1; i < DMI.length; ++i) {
            if (DMI[i] > maxDMI) {
                maxDMI = DMI[i];
            }
            if (!(DMI[i] < minDMI)) continue;
            minDMI = DMI[i];
        }
        this.EXTTRESH2 = maxDMI;
        double MDIS = minDMI;
        if (MathUtils.eq(MDIS, this.EXTTRESH2)) {
            this.ME = ME1;
            for (int i = 0; i < CE.length; ++i) {
                CE[i] = 1.0;
            }
            this.EXTTRESH2 += 1.0E-6;
            System.out.println("Cluster center localisation did not reach preliminary estimate of radius!");
            return true;
        }
        double DELTARAD = (this.EXTTRESH2 - EXTTRESH) / NRWAN;
        double RADPR = this.EXTTRESH2;
        this.EXTTRESH2 -= DELTARAD;
        if (this.EXTTRESH2 <= MDIS) {
            this.EXTTRESH2 = (RADPR + MDIS) / 2.0;
        }
        Vector<Integer> Q = this.findLower(DMI, this.EXTTRESH2);
        for (int i = 0; Q.size() != 0 && i < MAXITER; ++i) {
            double[] ME2 = this.mean(this.select(A, Q));
            if (MathUtils.eq(ME1, ME2) && MathUtils.eq(RADPR, this.EXTTRESH2)) {
                this.ME = ME2;
                for (Integer index : Q) {
                    CE[index.intValue()] = 1.0;
                }
                return true;
            }
            RADPR = this.EXTTRESH2;
            DMI = this.calculateDistances(A, ME2);
            if (this.EXTTRESH2 > EXTTRESH) {
                this.EXTTRESH2 = Math.max(EXTTRESH, this.EXTTRESH2 - DELTARAD);
                if (this.EXTTRESH2 < MathUtils.min(DMI)) {
                    this.EXTTRESH2 = RADPR;
                }
            }
            Q = this.findLower(DMI, this.EXTTRESH2);
            ME1 = ME2;
        }
        System.out.println("Preliminary cluster location did not converge");
        System.out.println("\t EXTTRESH2 = " + this.EXTTRESH2);
        return false;
    }

    private Vector<Integer> findLower(double[] array, double threshold) {
        Vector<Integer> out = new Vector<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < threshold)) continue;
            out.add(i);
        }
        return out;
    }

    private Vector<TaggedInstance> select(Vector<TaggedInstance> instances, Vector<Integer> indices) {
        Vector<TaggedInstance> out = new Vector<TaggedInstance>();
        for (Integer index : indices) {
            out.add(instances.get(index));
        }
        return out;
    }

    private double[] mean(Vector<TaggedInstance> a) {
        double[] out = new double[a.get((int)0).inst.noAttributes()];
        for (int i = 0; i < a.size(); ++i) {
            for (int j = 0; j < a.get((int)0).inst.noAttributes(); ++j) {
                int n = j;
                out[n] = out[n] + a.get((int)i).inst.value(j);
            }
        }
        int j = 0;
        while (j < a.get((int)0).inst.noAttributes()) {
            int n = j++;
            out[n] = out[n] / (double)a.size();
        }
        return out;
    }

    class TaggedInstance {
        Instance inst;
        private static final long serialVersionUID = 8990262697388049283L;
        private int tag;

        TaggedInstance(Instance i, int tag) {
            this.inst = i;
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }
    }
}

