/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import java.util.Map;
import java.util.Random;
import libsvm.LibSVM;
import net.sf.javaml.classification.evaluation.CrossValidation;
import net.sf.javaml.classification.evaluation.PerformanceMeasure;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.utils.ArrayUtils;

public class SelfOptimizingLinearLibSVM
extends LibSVM {
    private static final long serialVersionUID = -2828394692981048239L;
    private LibSVM optimal;
    private double optimalC;
    private int folds;
    private Random rg = new Random(System.currentTimeMillis());
    private int lowerC;
    private int upperC;
    private double[] fmeasures;

    public SelfOptimizingLinearLibSVM() {
        this(-5, 5);
    }

    public SelfOptimizingLinearLibSVM(int lowerC, int upperC) {
        this(lowerC, upperC, 4);
    }

    public SelfOptimizingLinearLibSVM(int lowerC, int upperC, int internalFolds) {
        this.lowerC = lowerC;
        this.upperC = upperC;
        this.folds = internalFolds;
    }

    public double[] getFMeasures() {
        return this.fmeasures;
    }

    @Override
    public void buildClassifier(Dataset data) {
        double[] result = new double[this.upperC - this.lowerC];
        for (int i = this.lowerC; i < this.upperC; ++i) {
            LibSVM svm2 = new LibSVM();
            svm2.getParameters().C = Math.pow(2.0, i);
            CrossValidation cv = new CrossValidation(svm2);
            Map<Object, PerformanceMeasure> score = cv.crossValidation(data, this.folds, this.rg);
            try {
                for (Object o : score.keySet()) {
                    int n = i - this.lowerC;
                    result[n] = result[n] + score.get(o).getFMeasure();
                }
                continue;
            }
            catch (RuntimeException e) {
                System.err.println(score.keySet().iterator().next().getClass());
                System.err.println(score);
                e.printStackTrace();
                System.exit(-1);
            }
        }
        this.fmeasures = result;
        int index = ArrayUtils.maxIndex(result);
        this.optimal = new LibSVM();
        this.optimal.getParameters().C = this.optimalC = Math.pow(2.0, index + this.lowerC);
        this.optimal.buildClassifier(data);
    }

    @Override
    public Object classify(Instance instance) {
        return this.optimal.classify(instance);
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        return this.optimal.classDistribution(instance);
    }

    public double getC() {
        return this.optimalC;
    }

    @Override
    public double[] getWeights() {
        return this.optimal.getWeights();
    }

    public final void setFolds(int folds) {
        this.folds = folds;
    }
}

