/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Deprecated
public class XmlWriter {
    public static final String XML_HEADER_LINE = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    private final PrintWriter _pWriter;
    private static XMLOutputter _xmlOutputter;

    public XmlWriter(File file) throws IOException {
        this(new FileWriter(file), true);
    }

    public XmlWriter(Writer writer, boolean initHeadline) {
        Guardian.assertNotNull("writer", writer);
        this._pWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        _xmlOutputter = new XMLOutputter();
        Format format = _xmlOutputter.getFormat();
        format.setIndent("    ");
        _xmlOutputter.setFormat(format);
        if (initHeadline) {
            this.init();
        }
    }

    private void init() {
        this._pWriter.println(XML_HEADER_LINE);
    }

    public void println(String str) {
        this._pWriter.println(str);
    }

    public void print(String str) {
        this._pWriter.print(str);
    }

    public void printElement(int indent, Element element) {
        if (element != null) {
            try {
                String line;
                StringWriter sw = new StringWriter();
                _xmlOutputter.output(element, (Writer)sw);
                StringBuffer buffer = sw.getBuffer();
                BufferedReader br = new BufferedReader(new StringReader(buffer.toString()));
                while ((line = br.readLine()) != null) {
                    this._pWriter.write(XmlWriter.getIndentWhiteSpace(indent));
                    this._pWriter.write(line);
                    this._pWriter.println();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this._pWriter.close();
    }

    public static String[] createTags(int indent, String name) {
        String[] tags = new String[2];
        String ws = XmlWriter.getIndentWhiteSpace(indent);
        tags[0] = ws + "<" + name + ">";
        tags[1] = ws + "</" + name + ">";
        return tags;
    }

    public static String[] createTags(int indent, String name, String[][] attributes) {
        Debug.assertNotNullOrEmpty(name);
        Debug.assertNotNull(attributes);
        StringBuffer tag = new StringBuffer();
        String indentWs = XmlWriter.getIndentWhiteSpace(indent);
        tag.append(indentWs);
        tag.append("<");
        tag.append(name);
        for (int i = 0; i < attributes.length; ++i) {
            String[] att_val = attributes[i];
            if (att_val.length <= 1) continue;
            String attribute = att_val[0];
            String value = att_val[1];
            if (attribute == null || attribute.length() <= 0) continue;
            tag.append(" " + attribute + "=\"");
            if (value != null) {
                tag.append(XmlWriter.encode(value));
            }
            tag.append("\"");
        }
        tag.append(">");
        String[] tags = new String[]{tag.toString(), indentWs + "</" + name + ">"};
        return tags;
    }

    public void printLine(int indent, String tagName, boolean b) {
        this.printLine(indent, tagName, String.valueOf(b));
    }

    public void printLine(int indent, String tagName, int i) {
        this.printLine(indent, tagName, String.valueOf(i));
    }

    public void printLine(int indent, String tagName, float f) {
        this.printLine(indent, tagName, String.valueOf(f));
    }

    public void printLine(int indent, String tagName, double d) {
        this.printLine(indent, tagName, String.valueOf(d));
    }

    public void printLine(int indent, String tagName, String text) {
        String[] tags = XmlWriter.createTags(indent, tagName);
        this.printLine(tags, text);
    }

    public void printLine(int indent, String tagName, String[][] attributes, String text) {
        String[] tags = XmlWriter.createTags(indent, tagName, attributes);
        this.printLine(tags, text);
    }

    public void printLine(String[] tags, String text) {
        if (text != null && text.trim().length() > 0) {
            this._pWriter.print(tags[0]);
            this._pWriter.print(XmlWriter.encode(text));
            this._pWriter.println(tags[1].trim());
        } else {
            this._pWriter.println(tags[0].substring(0, tags[0].length() - 1).concat(" />"));
        }
    }

    private static String getIndentWhiteSpace(int indent) {
        int length = indent * 4;
        char[] newStr = new char[length];
        for (int i = 0; i < newStr.length; ++i) {
            newStr[i] = 32;
        }
        return new String(newStr);
    }

    private static String encode(String text) {
        if (text != null) {
            text = _xmlOutputter.outputString(new Text(text.trim()));
        }
        return text;
    }
}

