/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.util.Arrays;

public final class ObjectArray {
    private final int minIndex;
    private final int maxIndex;
    private final Object[] objects;

    public ObjectArray(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max must be greater than or equal min");
        }
        this.minIndex = min;
        this.maxIndex = max;
        this.objects = new Object[max - min + 1];
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public Object getObject(int i) {
        return this.objects[i - this.minIndex];
    }

    public void setObject(int i, Object o) {
        this.objects[i - this.minIndex] = o;
    }

    public void clear() {
        Arrays.fill(this.objects, 0, this.objects.length, null);
    }

    private int getArrayIndex(int i) {
        return i - this.minIndex;
    }

    public void set(ObjectArray array) {
        int start = Math.max(this.minIndex, array.getMinIndex());
        int end = Math.min(this.maxIndex, array.getMaxIndex());
        if (end < start) {
            return;
        }
        int srcPos = start - array.getMinIndex();
        int destPos = start - this.minIndex;
        System.arraycopy(array.objects, srcPos, this.objects, destPos, end - start + 1);
    }
}

