/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.TermTransformer;
import org.esa.snap.core.jexp.impl.Functions;
import org.esa.snap.core.jexp.impl.Symbols;
import org.esa.snap.core.jexp.impl.TermFactory;

public class TermSimplifier
implements TermTransformer {
    @Override
    public Term apply(Term term) {
        return term.accept(this);
    }

    public Term[] apply(Term ... terms) {
        Term[] simpTerms = (Term[])terms.clone();
        for (int i = 0; i < simpTerms.length; ++i) {
            simpTerms[i] = this.apply(simpTerms[i]);
        }
        return simpTerms;
    }

    @Override
    public Term visit(Term.ConstB term) {
        return term;
    }

    @Override
    public Term visit(Term.ConstI term) {
        return term;
    }

    @Override
    public Term visit(Term.ConstD term) {
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        return term;
    }

    @Override
    public Term visit(Term.ConstS term) {
        return term;
    }

    @Override
    public Term visit(Term.Ref term) {
        return term;
    }

    @Override
    public Term visit(Term.Call term) {
        Term arg;
        Term c = this.tryEvalToConst(term = new Term.Call(term.getFunction(), this.apply(term.getArgs())));
        if (c != null) {
            return c;
        }
        if (term.getFunction() == Functions.SQRT) {
            Term arg1 = term.getArg();
            Term.ConstD arg2 = Term.ConstD.HALF;
            return this.simpPow(arg1, arg2);
        }
        if (term.getFunction() == Functions.SQ) {
            Term arg1 = term.getArg();
            Term.ConstD arg2 = Term.ConstD.TWO;
            return this.simpPow(arg1, arg2);
        }
        if (term.getFunction() == Functions.POW) {
            Term arg1 = term.getArg(0);
            Term arg2 = term.getArg(1);
            return this.simpPow(arg1, arg2);
        }
        if (term.getFunction() == Functions.EXP) {
            Term.Call callArg;
            Term arg2 = term.getArg();
            if (arg2.isConst()) {
                double v = arg2.evalD(null);
                if (v == 0.0) {
                    return Term.ConstD.ONE;
                }
                if (v == 1.0) {
                    return new Term.Ref(Symbols.E);
                }
            } else if (arg2 instanceof Term.Call && (callArg = (Term.Call)arg2).getFunction() == Functions.LOG) {
                return callArg.getArg();
            }
        } else if (term.getFunction() == Functions.LOG) {
            Term.Call callArg;
            Term arg3 = term.getArg();
            if (arg3.isConst()) {
                double v = arg3.evalD(null);
                if (v == 0.0) {
                    return Term.ConstD.ONE;
                }
                if (v == Math.E) {
                    return new Term.Ref(Symbols.E);
                }
            } else if (arg3 instanceof Term.Call && (callArg = (Term.Call)arg3).getFunction() == Functions.EXP) {
                return callArg.getArg();
            }
        } else if ((term.getFunction() == Functions.ABS_I || term.getFunction() == Functions.ABS_D) && (arg = term.getArg()) instanceof Term.Neg) {
            Term.Neg negTerm = (Term.Neg)arg;
            return this.apply((Term)new Term.Call(term.getFunction(), negTerm.getArg()));
        }
        return term;
    }

    private Term tryEvalToConst(Term term) {
        if (term.isConst()) {
            if (term.isB()) {
                return TermFactory.c(term.evalB(null));
            }
            if (term.isI()) {
                return TermFactory.c(term.evalI(null));
            }
            if (term.isD()) {
                double value = term.evalD(null);
                Term.ConstD result = Term.ConstD.lookup(value);
                if (result == Term.ConstD.PI) {
                    return new Term.Ref(Symbols.PI);
                }
                if (result == Term.ConstD.E) {
                    return new Term.Ref(Symbols.E);
                }
                if (result != null) {
                    return result;
                }
                double valueF = Math.floor(value);
                if (Term.ConstD.eq(value, valueF)) {
                    return TermFactory.c(valueF);
                }
                double valueR = (double)Math.round(value * 100.0) / 100.0;
                if (Term.ConstD.eq(value, valueR)) {
                    return TermFactory.c(valueR);
                }
            }
        }
        return null;
    }

    private Term simpPow(Term base, Term exp) {
        if (base.isConst()) {
            double nBase = base.evalD(null);
            if (Term.ConstD.eq(nBase, 0.0)) {
                return Term.ConstD.ZERO;
            }
            if (Term.ConstD.eq(nBase, 1.0)) {
                return Term.ConstD.ONE;
            }
            if (Term.ConstD.eq(nBase, Math.E)) {
                return this.apply((Term)new Term.Call(Functions.EXP, exp));
            }
        }
        if (exp.isConst()) {
            double nExp = exp.evalD(null);
            if (Term.ConstD.eq(nExp, 0.0)) {
                return Term.ConstD.ONE;
            }
            if (Term.ConstD.eq(nExp, 1.0)) {
                return base;
            }
            if (Term.ConstD.eq(nExp, -1.0)) {
                return this.apply((Term)new Term.Div(3, Term.ConstD.ONE, base));
            }
        }
        if (base instanceof Term.Call) {
            Term.Call baseCall = (Term.Call)base;
            if (baseCall.getFunction() == Functions.POW) {
                return this.simplifyNestedPowButConsiderSign(baseCall, baseCall.getArg(0), baseCall.getArg(1), exp);
            }
            if (baseCall.getFunction() == Functions.SQRT) {
                return this.simplifyNestedPowButConsiderSign(baseCall, baseCall.getArg(), Term.ConstD.HALF, exp);
            }
            if (baseCall.getFunction() == Functions.SQ) {
                return this.simplifyNestedPowButConsiderSign(baseCall, baseCall.getArg(), Term.ConstD.TWO, exp);
            }
            if (baseCall.getFunction() == Functions.EXP) {
                return this.apply((Term)new Term.Call(Functions.EXP, new Term.Mul(3, baseCall.getArg(), exp)));
            }
        } else if (base instanceof Term.Neg) {
            Term.Neg negOp = (Term.Neg)base;
            if (this.isNoneZeroEvenInt(exp)) {
                return this.simpPow(negOp.getArg(), exp);
            }
        }
        return this.pow(base, exp);
    }

    private Term simplifyNestedPowButConsiderSign(Term.Call innerCall, Term base, Term exp1, Term exp2) {
        boolean noneZeroEvenInt1 = this.isNoneZeroEvenInt(exp1);
        boolean noneZeroEvenInt2 = this.isNoneZeroEvenInt(exp2);
        if (!noneZeroEvenInt1 || noneZeroEvenInt2) {
            return this.apply(this.simpPow(base, new Term.Mul(3, exp1, exp2)));
        }
        return this.pow(innerCall, exp2);
    }

    private Term pow(Term arg1, Term arg2) {
        if (arg2.isConst()) {
            double v = arg2.evalD(null);
            if (Term.ConstD.eq(v, 0.5)) {
                return new Term.Call(Functions.SQRT, arg1);
            }
            if (Term.ConstD.eq(v, 2.0)) {
                return new Term.Call(Functions.SQ, arg1);
            }
        }
        return new Term.Call(Functions.POW, arg1, arg2);
    }

    private boolean isNoneZeroEvenInt(Term term) {
        double v;
        return term.isConst() && !Term.ConstD.eq(v = term.evalD(null), 0.0) && TermSimplifier.isEvenInt(v);
    }

    private static boolean isEvenInt(double v) {
        double f = v - 2.0 * Math.floor(v / 2.0);
        return Term.ConstD.eq(f, 0.0);
    }

    @Override
    public Term visit(Term.Cond term) {
        Term arg3;
        if (term.getArg(0).isConst()) {
            boolean value = term.getArg(0).evalB(null);
            return this.apply(term.getArg(value ? 1 : 2));
        }
        Term arg1 = this.apply(term.getArg(0));
        Term arg2 = this.apply(term.getArg(1));
        if (arg2.compare(arg3 = this.apply(term.getArg(2))) == 0) {
            return arg2;
        }
        return new Term.Cond(term.getRetType(), arg1, arg2, arg3);
    }

    @Override
    public Term visit(Term.Assign term) {
        return new Term.Assign(term.getArg(0), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.NotB term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        return new Term.NotB(this.apply(term.getArg()));
    }

    @Override
    public Term visit(Term.AndB term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        return new Term.AndB(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.OrB term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        return new Term.OrB(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.NotI term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalI(null));
        }
        return new Term.NotI(this.apply(term.getArg()));
    }

    @Override
    public Term visit(Term.XOrI term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalI(null));
        }
        return new Term.XOrI(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.AndI term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalI(null));
        }
        return new Term.AndI(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.OrI term) {
        if (term.isConst()) {
            return TermFactory.c(term.evalI(null));
        }
        return new Term.OrI(this.apply(term.getArg(0)), this.apply(term.getArg(1)));
    }

    @Override
    public Term visit(Term.Neg term) {
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg = this.apply(term.getArg(0));
        if (arg instanceof Term.Neg) {
            Term.Neg neg = (Term.Neg)arg;
            return neg.getArg();
        }
        if (arg instanceof Term.Mul) {
            Term arg11 = ((Term.Mul)arg).getArg(0);
            Term arg12 = ((Term.Mul)arg).getArg(1);
            return this.apply((Term)new Term.Mul(new Term.Neg(term.getRetType(), arg11), arg12));
        }
        if (arg instanceof Term.Div) {
            Term arg11 = ((Term.Div)arg).getArg(0);
            Term arg12 = ((Term.Div)arg).getArg(1);
            return this.apply((Term)new Term.Div(new Term.Neg(term.getRetType(), arg11), arg12));
        }
        return new Term.Neg(term.getRetType(), arg);
    }

    @Override
    public Term visit(Term.Add term) {
        Term arg11;
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg1 = this.apply(term.getArg(0));
        Term arg2 = this.apply(term.getArg(1));
        if (arg1.isConst() && Term.ConstD.eq(arg1.evalD(null), 0.0)) {
            return arg2;
        }
        if (arg2.isConst() && Term.ConstD.eq(arg2.evalD(null), 0.0)) {
            return this.apply(term.getArg(0));
        }
        if (arg2 instanceof Term.Add) {
            Term arg21 = ((Term.Add)arg2).getArg(0);
            Term arg22 = ((Term.Add)arg2).getArg(1);
            return this.apply((Term)new Term.Add(term.getRetType(), new Term.Add(term.getRetType(), arg1, arg21), arg22));
        }
        if (arg1 instanceof Term.Add) {
            arg11 = ((Term.Add)arg1).getArg(0);
            Term arg12 = ((Term.Add)arg1).getArg(1);
            if (arg11.isConst() && arg2.isConst()) {
                return this.apply((Term)new Term.Add(term.getRetType(), new Term.Add(term.getRetType(), arg11, arg2), arg12));
            }
            int comp = arg11.compare(arg2);
            if (comp == 0) {
                return this.apply((Term)new Term.Add(term.getRetType(), new Term.Mul(term.getRetType(), Term.ConstD.TWO, arg2), arg12));
            }
            comp = arg12.compare(arg2);
            if (comp == 0) {
                return this.apply((Term)new Term.Add(term.getRetType(), new Term.Mul(term.getRetType(), Term.ConstD.TWO, arg2), arg11));
            }
        }
        if (arg1 instanceof Term.Neg) {
            arg11 = ((Term.Neg)arg1).getArg();
            return this.apply((Term)new Term.Sub(term.getRetType(), arg2, arg11));
        }
        if (arg2 instanceof Term.Neg) {
            Term arg12 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Sub(term.getRetType(), arg1, arg12));
        }
        int comp = arg1.compare(arg2);
        if (comp == 0) {
            if (term.isI()) {
                return this.apply((Term)new Term.Mul(term.getRetType(), Term.ConstI.TWO, arg2));
            }
            return this.apply((Term)new Term.Mul(term.getRetType(), Term.ConstD.TWO, arg2));
        }
        if (comp > 0 && !(arg1 instanceof Term.Add)) {
            return this.apply((Term)new Term.Add(term.getRetType(), arg2, arg1));
        }
        return new Term.Add(term.getRetType(), arg1, arg2);
    }

    @Override
    public Term visit(Term.Sub term) {
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg1 = this.apply(term.getArg(0));
        Term arg2 = this.apply(term.getArg(1));
        if (arg1.isConst() && Term.ConstD.eq(arg1.evalD(null), 0.0)) {
            return this.apply((Term)new Term.Neg(arg2.getRetType(), arg2));
        }
        if (arg2.isConst() && Term.ConstD.eq(arg2.evalD(null), 0.0)) {
            return arg1;
        }
        if (arg1 instanceof Term.Neg) {
            Term arg11 = ((Term.Neg)arg1).getArg();
            return this.apply((Term)new Term.Neg(term.getRetType(), new Term.Add(term.getRetType(), arg11, arg2)));
        }
        if (arg2 instanceof Term.Neg) {
            Term arg21 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Add(term.getRetType(), arg1, arg21));
        }
        int comp = arg1.compare(arg2);
        if (comp == 0) {
            return term.isI() ? Term.ConstI.ZERO : Term.ConstD.ZERO;
        }
        return new Term.Sub(term.getRetType(), arg1, arg2);
    }

    @Override
    public Term visit(Term.Mul term) {
        double v;
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg1 = this.apply(term.getArg(0));
        Term arg2 = this.apply(term.getArg(1));
        if (arg1.isConst()) {
            v = arg1.evalD(null);
            if (Term.ConstD.eq(v, 0.0)) {
                return term.isI() ? Term.ConstI.ZERO : Term.ConstD.ZERO;
            }
            if (Term.ConstD.eq(v, 1.0)) {
                return arg2;
            }
            if (Term.ConstD.eq(v, -1.0)) {
                return this.apply((Term)new Term.Neg(arg2.getRetType(), arg2));
            }
        }
        if (arg2.isConst()) {
            v = arg2.evalD(null);
            if (Term.ConstD.eq(v, 0.0)) {
                return term.isI() ? Term.ConstI.ZERO : Term.ConstD.ZERO;
            }
            if (Term.ConstD.eq(v, 1.0)) {
                return arg1;
            }
            if (Term.ConstD.eq(v, -1.0)) {
                return this.apply((Term)new Term.Neg(arg1.getRetType(), arg1));
            }
        }
        if (arg1 instanceof Term.Neg && arg2 instanceof Term.Neg) {
            Term arg11 = ((Term.Neg)arg1).getArg();
            Term arg21 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Mul(term.getRetType(), arg11, arg21));
        }
        if (arg1 instanceof Term.Const && arg2 instanceof Term.Neg) {
            Term arg21 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Mul(term.getRetType(), new Term.Neg(arg1), arg21));
        }
        if (arg2 instanceof Term.Mul) {
            Term arg21 = ((Term.Mul)arg2).getArg(0);
            Term arg22 = ((Term.Mul)arg2).getArg(1);
            return this.apply((Term)new Term.Mul(term.getRetType(), new Term.Mul(term.getRetType(), arg1, arg21), arg22));
        }
        if (arg2 instanceof Term.Div) {
            Term arg21 = ((Term.Div)arg2).getArg(0);
            Term arg22 = ((Term.Div)arg2).getArg(1);
            return this.apply((Term)new Term.Div(term.getRetType(), new Term.Mul(term.getRetType(), arg1, arg21), arg22));
        }
        int comp = arg1.compare(arg2);
        if (comp == 0) {
            return this.apply((Term)new Term.Call(Functions.SQ, arg1));
        }
        if (comp > 0 && !(arg1 instanceof Term.Mul)) {
            return this.apply((Term)new Term.Mul(term.getRetType(), arg2, arg1));
        }
        return new Term.Mul(term.getRetType(), arg1, arg2);
    }

    @Override
    public Term visit(Term.Div term) {
        if (term.getArg(1).isConst() && Term.ConstD.eq(term.getArg(1).evalD(null), 0.0)) {
            return Term.ConstD.NAN;
        }
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg1 = this.apply(term.getArg(0));
        Term arg2 = this.apply(term.getArg(1));
        if (arg1.isConst() && Term.ConstD.eq(arg1.evalD(null), 0.0)) {
            return arg1.isI() ? Term.ConstI.ZERO : Term.ConstD.ZERO;
        }
        if (arg2.isConst() && Term.ConstD.eq(arg2.evalD(null), 1.0)) {
            return arg1;
        }
        if (arg1 instanceof Term.Neg && arg2 instanceof Term.Neg) {
            Term arg11 = ((Term.Neg)arg1).getArg();
            Term arg21 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Div(term.getRetType(), arg11, arg21));
        }
        if (arg1 instanceof Term.Const && arg2 instanceof Term.Neg) {
            Term arg21 = ((Term.Neg)arg2).getArg();
            return this.apply((Term)new Term.Div(term.getRetType(), new Term.Neg(arg1), arg21));
        }
        if (arg1 instanceof Term.Div) {
            Term arg11 = ((Term.Div)arg1).getArg(0);
            Term arg12 = ((Term.Div)arg1).getArg(1);
            return this.apply((Term)new Term.Div(term.getRetType(), arg11, new Term.Mul(term.getRetType(), arg12, arg2)));
        }
        if (arg2 instanceof Term.Div) {
            Term arg21 = ((Term.Div)arg2).getArg(0);
            Term arg22 = ((Term.Div)arg2).getArg(1);
            return this.apply((Term)new Term.Div(term.getRetType(), new Term.Mul(term.getRetType(), arg1, arg22), arg21));
        }
        int comp = arg1.compare(arg2);
        if (comp == 0) {
            return term.isI() ? Term.ConstI.ONE : Term.ConstD.ONE;
        }
        return new Term.Div(term.getRetType(), arg1, arg2);
    }

    @Override
    public Term visit(Term.Mod term) {
        Term arg2;
        Term c = this.tryEvalToConst(term);
        if (c != null) {
            return c;
        }
        Term arg1 = this.apply(term.getArg(0));
        int comp = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (comp == 0) {
            return term.isI() ? Term.ConstI.ZERO : Term.ConstD.ZERO;
        }
        return new Term.Mod(arg1, arg2);
    }

    @Override
    public Term visit(Term.EqB term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.EqB(arg1, arg2);
    }

    @Override
    public Term visit(Term.EqI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.EqI(arg1, arg2);
    }

    @Override
    public Term visit(Term.EqD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.EqD(arg1, arg2);
    }

    @Override
    public Term visit(Term.NEqB term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.NEqB(arg1, arg2);
    }

    @Override
    public Term visit(Term.NEqI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.NEqI(arg1, arg2);
    }

    @Override
    public Term visit(Term.NEqD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.NEqD(arg1, arg2);
    }

    @Override
    public Term visit(Term.LtI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.LtI(arg1, arg2);
    }

    @Override
    public Term visit(Term.LtD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.LtD(arg1, arg2);
    }

    @Override
    public Term visit(Term.LeI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.LeI(arg1, arg2);
    }

    @Override
    public Term visit(Term.LeD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.LeD(arg1, arg2);
    }

    @Override
    public Term visit(Term.GtI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.GtI(arg1, arg2);
    }

    @Override
    public Term visit(Term.GtD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.FALSE;
        }
        return new Term.GtD(arg1, arg2);
    }

    @Override
    public Term visit(Term.GeI term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.GeI(arg1, arg2);
    }

    @Override
    public Term visit(Term.GeD term) {
        Term arg2;
        if (term.isConst()) {
            return TermFactory.c(term.evalB(null));
        }
        Term arg1 = this.apply(term.getArg(0));
        int c = arg1.compare(arg2 = this.apply(term.getArg(1)));
        if (c == 0) {
            return Term.ConstB.TRUE;
        }
        return new Term.GeD(arg1, arg2);
    }
}

