/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import java.awt.Rectangle;
import java.io.IOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.RasterDataNodeOpImage;
import org.esa.snap.core.image.ResolutionLevel;

public abstract class RasterDataNodeSampleOpImage
extends RasterDataNodeOpImage {
    public RasterDataNodeSampleOpImage(RasterDataNode rasterDataNode, ResolutionLevel level) {
        super(rasterDataNode, level);
    }

    @Override
    protected void computeProductData(ProductData productData, Rectangle destRect) throws IOException {
        int sourceWidth = this.getRasterDataNode().getRasterWidth();
        int sourceHeight = this.getRasterDataNode().getRasterHeight();
        int targetWidth = destRect.width;
        int targetHeight = destRect.height;
        int sourceX0 = this.getSourceX(destRect.x);
        int sourceY0 = this.getSourceY(destRect.y);
        int[] sourceXs = this.getSourceCoords(sourceWidth, targetWidth);
        int[] sourceYs = this.getSourceCoords(sourceHeight, targetHeight);
        int elemIndex = 0;
        for (int j = 0; j < targetHeight; ++j) {
            int sourceY = sourceY0 + sourceYs[j];
            for (int i = 0; i < targetWidth; ++i) {
                productData.setElemDoubleAt(elemIndex, this.computeSample(sourceX0 + sourceXs[i], sourceY));
                ++elemIndex;
            }
        }
    }

    protected abstract double computeSample(int var1, int var2);
}

