/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import org.esa.snap.core.image.ResolutionLevel;

public final class LevelImageSupport {
    private final int sourceWidth;
    private final int sourceHeight;
    private final int level;
    private final double scale;

    public LevelImageSupport(int sourceWidth, int sourceHeight, ResolutionLevel level) {
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
        this.level = level.getIndex();
        this.scale = level.getScale();
    }

    public int getSourceWidth() {
        return this.sourceWidth;
    }

    public int getSourceHeight() {
        return this.sourceHeight;
    }

    public int getLevel() {
        return this.level;
    }

    public double getScale() {
        return this.scale;
    }

    public final int getSourceX(int tx) {
        return this.getSourceCoord(tx, 0, this.getSourceWidth() - 1);
    }

    public final int getSourceY(int ty) {
        return this.getSourceCoord(ty, 0, this.getSourceHeight() - 1);
    }

    public final int getSourceWidth(int destWidth) {
        return LevelImageSupport.double2int(this.getScale() * (double)destWidth, 1, this.getSourceWidth());
    }

    public final int getSourceHeight(int destHeight) {
        return LevelImageSupport.double2int(this.getScale() * (double)destHeight, 1, this.getSourceHeight());
    }

    public final int getSourceCoord(double destCoord, int min, int max) {
        return LevelImageSupport.double2int(this.getScale() * destCoord, min, max);
    }

    private static int double2int(double v, int min, int max) {
        int sc = (int)Math.floor(v);
        if (sc < min) {
            sc = min;
        }
        if (sc > max) {
            sc = max;
        }
        return sc;
    }
}

