/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.resamp;

import org.esa.snap.core.dataop.resamp.Resampling;

public final class ResamplingFactory {
    public static final String NEAREST_NEIGHBOUR_NAME = "NEAREST_NEIGHBOUR";
    public static final String BILINEAR_INTERPOLATION_NAME = "BILINEAR_INTERPOLATION";
    public static final String CUBIC_CONVOLUTION_NAME = "CUBIC_CONVOLUTION";
    public static final String BISINC_5_POINT_INTERPOLATION_NAME = "BISINC_5_POINT_INTERPOLATION";
    public static final String BISINC_11_POINT_INTERPOLATION_NAME = "BISINC_11_POINT_INTERPOLATION";
    public static final String BISINC_21_POINT_INTERPOLATION_NAME = "BISINC_21_POINT_INTERPOLATION";
    public static final String BICUBIC_INTERPOLATION_NAME = "BICUBIC_INTERPOLATION";
    public static final String[] resamplingNames = new String[]{"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BISINC_5_POINT_INTERPOLATION", "BISINC_11_POINT_INTERPOLATION", "BISINC_21_POINT_INTERPOLATION", "BICUBIC_INTERPOLATION"};

    public static Resampling createResampling(String resamplingName) {
        switch (resamplingName) {
            case "NEAREST_NEIGHBOUR": {
                return Resampling.NEAREST_NEIGHBOUR;
            }
            case "BILINEAR_INTERPOLATION": {
                return Resampling.BILINEAR_INTERPOLATION;
            }
            case "CUBIC_CONVOLUTION": {
                return Resampling.CUBIC_CONVOLUTION;
            }
            case "BISINC_5_POINT_INTERPOLATION": {
                return Resampling.BISINC_5_POINT_INTERPOLATION;
            }
            case "BISINC_11_POINT_INTERPOLATION": {
                return Resampling.BISINC_11_POINT_INTERPOLATION;
            }
            case "BISINC_21_POINT_INTERPOLATION": {
                return Resampling.BISINC_21_POINT_INTERPOLATION;
            }
            case "BICUBIC_INTERPOLATION": {
                return Resampling.BICUBIC_INTERPOLATION;
            }
        }
        return null;
    }
}

