/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.MapTransformUI;
import org.esa.snap.core.param.Parameter;

@Deprecated
public class IdentityTransformDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Identity";
    public static final String NAME = "Geographic Lat/Lon";
    public static final String MAP_UNIT = "degree";
    public static final Parameter[] PARAMETERS = new Parameter[0];
    public static final double[] PARAMETER_DEFAULT_VALUES = new double[0];

    @Override
    public void registerProjections() {
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(null), true));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[0];
    }

    @Override
    public double[] getParameterDefaultValues() {
        return new double[0];
    }

    @Override
    public boolean hasTransformUI() {
        return false;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return null;
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        return new IMT();
    }

    private class IMT
    implements MapTransform {
        private IMT() {
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return IdentityTransformDescriptor.this;
        }

        @Override
        public double[] getParameterValues() {
            return new double[0];
        }

        @Override
        public Point2D forward(GeoPos geoPoint, Point2D mapPoint) {
            if (mapPoint != null) {
                mapPoint.setLocation(geoPoint.lon, geoPoint.lat);
            } else {
                mapPoint = new Point2D.Double(geoPoint.lon, geoPoint.lat);
            }
            return mapPoint;
        }

        @Override
        public GeoPos inverse(Point2D mapPoint, GeoPos geoPoint) {
            if (geoPoint != null) {
                geoPoint.setLocation(mapPoint.getY(), mapPoint.getX());
            } else {
                geoPoint = new GeoPos(mapPoint.getY(), mapPoint.getX());
            }
            return geoPoint;
        }

        @Override
        public MapTransform createDeepClone() {
            return new IMT();
        }
    }
}

