/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.downloadable;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;

public final class XMLSupport {
    public static void SaveXML(Document doc, String filePath) throws IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try (FileWriter writer = new FileWriter(filePath);){
            outputter.output(doc, (Writer)writer);
            writer.close();
        }
    }

    public static Document LoadXML(InputStream inputStream) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document w3cDocument = builder.parse(inputStream);
            DOMBuilder domBuilder = new DOMBuilder();
            Document doc = domBuilder.build(w3cDocument);
            return doc;
        }
        catch (MalformedURLException e) {
            String msg = "Cannot parse xml file path : " + e.getMessage() + '\n' + inputStream + "\n\nPlease check the characters being used and if your operating system locale is set correctly";
            SystemUtils.LOG.severe(msg);
            throw new IOException(msg);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Path to xml is not valid: " + e.getMessage());
            throw e;
        }
        catch (ParserConfigurationException | SAXException e) {
            SystemUtils.LOG.severe("cannot parse xml : " + e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    public static Document LoadXML(String filePath) throws IOException {
        try {
            String path = filePath.replaceAll(" ", "%20");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document w3cDocument = builder.parse(path);
            DOMBuilder domBuilder = new DOMBuilder();
            return domBuilder.build(w3cDocument);
        }
        catch (MalformedURLException e) {
            String msg = "Cannot parse xml file path : " + e.getMessage() + '\n' + filePath + "\n\nPlease check the characters being used and if your operating system locale is set correctly";
            SystemUtils.LOG.severe(msg);
            throw new IOException(msg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParserConfigurationException | SAXException e) {
            SystemUtils.LOG.severe("cannot parse xml : " + e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    public static Document LoadXMLFromResource(String filePath, Class theClass) throws IOException {
        URL resURL = theClass.getClassLoader().getResource(filePath);
        if (resURL != null) {
            return XMLSupport.LoadXML(resURL.toString());
        }
        return null;
    }

    public static void metadataElementToDOMElement(MetadataElement metadataElem, Element domElem) {
        MetadataAttribute[] metaAttributes;
        MetadataElement[] metaElements;
        for (MetadataElement childMetaElem : metaElements = metadataElem.getElements()) {
            Element childDomElem = new Element(childMetaElem.getName());
            XMLSupport.metadataElementToDOMElement(childMetaElem, childDomElem);
            domElem.addContent((Content)childDomElem);
        }
        for (MetadataAttribute childMetaAttrib : metaAttributes = metadataElem.getAttributes()) {
            Element childDomElem = new Element("attrib");
            XMLSupport.setAttribute(childDomElem, "name", childMetaAttrib.getName());
            XMLSupport.setAttribute(childDomElem, "value", childMetaAttrib.getData().getElemString());
            if (childMetaAttrib.getUnit() != null && childMetaAttrib.getUnit().equalsIgnoreCase("utc") || childMetaAttrib.getData() instanceof ProductData.UTC) {
                XMLSupport.setAttribute(childDomElem, "type", String.valueOf(51));
            } else if (childMetaAttrib.getData() instanceof ProductData.ASCII) {
                XMLSupport.setAttribute(childDomElem, "type", String.valueOf(41));
            } else {
                XMLSupport.setAttribute(childDomElem, "type", String.valueOf(childMetaAttrib.getDataType()));
            }
            XMLSupport.setAttribute(childDomElem, "unit", childMetaAttrib.getUnit());
            XMLSupport.setAttribute(childDomElem, "desc", childMetaAttrib.getDescription());
            domElem.addContent((Content)childDomElem);
        }
    }

    private static void setAttribute(Element childDomElem, String tag, String val) {
        if (val != null) {
            childDomElem.setAttribute(tag, val);
        }
    }

    private static void domElementToMetadataElement(Element domElem, MetadataElement metadataElem) {
        List children = domElem.getContent();
        for (Object aChild : children) {
            if (!(aChild instanceof Element)) continue;
            Element child = (Element)aChild;
            List grandChildren = child.getContent();
            if (!grandChildren.isEmpty()) {
                MetadataElement newElem = new MetadataElement(child.getName());
                XMLSupport.domElementToMetadataElement(child, newElem);
                metadataElem.addElement(newElem);
            }
            if (!child.getName().equals("attrib")) continue;
            XMLSupport.addAttribute(metadataElem, child);
        }
    }

    private static void addAttribute(MetadataElement root, Element domElem) {
        Attribute nameAttrib = domElem.getAttribute("name");
        Attribute valueAttrib = domElem.getAttribute("value");
        Attribute typeAttrib = domElem.getAttribute("type");
        Attribute unitAttrib = domElem.getAttribute("unit");
        Attribute descAttrib = domElem.getAttribute("desc");
        if (nameAttrib == null || valueAttrib == null) {
            return;
        }
        MetadataAttribute attribute = new MetadataAttribute(nameAttrib.getName(), 41, 1);
        attribute.getData().setElems(valueAttrib.getValue());
        if (unitAttrib != null) {
            attribute.setUnit(unitAttrib.getValue());
        }
        if (descAttrib != null) {
            attribute.setDescription(descAttrib.getValue());
        }
        root.addAttribute(attribute);
    }

    public static String getAttrib(Element elem, String tag) {
        Attribute attrib = elem.getAttribute(tag);
        if (attrib != null) {
            return attrib.getValue();
        }
        return "";
    }

    public static Element getElement(Element root, String name) throws IOException {
        List children = root.getContent();
        for (Object aChild : children) {
            Element elem;
            if (!(aChild instanceof Element) || !(elem = (Element)aChild).getName().equalsIgnoreCase(name)) continue;
            return elem;
        }
        throw new IOException("Element " + name + " not found");
    }

    public static Text getElementText(Element root) throws IOException {
        List children = root.getContent();
        for (Object aChild : children) {
            if (!(aChild instanceof Text)) continue;
            return (Text)aChild;
        }
        throw new IOException("Element Text not found");
    }

    public static String[] getStringList(Element elem) {
        ArrayList<String> array = new ArrayList<String>();
        List contentList = elem.getContent();
        for (Object o : contentList) {
            if (!(o instanceof Element)) continue;
            array.add(((Element)o).getName());
        }
        return array.toArray(new String[array.size()]);
    }
}

