/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.jai.NoDataRaster;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.operator.MinDescriptor;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxOp;
import org.esa.snap.core.datamodel.SummaryStxOp;
import org.esa.snap.core.image.ImageManager;

public class StxFactory {
    public static final int DEFAULT_BIN_COUNT = 512;
    private Number minimum;
    private Number maximum;
    private Number mean;
    private Number standardDeviation;
    private Histogram histogram;
    private Integer resolutionLevel;
    private Mask roiMask;
    private RenderedImage roiImage;
    private Shape roiShape;
    private Integer histogramBinCount;
    private Boolean intHistogram;
    private Boolean logHistogram;
    private int[] histogramBins;
    private Number coefficientOfVariation;
    private Number enl;

    public StxFactory withMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public StxFactory withMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public StxFactory withMean(Number mean) {
        this.mean = mean;
        return this;
    }

    public StxFactory withStandardDeviation(Number standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public StxFactory withIntHistogram(boolean intHistogram) {
        this.intHistogram = intHistogram;
        return this;
    }

    public StxFactory withLogHistogram(boolean logHistogram) {
        this.logHistogram = logHistogram;
        return this;
    }

    public StxFactory withHistogram(Histogram histogram) {
        this.histogram = histogram;
        return this;
    }

    public StxFactory withResolutionLevel(Integer resolutionLevel) {
        this.resolutionLevel = resolutionLevel;
        return this;
    }

    public StxFactory withRoiMask(Mask roiMask) {
        this.roiMask = roiMask;
        return this;
    }

    public StxFactory withRoiImage(RenderedImage roiImage) {
        this.roiImage = roiImage;
        return this;
    }

    public StxFactory withRoiShape(Shape roiShape) {
        this.roiShape = roiShape;
        return this;
    }

    public StxFactory withHistogramBinCount(Integer histogramBinCount) {
        this.histogramBinCount = histogramBinCount;
        return this;
    }

    public StxFactory withHistogramBins(int[] histogramBins) {
        this.histogramBins = histogramBins;
        return this;
    }

    public Stx create() {
        return this.create(null, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stx create(Mask[] roiMasks, RasterDataNode[] rasters, ProgressMonitor pm) {
        double minimum = this.minimum != null ? this.minimum.doubleValue() : Double.NaN;
        double maximum = this.maximum != null ? this.maximum.doubleValue() : Double.NaN;
        double mean = this.mean != null ? this.mean.doubleValue() : Double.NaN;
        double stdDev = this.standardDeviation != null ? this.standardDeviation.doubleValue() : Double.NaN;
        boolean logHistogram = this.logHistogram != null ? this.logHistogram : false;
        boolean intHistogram = this.intHistogram != null ? this.intHistogram : false;
        int level = this.resolutionLevel != null ? this.resolutionLevel : 0;
        double coeffOfVariation = this.coefficientOfVariation != null ? this.coefficientOfVariation.doubleValue() : Double.NaN;
        double enl = this.enl != null ? this.enl.doubleValue() : Double.NaN;
        Histogram histogram = this.histogram;
        Assert.argument((roiMasks == null || roiMasks.length == rasters.length ? 1 : 0) != 0, (String)"roiMasks == null || roiMasks.length == rasters.length");
        ArrayList<RasterDataNode> filteredRasterList = new ArrayList<RasterDataNode>();
        for (RasterDataNode rasterDataNode : rasters) {
            if (rasterDataNode == null) continue;
            filteredRasterList.add(rasterDataNode);
        }
        if (!filteredRasterList.isEmpty()) {
            RasterDataNode[] filteredRasters = filteredRasterList.toArray(new RasterDataNode[filteredRasterList.size()]);
            Shape[] roiShapes = new Shape[rasters.length];
            RenderedImage[] roiImages = new RenderedImage[rasters.length];
            roiImages[0] = this.roiImage;
            if (roiMasks != null) {
                roiShapes[0] = this.roiShape;
                for (int i = 0; i < roiMasks.length; ++i) {
                    if (roiMasks[i] == null) {
                        roiShapes[i] = null;
                        roiImages[i] = null;
                        continue;
                    }
                    if (roiMasks[i].getValidShape() != null) {
                        roiShapes[i] = roiMasks[i].getValidShape();
                    }
                    roiImages[i] = roiMasks[i].getSourceImage();
                }
            }
            if (this.intHistogram == null) {
                intHistogram = filteredRasters[0].getGeophysicalImage().getSampleModel().getDataType() < 4;
            }
            boolean mustComputeSummaryStx = this.minimum == null || this.maximum == null;
            boolean mustComputeHistogramStx = this.histogram == null && this.histogramBins == null;
            try {
                pm.beginTask("Computing statistics", mustComputeSummaryStx && mustComputeHistogramStx ? 100 : 50);
                if (mustComputeSummaryStx) {
                    SummaryStxOp meanOp = new SummaryStxOp();
                    for (int i = 0; i < filteredRasters.length; ++i) {
                        RasterDataNode rasterDataNode = filteredRasters[i];
                        StxFactory.accumulate(rasterDataNode, level, roiImages[i], roiShapes[i], meanOp, SubProgressMonitor.create((ProgressMonitor)pm, (int)50));
                    }
                    if (this.minimum == null) {
                        minimum = meanOp.getMinimum();
                    }
                    if (this.maximum == null) {
                        maximum = meanOp.getMaximum();
                    }
                    if (this.mean == null) {
                        mean = meanOp.getMean();
                    }
                    if (this.standardDeviation == null) {
                        stdDev = meanOp.getStandardDeviation();
                    }
                    if (this.coefficientOfVariation == null) {
                        coeffOfVariation = meanOp.getCoefficientOfVariation(filteredRasters[0].getUnit());
                    }
                    if (this.enl == null) {
                        enl = meanOp.getEquivalentNumberOfLooks(filteredRasters[0].getUnit());
                    }
                }
                if (mustComputeHistogramStx) {
                    int binCount = this.histogramBinCount != null ? this.histogramBinCount : 512;
                    HistogramStxOp histogramOp = new HistogramStxOp(binCount, minimum, maximum, intHistogram, logHistogram);
                    for (int i = 0; i < filteredRasters.length; ++i) {
                        RasterDataNode rasterDataNode = filteredRasters[i];
                        StxFactory.accumulate(rasterDataNode, level, roiImages[i], roiShapes[i], histogramOp, SubProgressMonitor.create((ProgressMonitor)pm, (int)50));
                    }
                    histogram = histogramOp.getHistogram();
                }
            }
            finally {
                pm.done();
            }
        }
        if (histogram == null) {
            if (this.histogramBins != null) {
                histogram = StxFactory.createHistogram(minimum, maximum, logHistogram, intHistogram, this.histogramBins);
            } else {
                throw new IllegalStateException("Failed to derive histogram");
            }
        }
        if (Double.isNaN(minimum)) {
            if (!logHistogram) {
                minimum = histogram.getLowValue(0);
            } else {
                throw new IllegalStateException("Failed to derive minimum");
            }
        }
        if (Double.isNaN(maximum)) {
            if (!logHistogram) {
                maximum = histogram.getHighValue(0);
            } else {
                throw new IllegalStateException("Failed to derive maximum");
            }
        }
        return new Stx(minimum, maximum, mean, stdDev, coeffOfVariation, enl, logHistogram, intHistogram, histogram, level);
    }

    public Stx create(RasterDataNode raster, ProgressMonitor pm) {
        if (this.roiMask != null) {
            return this.create(new Mask[]{this.roiMask}, new RasterDataNode[]{raster}, pm);
        }
        return this.create(null, new RasterDataNode[]{raster}, pm);
    }

    public static void accumulate(RasterDataNode rasterDataNode, int level, RenderedImage roiImage, Shape roiShape, StxOp op, ProgressMonitor pm) {
        Assert.notNull((Object)rasterDataNode, (String)"raster");
        Assert.argument((level >= 0 ? 1 : 0) != 0, (String)"level");
        Assert.argument((roiImage == null || level == 0 ? 1 : 0) != 0, (String)"level");
        Assert.notNull((Object)pm, (String)"pm");
        PlanarImage dataImage = ImageManager.getInstance().getGeophysicalImage(rasterDataNode, level);
        if (dataImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalStateException("dataImage.sampleModel.numBands != 1");
        }
        PlanarImage maskImage = StxFactory.getEffectiveMaskImage(rasterDataNode, level, roiImage);
        Shape maskShape = StxFactory.getEffectiveShape(rasterDataNode, roiShape);
        StxFactory.accumulate(op, dataImage, maskImage, maskShape, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void accumulate(StxOp op, PlanarImage dataImage, PlanarImage maskImage, Shape maskShape, ProgressMonitor pm) {
        if (maskImage != null) {
            StxFactory.ensureImageCompatibility(dataImage, maskImage);
        }
        PixelAccessor dataAccessor = new PixelAccessor(dataImage.getSampleModel(), null);
        PixelAccessor maskAccessor = maskImage != null ? new PixelAccessor(maskImage.getSampleModel(), null) : null;
        try {
            pm.beginTask("Computing " + op.getName(), dataImage.getNumXTiles() * dataImage.getNumYTiles());
            for (int tileY = dataImage.getMinTileY(); tileY <= dataImage.getMaxTileY(); ++tileY) {
                for (int tileX = dataImage.getMinTileX(); tileX <= dataImage.getMaxTileX(); ++tileX) {
                    Rectangle dataRect;
                    if (pm.isCanceled()) {
                        throw new CancellationException("Process terminated by user.");
                    }
                    boolean tileContainsData = true;
                    if (maskShape != null && !maskShape.intersects(dataRect = dataImage.getTileRect(tileX, tileY))) {
                        tileContainsData = false;
                    }
                    if (tileContainsData) {
                        StxFactory.accumulateTile(op, dataImage, maskImage, dataAccessor, maskAccessor, tileX, tileY);
                    }
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
    }

    static void accumulateTile(StxOp op, PlanarImage dataImage, PlanarImage maskImage, PixelAccessor dataAccessor, PixelAccessor maskAccessor, int tileX, int tileY) {
        Raster dataTile = dataImage.getTile(tileX, tileY);
        if (!(dataTile instanceof NoDataRaster)) {
            Raster maskTile = maskImage != null ? maskImage.getData(dataTile.getBounds()) : null;
            Rectangle rect = new Rectangle(dataImage.getMinX(), dataImage.getMinY(), dataImage.getWidth(), dataImage.getHeight()).intersection(dataTile.getBounds());
            UnpackedImageData dataPixels = dataAccessor.getPixels(dataTile, rect, dataImage.getSampleModel().getDataType(), false);
            UnpackedImageData maskPixels = maskAccessor != null ? maskAccessor.getPixels(maskTile, rect, 0, false) : null;
            op.accumulateData(dataPixels, maskPixels);
        }
    }

    static void ensureImageCompatibility(PlanarImage dataImage, PlanarImage maskImage) {
        if (maskImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalStateException("maskSampleModel.numBands != 1");
        }
        if (maskImage.getSampleModel().getDataType() != 0) {
            throw new IllegalStateException("maskSampleModel.dataType != TYPE_BYTE");
        }
        if (maskImage.getMinX() != dataImage.getMinX()) {
            throw new IllegalStateException("maskImage.getMinX() != dataImage.getMinX()");
        }
        if (maskImage.getMinY() != dataImage.getMinY()) {
            throw new IllegalStateException("maskImage.getMinY() != dataImage.getMinY()");
        }
        if (maskImage.getWidth() != dataImage.getWidth()) {
            throw new IllegalStateException("maskImage.getWidth() != dataImage.getWidth()");
        }
        if (maskImage.getHeight() != dataImage.getHeight()) {
            throw new IllegalStateException("maskImage.getHeight() != dataImage.getHeight()");
        }
    }

    static PlanarImage getEffectiveMaskImage(RasterDataNode raster, int level, RenderedImage roiImage) {
        PlanarImage maskImage = ImageManager.getInstance().getValidMaskImage(raster, level);
        if (maskImage == roiImage) {
            return maskImage;
        }
        if (roiImage != null) {
            if (maskImage != null) {
                ImageLayout imageLayout = new ImageLayout();
                imageLayout.setTileWidth(maskImage.getTileWidth());
                imageLayout.setTileHeight(maskImage.getTileHeight());
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
                maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)roiImage, (RenderingHints)hints);
            } else {
                maskImage = PlanarImage.wrapRenderedImage((RenderedImage)roiImage);
            }
        }
        return maskImage;
    }

    static Shape getEffectiveShape(RasterDataNode raster, Shape roiShape) {
        Shape validShape = raster.getValidShape();
        if (validShape == roiShape) {
            return validShape;
        }
        Shape effectiveShape = validShape;
        if (validShape != null && roiShape != null) {
            Area area = new Area(validShape);
            area.intersect(new Area(roiShape));
            effectiveShape = area;
        } else if (roiShape != null) {
            effectiveShape = roiShape;
        }
        return effectiveShape;
    }

    static Histogram createHistogram(int binCount, double minimum, double maximum, boolean logHistogram, boolean intHistogram) {
        Scaling histogramScaling = Stx.getHistogramScaling(logHistogram);
        if (intHistogram) {
            maximum += 1.0;
        } else if (maximum == minimum) {
            if (maximum < Double.MAX_VALUE) {
                maximum = Math.nextUp(maximum);
            } else {
                minimum = Math.nextAfter(minimum, Double.NEGATIVE_INFINITY);
            }
        }
        return new Histogram(binCount, histogramScaling.scale(minimum), histogramScaling.scale(maximum), 1);
    }

    static Histogram createHistogram(double minimum, double maximum, boolean logHistogram, boolean intHistogram, int[] bins) {
        Histogram histogram = StxFactory.createHistogram(bins.length, minimum, maximum, logHistogram, intHistogram);
        System.arraycopy(bins, 0, histogram.getBins(0), 0, bins.length);
        return histogram;
    }

    static long computeSum(int[] sampleFrequencies) {
        long sum = 0L;
        for (int sampleFrequency : sampleFrequencies) {
            sum += (long)sampleFrequency;
        }
        return sum;
    }

    static double computeMedian(Histogram histogram, long sampleCount) {
        boolean isEven = sampleCount % 2L == 0L;
        double halfSampleCount = (double)sampleCount / 2.0;
        boolean bandIndex = false;
        int[] bins = histogram.getBins(0);
        long currentSampleCount = 0L;
        int lastConsideredBinIndex = 0;
        int binsLength = bins.length;
        for (int i = 0; i < binsLength; ++i) {
            if ((double)(currentSampleCount += (long)bins[i]) > halfSampleCount) {
                if (isEven) {
                    double binValue = StxFactory.getMeanOfBin(histogram, 0, i);
                    double lastBinValue = StxFactory.getMeanOfBin(histogram, 0, lastConsideredBinIndex);
                    return (lastBinValue + binValue) / 2.0;
                }
                double binLowValue = histogram.getBinLowValue(0, i);
                double binMaxValue = histogram.getBinLowValue(0, i + 1);
                double previousSampleCount = currentSampleCount - (long)bins[i];
                double weight = (halfSampleCount - previousSampleCount) / ((double)currentSampleCount - previousSampleCount);
                return binLowValue * (1.0 - weight) + binMaxValue * weight;
            }
            if (bins[i] <= 0) continue;
            lastConsideredBinIndex = i;
        }
        return Double.NaN;
    }

    static double getMeanOfBin(Histogram histogram, int bandIndex, int binIndex) {
        double binLowValue = histogram.getBinLowValue(bandIndex, binIndex);
        double binMaxValue = histogram.getBinLowValue(bandIndex, binIndex + 1);
        return (binLowValue + binMaxValue) / 2.0;
    }
}

