/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;

public class SampleCoding
extends MetadataElement {
    public SampleCoding(String name) {
        super(name);
    }

    @Override
    public void addElement(MetadataElement element) {
    }

    @Override
    public void addAttribute(MetadataAttribute attribute) {
        if (!attribute.getData().isInt()) {
            throw new IllegalArgumentException("attribute value is not a integer");
        }
        if (attribute.getData().getNumElems() == 0) {
            throw new IllegalArgumentException("attribute value is missing");
        }
        super.addAttribute(attribute);
    }

    public MetadataAttribute addSample(String name, int value, String description) {
        return this.addSamples(name, new int[]{value}, description);
    }

    public MetadataAttribute addSamples(String name, int[] values, String description) {
        Guardian.assertNotNull("name", name);
        ProductData productData = ProductData.createInstance(22, values.length);
        MetadataAttribute attribute = new MetadataAttribute(name, productData, false);
        attribute.setDataElems(values);
        if (description != null) {
            attribute.setDescription(description);
        }
        this.addAttribute(attribute);
        return attribute;
    }

    public int getSampleCount() {
        return this.getNumAttributes();
    }

    public String getSampleName(int index) {
        return this.getAttributeAt(index).getName();
    }

    public int getSampleValue(int index) {
        return this.getAttributeAt(index).getData().getElemInt();
    }
}

