/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.RGBChannelDef;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.image.ImageManager;

public class ImageInfo
implements Cloneable {
    public static final Color NO_COLOR = new Color(0, 0, 0, 0);
    @Deprecated
    public static final String HISTOGRAM_MATCHING_OFF = "off";
    @Deprecated
    public static final String HISTOGRAM_MATCHING_EQUALIZE = "equalize";
    @Deprecated
    public static final String HISTOGRAM_MATCHING_NORMALIZE = "normalize";
    private ColorPaletteDef colorPaletteDef;
    private RGBChannelDef rgbChannelDef;
    private Color noDataColor;
    private HistogramMatching histogramMatching;
    private String uncertaintyBandName;
    private boolean logScaled;
    private UncertaintyVisualisationMode uncertaintyVisualisationMode;

    public ImageInfo(ColorPaletteDef colorPaletteDef) {
        Assert.notNull((Object)colorPaletteDef, (String)"colorPaletteDef");
        this.colorPaletteDef = colorPaletteDef;
        this.rgbChannelDef = null;
        this.noDataColor = NO_COLOR;
        this.histogramMatching = HistogramMatching.None;
        this.uncertaintyVisualisationMode = UncertaintyVisualisationMode.None;
    }

    public ImageInfo(RGBChannelDef rgbChannelDef) {
        Assert.notNull((Object)rgbChannelDef, (String)"rgbChannelDef");
        this.colorPaletteDef = null;
        this.rgbChannelDef = rgbChannelDef;
        this.noDataColor = NO_COLOR;
        this.histogramMatching = HistogramMatching.None;
        this.uncertaintyVisualisationMode = UncertaintyVisualisationMode.None;
    }

    public ColorPaletteDef getColorPaletteDef() {
        return this.colorPaletteDef;
    }

    public RGBChannelDef getRgbChannelDef() {
        return this.rgbChannelDef;
    }

    public Color getNoDataColor() {
        return this.noDataColor;
    }

    public void setNoDataColor(Color noDataColor) {
        Assert.notNull((Object)noDataColor, (String)"noDataColor");
        this.noDataColor = noDataColor;
    }

    public String getUncertaintyBandName() {
        return this.uncertaintyBandName;
    }

    public void setUncertaintyBandName(String uncertaintyBandName) {
        this.uncertaintyBandName = uncertaintyBandName;
    }

    public HistogramMatching getHistogramMatching() {
        return this.histogramMatching;
    }

    public void setHistogramMatching(HistogramMatching histogramMatching) {
        Assert.notNull((Object)((Object)histogramMatching), (String)"histogramMatching");
        this.histogramMatching = histogramMatching;
    }

    public UncertaintyVisualisationMode getUncertaintyVisualisationMode() {
        return this.uncertaintyVisualisationMode;
    }

    public void setUncertaintyVisualisationMode(UncertaintyVisualisationMode uncertaintyVisualisationMode) {
        this.uncertaintyVisualisationMode = uncertaintyVisualisationMode;
    }

    public boolean isLogScaled() {
        return this.logScaled;
    }

    public void setLogScaled(boolean logScaled) {
        this.logScaled = logScaled;
    }

    public Color[] getColors() {
        return this.colorPaletteDef != null ? this.colorPaletteDef.getColors() : new Color[]{};
    }

    public int getColorComponentCount() {
        if (this.noDataColor.getAlpha() < 255) {
            return 4;
        }
        if (this.colorPaletteDef != null) {
            Color[] colors;
            for (Color color : colors = this.colorPaletteDef.getColors()) {
                if (color.getAlpha() >= 255) continue;
                return 4;
            }
        }
        if (this.rgbChannelDef != null && this.rgbChannelDef.isAlphaUsed()) {
            return 4;
        }
        return 3;
    }

    public IndexColorModel createIndexColorModel(Scaling scaling) {
        if (this.colorPaletteDef == null) {
            return null;
        }
        Color[] palette = ImageManager.createColorPalette(this);
        int numColors = palette.length;
        byte[] red = new byte[numColors];
        byte[] green = new byte[numColors];
        byte[] blue = new byte[numColors];
        for (int i = 0; i < palette.length; ++i) {
            Color color = palette[i];
            red[i] = (byte)color.getRed();
            green[i] = (byte)color.getGreen();
            blue[i] = (byte)color.getBlue();
        }
        return new IndexColorModel(numColors <= 256 ? 8 : 16, numColors, red, green, blue);
    }

    public ComponentColorModel createComponentColorModel() {
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = this.getColorComponentCount() == 4 ? new ComponentColorModel(cs, true, false, 3, 0) : new ComponentColorModel(cs, false, false, 1, 0);
        return cm;
    }

    public final ImageInfo clone() {
        try {
            ImageInfo imageInfo = (ImageInfo)super.clone();
            if (this.colorPaletteDef != null) {
                imageInfo.colorPaletteDef = (ColorPaletteDef)this.colorPaletteDef.clone();
            }
            if (this.rgbChannelDef != null) {
                imageInfo.rgbChannelDef = (RGBChannelDef)this.rgbChannelDef.clone();
            }
            return imageInfo;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ImageInfo createDeepCopy() {
        return this.clone();
    }

    public void dispose() {
        if (this.colorPaletteDef != null) {
            this.colorPaletteDef.dispose();
        }
        this.colorPaletteDef = null;
        this.rgbChannelDef = null;
    }

    public void setColors(Color[] colors) {
        ColorPaletteDef cpd = this.getColorPaletteDef();
        int numPoints = cpd.getNumPoints();
        for (int i = 0; i < numPoints; ++i) {
            ColorPaletteDef.Point point = cpd.getPointAt(i);
            point.setColor(colors[i % colors.length]);
        }
    }

    public void setColorPaletteDef(ColorPaletteDef colorPaletteDef, double minSample, double maxSample, boolean autoDistribute) {
        ImageInfo.transferPoints(colorPaletteDef, minSample, maxSample, autoDistribute, this.getColorPaletteDef());
    }

    private static void transferPoints(ColorPaletteDef sourceCPD, double minSample, double maxSample, boolean autoDistribute, ColorPaletteDef targetCPD) {
        if (autoDistribute || sourceCPD.isAutoDistribute()) {
            ImageInfo.alignNumPoints(sourceCPD, targetCPD);
            double minDisplaySample = sourceCPD.getMinDisplaySample();
            double maxDisplaySample = sourceCPD.getMaxDisplaySample();
            double delta1 = maxSample > minSample ? maxSample - minSample : 1.0;
            double delta2 = maxDisplaySample > minDisplaySample ? maxDisplaySample - minDisplaySample : 1.0;
            double b = delta1 / delta2;
            double a = minSample - minDisplaySample * b;
            for (int i = 0; i < sourceCPD.getNumPoints(); ++i) {
                targetCPD.getPointAt(i).setSample(a + b * sourceCPD.getPointAt(i).getSample());
                targetCPD.getPointAt(i).setColor(sourceCPD.getPointAt(i).getColor());
                targetCPD.getPointAt(i).setLabel(sourceCPD.getPointAt(i).getLabel());
            }
        } else {
            targetCPD.setPoints((ColorPaletteDef.Point[])sourceCPD.getPoints().clone());
        }
    }

    private static void alignNumPoints(ColorPaletteDef sourceCPD, ColorPaletteDef targetCPD) {
        block3: {
            int deltaNumPoints;
            block2: {
                deltaNumPoints = targetCPD.getNumPoints() - sourceCPD.getNumPoints();
                if (deltaNumPoints >= 0) break block2;
                while (deltaNumPoints != 0) {
                    targetCPD.insertPointAfter(0, new ColorPaletteDef.Point());
                    ++deltaNumPoints;
                }
                break block3;
            }
            if (deltaNumPoints <= 0) break block3;
            while (deltaNumPoints != 0) {
                targetCPD.removePointAt(1);
                --deltaNumPoints;
            }
        }
    }

    public static HistogramMatching getHistogramMatching(String mode) {
        HistogramMatching histogramMatchingEnum = HistogramMatching.None;
        if ("Equalize".equalsIgnoreCase(mode)) {
            histogramMatchingEnum = HistogramMatching.Equalize;
        } else if ("Normalize".equalsIgnoreCase(mode)) {
            histogramMatchingEnum = HistogramMatching.Normalize;
        }
        return histogramMatchingEnum;
    }

    public static enum UncertaintyVisualisationMode {
        None,
        Transparency_Blending,
        Monochromatic_Blending,
        Polychromatic_Blending,
        Polychromatic_Overlay;

    }

    public static enum HistogramMatching {
        None,
        Equalize,
        Normalize;

    }
}

