/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;

class GeoPosToPixelPosFilter
implements CoordinateSequenceFilter {
    public int count = 0;
    private int numCoordinates;
    private GeoCoding geoCoding;

    public GeoPosToPixelPosFilter(int numCoordinates, GeoCoding geoCoding) {
        this.numCoordinates = numCoordinates;
        this.geoCoding = geoCoding;
    }

    public void filter(CoordinateSequence seq, int i) {
        Coordinate coord = seq.getCoordinate(i);
        PixelPos pixelPos = this.geoCoding.getPixelPos(new GeoPos(coord.y, coord.x), null);
        double x = Math.round(pixelPos.x * 10000.0) / 10000L;
        double y = Math.round(pixelPos.y * 10000.0) / 10000L;
        coord.setCoordinate(new Coordinate(x, y));
        ++this.count;
    }

    public boolean isDone() {
        return this.numCoordinates == this.count;
    }

    public boolean isGeometryChanged() {
        return this.numCoordinates == this.count;
    }
}

