/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class MultiGeometryTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;

    public MultiGeometryTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return GML.MultiGeometryType;
    }

    public Class getType() {
        return GeometryCollection.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (node.hasChild(Geometry.class)) {
            geometries.addAll(node.getChildValues(Geometry.class));
        }
        if (node.hasChild(Geometry[].class)) {
            Geometry[] g = (Geometry[])node.getChildValue(Geometry[].class);
            for (int i = 0; i < g.length; ++i) {
                geometries.add(g[i]);
            }
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (GML.geometryMember.equals(name)) {
            GeometryCollection multiGeometry = (GeometryCollection)object;
            Geometry[] members = new Geometry[multiGeometry.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = multiGeometry.getGeometryN(i);
            }
            GML3EncodingUtils.setChildIDs((Geometry)multiGeometry);
            return members;
        }
        return null;
    }
}

