/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.progress;

import com.bc.ceres.swing.SwingHelper;
import com.jidesoft.swing.JideButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProgressDialog {
    public static final Color SELECTED_BORDER_COLOR = new Color(8, 36, 107);
    private static final Color SELECTED_BACKGROUND_COLOR = new Color(130, 146, 185);
    private static final Color ROLLOVER_BACKGROUND_COLOR = new Color(181, 190, 214);
    private static final int BUTTON_MIN_SIZE = 16;
    private Component parentComponent;
    private String title;
    private JComponent messageComponent;
    private JComponent extensibleMessageComponent;
    int notExtendedDialogHeight;
    private String note;
    private int minimum;
    private int maximum;
    private boolean cancelable;
    private Dialog.ModalityType modalityType;
    private JDialog dialog;
    private JLabel noteLabel;
    private JProgressBar progressBar;
    public JButton cancelButton;
    private boolean canceled = false;
    private boolean placeExtensibleMessageAboveProgressBar;
    private boolean placeMessageAboveProgressBar;

    public ProgressDialog(Component parentComponent) {
        this.parentComponent = parentComponent;
        this.minimum = 0;
        this.maximum = 100;
        this.title = UIManager.getString("ProgressMonitor.progressText");
        this.note = "";
        this.cancelable = true;
        this.modalityType = Dialog.ModalityType.MODELESS;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public JComponent getMessageComponent() {
        return this.messageComponent;
    }

    public void setMessageComponent(JComponent messageComponent) {
        this.setMessageComponent(messageComponent, true);
    }

    public void setMessageComponent(JComponent messageComponent, boolean placeMessageAboveProgressBar) {
        this.messageComponent = messageComponent;
        this.placeMessageAboveProgressBar = placeMessageAboveProgressBar;
    }

    public JComponent getExtensibleMessageComponent() {
        return this.extensibleMessageComponent;
    }

    public void setExtensibleMessageComponent(JComponent extensibleMessageComponent, boolean placeExtensibleMessageAboveProgressBar) {
        this.extensibleMessageComponent = extensibleMessageComponent;
        this.placeExtensibleMessageAboveProgressBar = placeExtensibleMessageAboveProgressBar;
    }

    public Dialog.ModalityType getModalityType() {
        return this.modalityType;
    }

    public void setModalityType(Dialog.ModalityType modalityType) {
        this.modalityType = modalityType;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean cancelable) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(cancelable && !this.canceled);
        }
        this.cancelable = cancelable;
    }

    public void setProgress(int progress) {
        if (progress >= this.maximum) {
            this.close();
            return;
        }
        if (this.progressBar != null) {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue(progress);
        }
    }

    public void cancel() {
        if (this.isCancelable()) {
            this.canceled = true;
            this.setCancelable(false);
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.progressBar = null;
            this.noteLabel = null;
            this.cancelButton = null;
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (this.progressBar != null) {
            this.progressBar.setMinimum(minimum);
        }
        this.minimum = minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (this.progressBar != null) {
            this.progressBar.setMaximum(maximum);
        }
        this.maximum = maximum;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setTitle(String title) {
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setNote(String note) {
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
        this.note = note;
    }

    public String getNote() {
        return this.note;
    }

    public void show() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        Window parentWindow = null;
        if (this.parentComponent != null) {
            parentWindow = SwingUtilities.getWindowAncestor(this.parentComponent);
        }
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(this.minimum);
        this.progressBar.setMaximum(this.maximum);
        this.progressBar.setIndeterminate(true);
        Dimension preferredSize = this.progressBar.getPreferredSize();
        preferredSize.width = Math.max(300, preferredSize.width);
        this.progressBar.setPreferredSize(preferredSize);
        this.noteLabel = new JLabel(this.note);
        JPanel messagePanel = new JPanel(new BorderLayout(4, 4));
        if (this.messageComponent != null) {
            messagePanel.add((Component)this.messageComponent, "Center");
        }
        messagePanel.add((Component)this.noteLabel, "South");
        JPanel progressPanel = new JPanel(new BorderLayout(4, 4));
        progressPanel.add((Component)this.progressBar, "South");
        JPanel extensibleMessagePanel = new JPanel(new BorderLayout(4, 4));
        if (this.extensibleMessageComponent != null) {
            this.extensibleMessageComponent.setVisible(false);
            final ImageIcon[] icons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("icons/PanelUp12.png")), new ImageIcon(this.getClass().getResource("icons/PanelDown12.png"))};
            final ImageIcon[] rolloverIcons = new ImageIcon[]{ProgressDialog.createRolloverIcon(icons[0]), ProgressDialog.createRolloverIcon(icons[1])};
            final JLabel extendLabel = new JLabel();
            String moreText = "More";
            String lessText = "Less";
            final JideButton extendButton = new JideButton(icons[1]);
            this.configure(extendButton);
            extendLabel.setText("More");
            extendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressDialog.this.extensibleMessageComponent.isVisible()) {
                        ProgressDialog.this.extensibleMessageComponent.setVisible(false);
                        extendButton.setIcon(icons[1]);
                        extendButton.setRolloverIcon(rolloverIcons[1]);
                        extendLabel.setText("More");
                        Dimension size = ProgressDialog.this.dialog.getSize();
                        ProgressDialog.this.dialog.setSize(size.width, ProgressDialog.this.notExtendedDialogHeight);
                        ProgressDialog.this.dialog.pack();
                    } else {
                        ProgressDialog.this.extensibleMessageComponent.setVisible(true);
                        extendButton.setIcon(icons[0]);
                        extendButton.setRolloverIcon(rolloverIcons[0]);
                        extendLabel.setText("Less");
                        Dimension size = ProgressDialog.this.dialog.getSize();
                        ProgressDialog.this.dialog.setSize(size.width, Math.max(ProgressDialog.this.notExtendedDialogHeight + 200, size.height));
                    }
                }
            });
            JPanel extendPanel = new JPanel(new FlowLayout(0));
            extendPanel.add(extendButton);
            extendPanel.add(extendLabel);
            extensibleMessagePanel.add((Component)extendPanel, "North");
            extensibleMessagePanel.add((Component)this.extensibleMessageComponent, "Center");
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (this.cancelable) {
            this.cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.cancel();
                }
            });
            buttonPanel.add(this.cancelButton);
        }
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPanel = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        if (this.messageComponent != null) {
            gbc.gridy = 3;
            if (this.placeMessageAboveProgressBar) {
                gbc.gridy = 0;
            }
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbl.addLayoutComponent(messagePanel, gbc);
            contentPanel.add(messagePanel);
        }
        if (this.extensibleMessageComponent != null) {
            gbc.gridy = 4;
            if (this.placeExtensibleMessageAboveProgressBar) {
                gbc.gridy = 1;
            }
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbl.addLayoutComponent(extensibleMessagePanel, gbc);
            contentPanel.add(extensibleMessagePanel);
        }
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbl.addLayoutComponent(this.progressBar, gbc);
        contentPanel.add(this.progressBar);
        if (this.cancelable) {
            gbc.gridy = 5;
            gbl.addLayoutComponent(buttonPanel, gbc);
            contentPanel.add(buttonPanel);
        }
        this.dialog = new JDialog(parentWindow, this.title, this.modalityType);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.cancel();
            }
        });
        this.dialog.setContentPane(contentPanel);
        this.dialog.pack();
        SwingHelper.centerComponent(this.dialog, parentWindow);
        this.notExtendedDialogHeight = this.dialog.getHeight();
        this.dialog.setVisible(true);
    }

    private void configure(AbstractButton button) {
        Icon icon = button.getIcon();
        int space = 3;
        Dimension prefSize = new Dimension(Math.max(icon.getIconWidth(), 16) + 3, Math.max(icon.getIconHeight(), 16) + 3);
        Dimension minSize = new Dimension(Math.max(icon.getIconWidth(), 16), Math.max(icon.getIconHeight(), 16));
        Dimension maxSize = new Dimension(Math.max(icon.getIconWidth(), 16) + 3, Math.max(icon.getIconHeight(), 16) + 3);
        button.setPreferredSize(prefSize);
        button.setMaximumSize(maxSize);
        button.setMinimumSize(minSize);
    }

    public static ImageIcon createRolloverIcon(ImageIcon imageIcon) {
        return new ImageIcon(ProgressDialog.createRolloverImage(imageIcon.getImage()));
    }

    private static Image createRolloverImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new BrightBlueFilter()));
    }

    private static class BrightBlueFilter
    extends RGBImageFilter {
        public BrightBlueFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int i;
            int a = (rgb & 0xFF000000) >> 24;
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            r = g = (i = (r + g + b) / 3);
            b = 255;
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

