/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class NumericEditor
extends PropertyEditor {
    @Override
    public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
        ValueSet valueSet = propertyDescriptor.getValueSet();
        Class type = propertyDescriptor.getType();
        return valueSet == null && NumericEditor.isNumericType(type);
    }

    @Override
    public JComponent createEditorComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JTextField textField = new JTextField();
        textField.setHorizontalAlignment(4);
        int fontSize = textField.getFont().getSize();
        textField.setFont(new Font("Courier", 0, fontSize));
        TextComponentAdapter adapter = new TextComponentAdapter(textField);
        bindingContext.bind(propertyDescriptor.getName(), adapter);
        return textField;
    }

    protected static boolean isNumericType(Class<?> type) {
        return Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type) || Number.class.isAssignableFrom(type);
    }
}

