/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFRenderedImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.geotiff.TiffFileInfo;
import org.esa.snap.dataio.geotiff.TiffTagToMetadataConverter;
import org.esa.snap.dataio.geotiff.Utils;
import org.esa.snap.dataio.geotiff.internal.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.factory.Hints;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class GeoTiffProductReader
extends AbstractProductReader {
    private static final int FIRST_IMAGE = 0;
    private ImageInputStream inputStream;
    private Map<Band, Integer> bandMap;
    private TIFFImageReader imageReader;
    private boolean isGlobalShifted180;

    public GeoTiffProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected synchronized Product readProductNodesImpl() throws IOException {
        File inputFile = null;
        Object input = this.getInput();
        if (input instanceof String) {
            input = new File((String)input);
        }
        if (input instanceof File && (inputFile = (File)input).getName().toLowerCase().endsWith(".zip")) {
            ZipFile productZip = new ZipFile(inputFile, 1);
            Enumeration<? extends ZipEntry> entries = productZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName().toLowerCase();
                if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                input = productZip.getInputStream(zipEntry);
                break;
            }
        }
        this.inputStream = ImageIO.createImageInputStream(input);
        return this.readGeoTIFFProduct(this.inputStream, inputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        if (this.isGlobalShifted180) {
            this.readBandRasterDataImplGlobalShifted180(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
        } else {
            int destSize = destWidth * destHeight;
            pm.beginTask("Reading data...", 3);
            try {
                Raster data = this.readRect(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight);
                pm.worked(1);
                Integer bandIdx = this.bandMap.get(destBand);
                if (bandIdx == null) {
                    bandIdx = 0;
                }
                DataBuffer dataBuffer = data.getDataBuffer();
                SampleModel sampleModel = data.getSampleModel();
                int dataBufferType = dataBuffer.getDataType();
                boolean isInteger = dataBufferType == 2 || dataBufferType == 1 || dataBufferType == 3;
                boolean isIntegerTarget = destBuffer.getElems() instanceof int[];
                if (isInteger && isIntegerTarget) {
                    sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, (int[])destBuffer.getElems(), dataBuffer);
                } else if (dataBufferType == 4 && destBuffer.getElems() instanceof float[]) {
                    sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, (float[])destBuffer.getElems(), dataBuffer);
                } else {
                    double[] dArray = new double[destSize];
                    sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, dArray, dataBuffer);
                    if (destBuffer.getElems() instanceof double[]) {
                        System.arraycopy(dArray, 0, destBuffer.getElems(), 0, dArray.length);
                    } else {
                        int i = 0;
                        for (double value : dArray) {
                            destBuffer.setElemDoubleAt(i++, value);
                        }
                    }
                }
                pm.worked(1);
            }
            finally {
                pm.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBandRasterDataImplGlobalShifted180(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int destSize = destWidth * destHeight;
        pm.beginTask("Reading data...", 3);
        try {
            Raster dataLeft = this.readRect(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth / 2, destHeight);
            Raster dataRight = this.readRect(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX + destWidth / 2, destOffsetY, destWidth / 2, destHeight);
            pm.worked(1);
            double[] dArrayLeft = new double[destSize / 2];
            double[] dArrayRight = new double[destSize / 2];
            Integer bandIdx = this.bandMap.get(destBand);
            if (bandIdx == null) {
                bandIdx = 0;
            }
            DataBuffer dataBufferLeft = dataLeft.getDataBuffer();
            DataBuffer dataBufferRight = dataRight.getDataBuffer();
            SampleModel sampleModelLeft = dataLeft.getSampleModel();
            SampleModel sampleModelRight = dataRight.getSampleModel();
            sampleModelLeft.getSamples(0, 0, dataLeft.getWidth(), dataLeft.getHeight(), (int)bandIdx, dArrayLeft, dataBufferLeft);
            sampleModelRight.getSamples(0, 0, dataRight.getWidth(), dataRight.getHeight(), (int)bandIdx, dArrayRight, dataBufferRight);
            pm.worked(1);
            int dArrayIndex = 0;
            for (int y = 0; y < destHeight; ++y) {
                int x;
                for (x = 0; x < destWidth / 2; ++x) {
                    destBuffer.setElemDoubleAt(dArrayIndex++, dArrayRight[y * destWidth / 2 + x]);
                }
                for (x = 0; x < destWidth / 2; ++x) {
                    destBuffer.setElemDoubleAt(dArrayIndex++, dArrayLeft[y * destWidth / 2 + x]);
                }
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private synchronized Raster readRect(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight) throws IOException {
        ImageReadParam readParam = this.imageReader.getDefaultReadParam();
        int subsamplingXOffset = sourceOffsetX % sourceStepX;
        int subsamplingYOffset = sourceOffsetY % sourceStepY;
        readParam.setSourceSubsampling(sourceStepX, sourceStepY, subsamplingXOffset, subsamplingYOffset);
        RenderedImage subsampledImage = this.imageReader.readAsRenderedImage(0, readParam);
        return subsampledImage.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
    }

    public synchronized void close() throws IOException {
        super.close();
        this.inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Product readGeoTIFFProduct(ImageInputStream stream, File inputFile) throws IOException {
        String s;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (!(reader instanceof TIFFImageReader)) continue;
            this.imageReader = (TIFFImageReader)reader;
            break;
        }
        if (this.imageReader == null) {
            throw new IOException("GeoTiff imageReader not found");
        }
        this.imageReader.setInput((Object)stream);
        Product product = null;
        TIFFImageMetadata imageMetadata = (TIFFImageMetadata)this.imageReader.getImageMetadata(0);
        TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)imageMetadata.getRootIFD());
        TIFFField field = tiffInfo.getField(65000);
        if (field != null && field.getType() == 2 && (s = field.getAsString(0).trim()).contains("<Dimap_Document")) {
            try (InputStream is = null;){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                is = new ByteArrayInputStream(s.getBytes());
                Document document = new DOMBuilder().build(builder.parse(is));
                product = DimapProductHelpers.createProduct((Document)document);
                GeoTiffProductReader.removeGeoCodingAndTiePointGrids(product);
                this.initBandsMap(product);
            }
        }
        if (product == null) {
            String productName = null;
            if (tiffInfo.containsField(270)) {
                TIFFField field1 = tiffInfo.getField(270);
                productName = field1.getAsString(0).trim();
            }
            productName = (productName == null || productName.isEmpty()) && inputFile != null ? FileUtils.getFilenameWithoutExtension((File)inputFile) : "geotiff";
            String productType = this.getReaderPlugIn().getFormatNames()[0];
            int width = this.imageReader.getWidth(0);
            int height = this.imageReader.getHeight(0);
            product = new Product(productName, productType, width, height, (ProductReader)this);
            this.addBandsToProduct(tiffInfo, product);
        }
        if (tiffInfo.isGeotiff()) {
            this.applyGeoCoding(tiffInfo, imageMetadata, product);
        }
        TiffTagToMetadataConverter.addTiffTagsToMetadata(imageMetadata, tiffInfo, product.getMetadataRoot());
        if (inputFile != null) {
            product.setFileLocation(inputFile);
        }
        this.setPreferredTiling(product);
        return product;
    }

    private void initBandsMap(Product product) {
        Band[] bands = product.getBands();
        this.bandMap = new HashMap<Band, Integer>(bands.length);
        for (Band band : bands) {
            if (band instanceof VirtualBand || band instanceof FilterBand) continue;
            this.bandMap.put(band, this.bandMap.size());
        }
    }

    private static void removeGeoCodingAndTiePointGrids(Product product) {
        TiePointGrid[] pointGrids;
        product.setSceneGeoCoding(null);
        for (TiePointGrid pointGrid : pointGrids = product.getTiePointGrids()) {
            product.removeTiePointGrid(pointGrid);
        }
    }

    private void addBandsToProduct(TiffFileInfo tiffInfo, Product product) throws IOException {
        ImageReadParam readParam = this.imageReader.getDefaultReadParam();
        TIFFRenderedImage baseImage = (TIFFRenderedImage)this.imageReader.readAsRenderedImage(0, readParam);
        SampleModel sampleModel = baseImage.getSampleModel();
        int numBands = sampleModel.getNumBands();
        int productDataType = ImageManager.getProductDataType((int)sampleModel.getDataType());
        this.bandMap = new HashMap<Band, Integer>(numBands);
        for (int i = 0; i < numBands; ++i) {
            String bandName = String.format("band_%d", i + 1);
            Band band = product.addBand(bandName, productDataType);
            if (tiffInfo.containsField(320) && baseImage.getColorModel() instanceof IndexColorModel) {
                band.setImageInfo(GeoTiffProductReader.createIndexedImageInfo(product, baseImage, band));
            }
            this.bandMap.put(band, i);
        }
    }

    private void setPreferredTiling(Product product) throws IOException {
        Dimension dimension = this.isBadTiling() ? JAIUtils.computePreferredTileSize((int)this.imageReader.getWidth(0), (int)this.imageReader.getHeight(0), (int)1) : new Dimension(this.imageReader.getTileWidth(0), this.imageReader.getTileHeight(0));
        if (this.isGlobalShifted180) {
            product.setPreferredTileSize(new Dimension(this.imageReader.getWidth(0), this.imageReader.getHeight(0)));
        } else {
            product.setPreferredTileSize(dimension);
        }
    }

    private boolean isBadTiling() throws IOException {
        int imageHeight = this.imageReader.getHeight(0);
        int tileHeight = this.imageReader.getTileHeight(0);
        int imageWidth = this.imageReader.getWidth(0);
        int tileWidth = this.imageReader.getTileWidth(0);
        return tileWidth <= 1 || tileHeight <= 1 || imageWidth == tileWidth || imageHeight == tileHeight;
    }

    private static ImageInfo createIndexedImageInfo(Product product, TIFFRenderedImage baseImage, Band band) {
        IndexColorModel colorModel = (IndexColorModel)baseImage.getColorModel();
        IndexCoding indexCoding = new IndexCoding("color_map");
        int colorCount = colorModel.getMapSize();
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[colorCount];
        for (int j = 0; j < colorCount; ++j) {
            String name = String.format("I%3d", j);
            indexCoding.addIndex(name, j, "");
            points[j] = new ColorPaletteDef.Point((double)j, new Color(colorModel.getRGB(j)), name);
        }
        product.getIndexCodingGroup().add((ProductNode)indexCoding);
        band.setSampleCoding((SampleCoding)indexCoding);
        return new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    private void applyGeoCoding(TiffFileInfo info, TIFFImageMetadata metadata, Product product) {
        if (info.containsField(33922)) {
            double[] tiePoints = info.getField(33922).getAsDoubles();
            boolean isGlobal = GeoTiffProductReader.isGlobal(product, info);
            double deltaX = Math.ceil(360.0 / (double)product.getSceneRasterWidth());
            if (isGlobal && tiePoints.length == 6 && Math.abs(tiePoints[3]) < deltaX) {
                this.isGlobalShifted180 = true;
                tiePoints[3] = tiePoints[3] - 180.0;
            }
            if (GeoTiffProductReader.canCreateTiePointGeoCoding(tiePoints)) {
                GeoTiffProductReader.applyTiePointGeoCoding(info, tiePoints, product);
            } else if (GeoTiffProductReader.canCreateGcpGeoCoding(tiePoints)) {
                GeoTiffProductReader.applyGcpGeoCoding(info, tiePoints, product);
            }
        }
        if (product.getSceneGeoCoding() == null) {
            try {
                GeoTiffProductReader.applyGeoCodingFromGeoTiff(metadata, product);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isGlobal(Product product, TiffFileInfo info) {
        double[] pixelScales;
        boolean isGlobal = false;
        TIFFField pixelScaleField = info.getField(33550);
        if (pixelScaleField != null && GeoTiffProductReader.isPixelScaleValid(pixelScales = pixelScaleField.getAsDoubles())) {
            double widthInDegree = pixelScales[0] * (double)product.getSceneRasterWidth();
            isGlobal = Math.ceil(widthInDegree) >= 360.0;
        }
        return isGlobal;
    }

    private static boolean isPixelScaleValid(double[] pixelScales) {
        return pixelScales != null && !Double.isNaN(pixelScales[0]) && !Double.isInfinite(pixelScales[0]) && !Double.isNaN(pixelScales[1]) && !Double.isInfinite(pixelScales[1]);
    }

    private static void applyGeoCodingFromGeoTiff(TIFFImageMetadata metadata, Product product) throws Exception {
        CoordinateReferenceSystem crs;
        Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        GeoTiffIIOMetadataDecoder metadataDecoder = new GeoTiffIIOMetadataDecoder((IIOMetadata)metadata);
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        GeoTiffMetadata2CRSAdapter geoTiff2CRSAdapter = new GeoTiffMetadata2CRSAdapter(hints);
        MathTransform toModel = GeoTiffProductReader.getRasterToModel(metadataDecoder);
        try {
            crs = geoTiff2CRSAdapter.createCoordinateSystem(metadataDecoder);
        }
        catch (UnsupportedOperationException e) {
            if (toModel == null) {
                throw e;
            }
            crs = DefaultGeographicCRS.WGS84;
        }
        CrsGeoCoding geoCoding = new CrsGeoCoding(crs, imageBounds, (AffineTransform)toModel);
        product.setSceneGeoCoding((GeoCoding)geoCoding);
    }

    private static MathTransform getRasterToModel(GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        LinearTransform xform;
        boolean hasTiePoints = metadata.hasTiePoints();
        boolean hasPixelScales = metadata.hasPixelScales();
        boolean hasModelTransformation = metadata.hasModelTrasformation();
        int rasterType = GeoTiffProductReader.getGeoKeyAsInt(1025, metadata);
        if (rasterType == 0) {
            rasterType = 1;
        }
        if (hasTiePoints && hasPixelScales) {
            TiePoint[] tiePoints = metadata.getModelTiePoints();
            PixelScale pixScales = metadata.getModelPixelScales();
            GeneralMatrix gm = new GeneralMatrix(3);
            double scaleRaster2ModelLongitude = pixScales.getScaleX();
            double scaleRaster2ModelLatitude = -pixScales.getScaleY();
            double tiePointColumn = tiePoints[0].getValueAt(0) + (rasterType == 2 ? 0.5 : 0.0);
            double tiePointRow = tiePoints[0].getValueAt(1) + (rasterType == 2 ? 0.5 : 0.0);
            gm.setElement(0, 0, scaleRaster2ModelLongitude);
            gm.setElement(1, 1, scaleRaster2ModelLatitude);
            gm.setElement(0, 1, 0.0);
            gm.setElement(1, 0, 0.0);
            gm.setElement(0, 2, tiePoints[0].getValueAt(3) - scaleRaster2ModelLongitude * tiePointColumn);
            gm.setElement(1, 2, tiePoints[0].getValueAt(4) - scaleRaster2ModelLatitude * tiePointRow);
            xform = ProjectiveTransform.create((Matrix)gm);
        } else if (hasModelTransformation) {
            if (rasterType == 2) {
                AffineTransform tempTransform = new AffineTransform(metadata.getModelTransformation());
                tempTransform.concatenate(AffineTransform.getTranslateInstance(0.5, 0.5));
                xform = ProjectiveTransform.create((AffineTransform)tempTransform);
            } else {
                assert (rasterType == 1);
                xform = ProjectiveTransform.create((AffineTransform)metadata.getModelTransformation());
            }
        } else {
            throw new GeoTiffException(metadata, "Unknown Raster to Model configuration.", null);
        }
        return xform;
    }

    private static int getGeoKeyAsInt(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            return Integer.parseInt(metadata.getGeoKey(key));
        }
        catch (NumberFormatException ne) {
            SystemUtils.LOG.log(Level.FINE, ne.getMessage(), ne);
            return 0;
        }
    }

    private static void applyTiePointGeoCoding(TiffFileInfo info, double[] tiePoints, Product product) {
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        double xMin = (Double)xSet.first();
        double xMax = (Double)xSet.last();
        double xDiff = (xMax - xMin) / (double)(xSet.size() - 1);
        double yMin = (Double)ySet.first();
        double yMax = (Double)ySet.last();
        double yDiff = (yMax - yMin) / (double)(ySet.size() - 1);
        int width = xSet.size();
        int height = ySet.size();
        int idx = 0;
        HashMap<Double, Integer> xIdx = new HashMap<Double, Integer>();
        for (Double d : xSet) {
            xIdx.put(d, idx);
            ++idx;
        }
        idx = 0;
        HashMap<Double, Integer> yIdx = new HashMap<Double, Integer>();
        for (Double val : ySet) {
            yIdx.put(val, idx);
            ++idx;
        }
        float[] fArray = new float[width * height];
        float[] lons = new float[width * height];
        for (int i = 0; i < tiePoints.length; i += 6) {
            int idxX = (Integer)xIdx.get(tiePoints[i + 0]);
            int idxY = (Integer)yIdx.get(tiePoints[i + 1]);
            int arrayIdx = idxY * width + idxX;
            lons[arrayIdx] = (float)tiePoints[i + 3];
            fArray[arrayIdx] = (float)tiePoints[i + 4];
        }
        String[] names = Utils.findSuitableLatLonNames(product);
        TiePointGrid latGrid = new TiePointGrid(names[0], width, height, xMin, yMin, xDiff, yDiff, fArray);
        TiePointGrid lonGrid = new TiePointGrid(names[1], width, height, xMin, yMin, xDiff, yDiff, lons);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
        Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
        product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid, datum));
    }

    private static boolean canCreateGcpGeoCoding(double[] tiePoints) {
        int numTiePoints = tiePoints.length / 6;
        for (int i = 0; i < numTiePoints; ++i) {
            int offset = i * 6;
            float x = (float)tiePoints[offset + 0];
            float y = (float)tiePoints[offset + 1];
            float lon = (float)tiePoints[offset + 3];
            float lat = (float)tiePoints[offset + 4];
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(lon) || Double.isNaN(lat)) {
                return false;
            }
            PixelPos pixelPos = new PixelPos((double)x, (double)y);
            GeoPos geoPos = new GeoPos((double)lat, (double)lon);
            if (pixelPos.isValid() && geoPos.isValid()) continue;
            return false;
        }
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            return true;
        }
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            return true;
        }
        return numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP();
    }

    private static boolean canCreateTiePointGeoCoding(double[] tiePoints) {
        if (tiePoints.length / 6 <= 1) {
            return false;
        }
        for (double tiePoint : tiePoints) {
            if (!Double.isNaN(tiePoint)) continue;
            return false;
        }
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        return GeoTiffProductReader.isEquiDistance(xSet) && GeoTiffProductReader.isEquiDistance(ySet);
    }

    private static boolean isEquiDistance(SortedSet<Double> set) {
        double min = set.first();
        double max = set.last();
        double diff = (max - min) / (double)(set.size() - 1);
        double diff100000 = diff / 100000.0;
        double maxDiff = diff + diff100000;
        double minDiff = diff - diff100000;
        Double[] values = set.toArray(new Double[set.size()]);
        for (int i = 1; i < values.length; ++i) {
            double currentDiff = values[i] - values[i - 1];
            if (!(currentDiff > maxDiff) && !(currentDiff < minDiff)) continue;
            return false;
        }
        return true;
    }

    private static void applyGcpGeoCoding(TiffFileInfo info, double[] tiePoints, Product product) {
        GcpGeoCoding.Method method;
        int numTiePoints = tiePoints.length / 6;
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL3;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL2;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL1;
        } else {
            return;
        }
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        GcpDescriptor gcpDescriptor = GcpDescriptor.getInstance();
        PlacemarkGroup gcpGroup = product.getGcpGroup();
        for (int i = 0; i < numTiePoints; ++i) {
            int offset = i * 6;
            float x = (float)tiePoints[offset + 0];
            float y = (float)tiePoints[offset + 1];
            float lon = (float)tiePoints[offset + 3];
            float lat = (float)tiePoints[offset + 4];
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(lon) || Double.isNaN(lat)) continue;
            PixelPos pixelPos = new PixelPos((double)x, (double)y);
            GeoPos geoPos = new GeoPos((double)lat, (double)lon);
            Placemark gcp = Placemark.createPointPlacemark((PlacemarkDescriptor)gcpDescriptor, (String)("gcp_" + i), (String)("GCP_" + i), (String)"", (PixelPos)pixelPos, (GeoPos)geoPos, (GeoCoding)product.getSceneGeoCoding());
            gcpGroup.add((ProductNode)gcp);
        }
        Placemark[] gcps = (Placemark[])gcpGroup.toArray((ProductNode[])new Placemark[gcpGroup.getNodeCount()]);
        SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
        Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
        product.setSceneGeoCoding((GeoCoding)new GcpGeoCoding(method, gcps, width, height, datum));
    }

    private static Datum getDatum(Map<Integer, GeoKeyEntry> geoKeyEntries) {
        int value;
        Datum datum = geoKeyEntries.containsKey(2048) ? ((value = geoKeyEntries.get(2048).getIntValue().intValue()) == 4322 ? Datum.WGS_72 : (value == 4326 ? Datum.WGS_84 : Datum.WGS_84)) : Datum.WGS_84;
        return datum;
    }
}

