/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public interface TableInterface {
    public void createTable() throws SQLException;

    public void validateTable() throws SQLException;

    public void prepareStatements() throws SQLException;

    public static String createTableString(String table, String[] colNames, String[] colTypes) {
        int i = 0;
        StringBuilder s = new StringBuilder(255);
        s.append("create table " + table + " (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),");
        for (String n : colNames) {
            s.append(n);
            s.append(' ');
            s.append(colTypes[i++]);
            s.append(", ");
        }
        return s.substring(0, s.length() - 2) + ')';
    }

    public static String createSaveString(String table, String[] colNames) {
        StringBuilder s = new StringBuilder(255);
        s.append("INSERT INTO " + table + " (");
        for (String n : colNames) {
            s.append(n);
            s.append(", ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(") VALUES (");
        for (String n : colNames) {
            s.append("?, ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(')');
        return s.toString();
    }

    default public void validateTable(Connection dbConnection, String table, String[] colNames, String[] colTypes) throws SQLException {
        try (Statement alterStatement = dbConnection.createStatement();){
            int i = 0;
            for (String n : colNames) {
                block15: {
                    String testStr = "SELECT '" + n + "' FROM " + table;
                    try {
                        alterStatement.executeQuery(testStr);
                    }
                    catch (SQLException e) {
                        if (!e.getSQLState().equals("42X04")) break block15;
                        String alterStr = "ALTER TABLE " + table + " ADD '" + n + "' " + colTypes[i];
                        alterStatement.execute(alterStr);
                    }
                }
                ++i;
            }
        }
    }
}

