/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.texture;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.gpf.FilterWindow;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="GLCM", category="Raster/Image Analysis/Texture Analysis", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Extract Texture Features")
public final class GLCMOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", label="Source Bands")
    private String[] sourceBands = null;
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11"}, defaultValue="9x9", label="Window Size")
    private String windowSizeStr = "9x9";
    @Parameter(valueSet={"0", "45", "90", "135", "ALL"}, defaultValue="ALL", label="Angle")
    private String angleStr = "ALL";
    @Parameter(valueSet={"Equal Distance Quantizer", "Probabilistic Quantizer"}, defaultValue="Probabilistic Quantizer", label="Quantizer")
    private String quantizerStr = "Probabilistic Quantizer";
    @Parameter(valueSet={"8", "16", "32", "64", "128"}, defaultValue="32", label="Quantization Levels")
    private String quantizationLevelsStr = "64";
    @Parameter(description="Pixel displacement", interval="[1, 8]", defaultValue="4", label="Displacement")
    private int displacement = 4;
    @Parameter(description="Output Contrast", defaultValue="true", label="Contrast")
    private Boolean outputContrast = true;
    @Parameter(description="Output Dissimilarity", defaultValue="true", label="Dissimilarity")
    private Boolean outputDissimilarity = true;
    @Parameter(description="Output Homogeneity", defaultValue="true", label="Homogeneity")
    private Boolean outputHomogeneity = true;
    @Parameter(description="Output Angular Second Moment", defaultValue="true", label="Angular Second Moment")
    private Boolean outputASM = true;
    @Parameter(description="Output Energy", defaultValue="true", label="Energy")
    private Boolean outputEnergy = true;
    @Parameter(description="Output Maximum Probability", defaultValue="true", label="Maximum Probability")
    private Boolean outputMAX = true;
    @Parameter(description="Output Entropy", defaultValue="true", label="Entropy")
    private Boolean outputEntropy = true;
    @Parameter(description="Output GLCM Mean", defaultValue="true", label="GLCM Mean")
    private Boolean outputMean = true;
    @Parameter(description="Output GLCM Variance", defaultValue="true", label="GLCM Variance")
    private Boolean outputVariance = true;
    @Parameter(description="Output GLCM Correlation", defaultValue="true", label="GLCM Correlation")
    private Boolean outputCorrelation = true;
    private FilterWindow window;
    private int numQuantLevels = 0;
    private int displacementX = 0;
    private int displacementY = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean useProbabilisticQuantizer = false;
    private boolean quantizerAvailable = false;
    private boolean computeGLCPWithAllAngles = false;
    private Quantizer quantizer;
    private String[] targetBandNames;
    private static final String ANGLE_0 = "0";
    private static final String ANGLE_45 = "45";
    private static final String ANGLE_90 = "90";
    private static final String ANGLE_135 = "135";
    private static final String ANGLE_ALL = "ALL";
    private static final String EQUAL_DISTANCE_QUANTIZER = "Equal Distance Quantizer";
    private static final String PROBABILISTIC_QUANTIZER = "Probabilistic Quantizer";
    private static final String QUANTIZATION_LEVELS_8 = "8";
    private static final String QUANTIZATION_LEVELS_16 = "16";
    private static final String QUANTIZATION_LEVELS_32 = "32";
    private static final String QUANTIZATION_LEVELS_64 = "64";
    private static final String QUANTIZATION_LEVELS_96 = "96";
    private static final String QUANTIZATION_LEVELS_128 = "128";
    private static final String PRODUCT_SUFFIX = "_GLCM";

    public void initialize() throws OperatorException {
        try {
            if (!(this.outputContrast.booleanValue() || this.outputDissimilarity.booleanValue() || this.outputHomogeneity.booleanValue() || this.outputASM.booleanValue() || this.outputEnergy.booleanValue() || this.outputMAX.booleanValue() || this.outputEntropy.booleanValue() || this.outputMean.booleanValue() || this.outputVariance.booleanValue() || this.outputCorrelation.booleanValue())) {
                throw new OperatorException("Please select output features.");
            }
            this.window = new FilterWindow(this.windowSizeStr);
            if (this.displacement >= this.window.getWindowSize()) {
                throw new OperatorException("Displacement should not be larger than window size.");
            }
            this.setQuantizer();
            this.setQuantizationLevels();
            this.setXYDisplacements();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setQuantizer() {
        this.useProbabilisticQuantizer = this.quantizerStr.equals(PROBABILISTIC_QUANTIZER);
    }

    private void setQuantizationLevels() {
        switch (this.quantizationLevelsStr) {
            case "8": {
                this.numQuantLevels = 8;
                break;
            }
            case "16": {
                this.numQuantLevels = 16;
                break;
            }
            case "32": {
                this.numQuantLevels = 32;
                break;
            }
            case "64": {
                this.numQuantLevels = 64;
                break;
            }
            case "96": {
                this.numQuantLevels = 96;
                break;
            }
            case "128": {
                this.numQuantLevels = 128;
                break;
            }
            default: {
                throw new OperatorException("Unknown number of quantization levels: " + this.quantizationLevelsStr);
            }
        }
    }

    private void setXYDisplacements() {
        switch (this.angleStr) {
            case "0": {
                this.displacementX = this.displacement;
                this.displacementY = 0;
                break;
            }
            case "45": {
                this.displacementX = -this.displacement;
                this.displacementY = this.displacement;
                break;
            }
            case "90": {
                this.displacementX = 0;
                this.displacementY = this.displacement;
                break;
            }
            case "135": {
                this.displacementX = this.displacement;
                this.displacementY = this.displacement;
                break;
            }
            case "ALL": {
                this.computeGLCPWithAllAngles = true;
                break;
            }
            default: {
                throw new OperatorException("Unknown angle: " + this.angleStr);
            }
        }
    }

    private void createTargetProduct() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void getSourceBands() {
        ArrayList<String> srcBandNameList = new ArrayList<String>();
        if (this.sourceBands != null) {
            int cnt = 0;
            for (String string : this.sourceProduct.getBandNames()) {
                if (!StringUtils.contains((String[])this.sourceBands, (String)string)) continue;
                ++cnt;
            }
            if (cnt != this.sourceProduct.getNumBands()) {
                for (String string : this.sourceBands) {
                    Band srcBand = this.sourceProduct.getBand(string);
                    if (srcBand == null) continue;
                    srcBandNameList.add(srcBand.getName());
                }
            }
        }
        if (srcBandNameList.isEmpty()) {
            Band[] srcBands = this.sourceProduct.getBands();
            for (String string : srcBands) {
                String bandUnit = string.getUnit();
                if (bandUnit == null || !bandUnit.contains("intensity") && !bandUnit.contains("amplitude")) continue;
                srcBandNameList.add(string.getName());
            }
            if (srcBandNameList.isEmpty()) {
                srcBandNameList.add(this.sourceProduct.getBandAt(0).getName());
            }
        }
        this.sourceBands = srcBandNameList.toArray(new String[srcBandNameList.size()]);
    }

    private void addSelectedBands() throws OperatorException {
        Band[] bands;
        this.getSourceBands();
        this.targetBandNames = this.getTargetBandNames();
        for (Band band : bands = OperatorUtils.addBands((Product)this.targetProduct, (String[])this.targetBandNames, (String)"")) {
            band.setNoDataValueUsed(true);
        }
    }

    private String[] getTargetBandNames() {
        ArrayList<String> trgBandNames = new ArrayList<String>();
        for (String srcBandName : this.sourceBands) {
            if (this.outputContrast.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Contrast.toString());
            }
            if (this.outputDissimilarity.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Dissimilarity.toString());
            }
            if (this.outputHomogeneity.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Homogeneity.toString());
            }
            if (this.outputASM.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.ASM.toString());
            }
            if (this.outputEnergy.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Energy.toString());
            }
            if (this.outputMAX.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.MAX.toString());
            }
            if (this.outputEntropy.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Entropy.toString());
            }
            if (this.outputMean.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMMean.toString());
            }
            if (this.outputVariance.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMVariance.toString());
            }
            if (!this.outputCorrelation.booleanValue()) continue;
            trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMCorrelation.toString());
        }
        return trgBandNames.toArray(new String[trgBandNames.size()]);
    }

    private synchronized void createQuantizer() {
        if (this.quantizerAvailable) {
            return;
        }
        Band srcBand = this.sourceProduct.getBand(this.sourceBands[0]);
        this.quantizer = this.useProbabilisticQuantizer ? new ProbabilityQuantizer(srcBand, this.numQuantLevels) : new EqualDistanceQuantizer(srcBand, this.numQuantLevels);
        this.quantizerAvailable = true;
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        if (!this.quantizerAvailable) {
            this.createQuantizer();
        }
        int tx0 = targetRectangle.x;
        int ty0 = targetRectangle.y;
        int tw = targetRectangle.width;
        int th = targetRectangle.height;
        int maxY = ty0 + th;
        int maxX = tx0 + tw;
        try {
            TileIndex trgIndex = new TileIndex(targetTiles.get(targetTiles.keySet().iterator().next()));
            Rectangle sourceTileRectangle = this.window.getSourceTileRectangle(tx0, ty0, tw, th, this.sourceImageWidth, this.sourceImageHeight);
            SrcInfo[] srcInfoList = new SrcInfo[this.sourceBands.length];
            int cnt = 0;
            for (String srcBandName : this.sourceBands) {
                Band sourceBand = this.sourceProduct.getBand(srcBandName);
                srcInfoList[cnt] = new SrcInfo(this.numQuantLevels, sourceBand, this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle));
                ArrayList<TileData> tileDataList = new ArrayList<TileData>();
                for (String targetBandName : this.targetBandNames) {
                    if (!targetBandName.startsWith(srcBandName)) continue;
                    Band targetBand = this.targetProduct.getBand(targetBandName);
                    SrcInfo[] targetTile = targetTiles.get(targetBand);
                    tileDataList.add(new TileData((Tile)targetTile, targetBand.getName()));
                }
                srcInfoList[cnt].tileDataList = tileDataList.toArray(new TileData[tileDataList.size()]);
                ++cnt;
            }
            int halfWindowSize = this.window.getHalfWindowSize();
            TileIndex srcIndex = new TileIndex(srcInfoList[0].sourceTile);
            for (int ty = ty0; ty < maxY && !pm.isCanceled(); ++ty) {
                trgIndex.calculateStride(ty);
                int y0 = Math.max(ty - halfWindowSize, 0);
                int h = Math.min(ty + halfWindowSize, this.sourceImageHeight - 1) - y0 + 1;
                int yMax = y0 + h;
                for (int tx = tx0; tx < maxX; ++tx) {
                    int idx = trgIndex.getIndex(tx);
                    int x0 = Math.max(tx - halfWindowSize, 0);
                    int w = Math.min(tx + halfWindowSize, this.sourceImageWidth - 1) - x0 + 1;
                    int xMax = x0 + w;
                    if (tx == tx0 || x0 == 0 || xMax == this.sourceImageWidth) {
                        for (SrcInfo srcInfo : srcInfoList) {
                            srcInfo.reset(w, h);
                        }
                        GLCMOp.computeQuantizedImages(this.quantizer, srcIndex, x0, y0, xMax, yMax, srcInfoList);
                        this.computeGLCM(srcInfoList);
                    } else {
                        int xNew = Math.min(tx + halfWindowSize, this.sourceImageWidth - 1);
                        this.updateGLCMWithFirstColumnOfQuantizedImageRemoved(srcInfoList);
                        GLCMOp.updateQuantizedImages(this.quantizer, srcIndex, xNew, y0, yMax, srcInfoList);
                        this.updateGLCMWithLastColumnOfQuantizedImageAdded(srcInfoList);
                    }
                    for (SrcInfo srcInfo : srcInfoList) {
                        if (srcInfo.totals.totalCount == 0) {
                            this.writeData(srcInfo, srcInfo.tfNoData, idx);
                            continue;
                        }
                        this.writeData(srcInfo, this.computeTextureFeatures(srcInfo.GLCM, srcInfo.totals), idx);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void writeData(SrcInfo srcInfo, TextureFeatures tf, int idx) {
        for (TileData tileData : srcInfo.tileDataList) {
            if (tileData.doContrast) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Contrast);
                continue;
            }
            if (tileData.doDissimilarity) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Dissimilarity);
                continue;
            }
            if (tileData.doHomogeneity) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Homogeneity);
                continue;
            }
            if (tileData.doASM) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.ASM);
                continue;
            }
            if (tileData.doEnergy) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Energy);
                continue;
            }
            if (tileData.doMax) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.MAX);
                continue;
            }
            if (tileData.doEntropy) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Entropy);
                continue;
            }
            if (tileData.doMean) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMMean);
                continue;
            }
            if (tileData.doVariance) {
                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMVariance);
                continue;
            }
            if (!tileData.doCorrelation) continue;
            tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMCorrelation);
        }
    }

    private void computeGLCM(SrcInfo[] srcInfoList) {
        switch (this.angleStr) {
            case "0": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add0DegreeElements(0, h, 0, w, srcInfo);
                }
                break;
            }
            case "45": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add45DegreeElements(0, h, 0, w, srcInfo);
                }
                break;
            }
            case "90": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add90DegreeElements(0, h, 0, w, srcInfo);
                }
                break;
            }
            case "135": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add135DegreeElements(0, h, 0, w, srcInfo);
                }
                break;
            }
            case "ALL": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add0DegreeElements(0, h, 0, w, srcInfo);
                    this.add45DegreeElements(0, h, 0, w, srcInfo);
                    this.add90DegreeElements(0, h, 0, w, srcInfo);
                    this.add135DegreeElements(0, h, 0, w, srcInfo);
                }
                break;
            }
            default: {
                throw new OperatorException("Unknown angle: " + this.angleStr);
            }
        }
    }

    private void updateGLCMWithFirstColumnOfQuantizedImageRemoved(SrcInfo[] srcInfoList) {
        switch (this.angleStr) {
            case "0": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    this.remove0DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                }
                break;
            }
            case "45": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    this.remove45DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                }
                break;
            }
            case "90": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    this.remove90DegreeElements(0, h, 0, 1, srcInfo);
                }
                break;
            }
            case "135": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    this.remove135DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                }
                break;
            }
            case "ALL": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    this.remove0DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                    this.remove45DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                    this.remove90DegreeElements(0, h, 0, 1, srcInfo);
                    this.remove135DegreeElements(0, h, 0, 1 + this.displacement, srcInfo);
                }
                break;
            }
            default: {
                throw new OperatorException("Unknown angle: " + this.angleStr);
            }
        }
    }

    private void updateGLCMWithLastColumnOfQuantizedImageAdded(SrcInfo[] srcInfoList) {
        switch (this.angleStr) {
            case "0": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add0DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                }
                break;
            }
            case "45": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add45DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                }
                break;
            }
            case "90": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add90DegreeElements(0, h, w - 1, w, srcInfo);
                }
                break;
            }
            case "135": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add135DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                }
                break;
            }
            case "ALL": {
                for (SrcInfo srcInfo : srcInfoList) {
                    int h = srcInfo.quantizedImage.length;
                    int w = srcInfo.quantizedImage[0].length;
                    this.add0DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                    this.add45DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                    this.add90DegreeElements(0, h, w - 1, w, srcInfo);
                    this.add135DegreeElements(0, h, w - 1 - this.displacement, w, srcInfo);
                }
                break;
            }
            default: {
                throw new OperatorException("Unknown angle: " + this.angleStr);
            }
        }
    }

    private void add0DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax; ++r) {
            for (int c = c0; c < cMax - this.displacement; ++c) {
                this.addElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r][c + this.displacement]);
            }
        }
    }

    private void add45DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0 + this.displacement; c < cMax; ++c) {
                this.addElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c - this.displacement]);
            }
        }
    }

    private void add90DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0; c < cMax; ++c) {
                this.addElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c]);
            }
        }
    }

    private void add135DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0; c < cMax - this.displacement; ++c) {
                this.addElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c + this.displacement]);
            }
        }
    }

    private void addElements(SrcInfo srcInfo, int i, int j) {
        if (i < 0 || j < 0) {
            return;
        }
        GLCMElem elem = srcInfo.GLCM[i * this.numQuantLevels + j];
        if (!elem.init) {
            elem.setPos(i, j);
            ++srcInfo.totals.numElems;
        }
        ++elem.value;
        elem = srcInfo.GLCM[j * this.numQuantLevels + i];
        if (!elem.init) {
            elem.setPos(j, i);
            ++srcInfo.totals.numElems;
        }
        ++elem.value;
        ++srcInfo.totals.totalCount;
    }

    private void remove0DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax; ++r) {
            for (int c = c0; c < cMax - this.displacement; ++c) {
                this.removeElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r][c + this.displacement]);
            }
        }
    }

    private void remove45DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0 + this.displacement; c < cMax; ++c) {
                this.removeElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c - this.displacement]);
            }
        }
    }

    private void remove90DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0; c < cMax; ++c) {
                this.removeElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c]);
            }
        }
    }

    private void remove135DegreeElements(int r0, int rMax, int c0, int cMax, SrcInfo srcInfo) {
        for (int r = r0; r < rMax - this.displacement; ++r) {
            for (int c = c0; c < cMax - this.displacement; ++c) {
                this.removeElements(srcInfo, srcInfo.quantizedImage[r][c], srcInfo.quantizedImage[r + this.displacement][c + this.displacement]);
            }
        }
    }

    private void removeElements(SrcInfo srcInfo, int i, int j) {
        if (i < 0 || j < 0) {
            return;
        }
        GLCMElem elem = srcInfo.GLCM[i * this.numQuantLevels + j];
        --elem.value;
        if (elem.value == 0) {
            elem.init = false;
            --srcInfo.totals.numElems;
        }
        elem = srcInfo.GLCM[j * this.numQuantLevels + i];
        --elem.value;
        if (elem.value == 0) {
            elem.init = false;
            --srcInfo.totals.numElems;
        }
        --srcInfo.totals.totalCount;
    }

    private static void computeQuantizedImages(Quantizer quantizer, TileIndex srcIndex, int x0, int y0, int xMax, int yMax, SrcInfo[] srcInfoList) {
        for (int y = y0; y < yMax; ++y) {
            int yy = y - y0;
            srcIndex.calculateStride(y);
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                int index = srcIndex.getIndex(x);
                for (SrcInfo srcInfo : srcInfoList) {
                    double v = srcInfo.srcData.getElemDoubleAt(index) * srcInfo.scalingFactor + srcInfo.scalingOffset;
                    srcInfo.quantizedImage[yy][xx] = Double.isNaN(v) || v == (double)srcInfo.noDataValue ? -1 : quantizer.compute(v);
                }
            }
        }
    }

    private static void updateQuantizedImages(Quantizer quantizer, TileIndex srcIndex, int xNew, int y0, int yMax, SrcInfo[] srcInfoList) {
        for (SrcInfo srcInfo : srcInfoList) {
            int h = srcInfo.quantizedImage.length;
            int w = srcInfo.quantizedImage[0].length;
            for (int i = 0; i < w - 1; ++i) {
                for (int j = 0; j < h; ++j) {
                    srcInfo.quantizedImage[j][i] = srcInfo.quantizedImage[j][i + 1];
                }
            }
            for (int y = y0; y < yMax; ++y) {
                int yy = y - y0;
                srcIndex.calculateStride(y);
                double v = srcInfo.srcData.getElemDoubleAt(srcIndex.getIndex(xNew)) * srcInfo.scalingFactor + srcInfo.scalingOffset;
                srcInfo.quantizedImage[yy][w - 1] = Double.isNaN(v) || v == (double)srcInfo.noDataValue ? -1 : quantizer.compute(v);
            }
        }
    }

    private TextureFeatures computeTextureFeatures(GLCMElem[] GLCM, Totals totals) {
        double Contrast = 0.0;
        double Dissimilarity = 0.0;
        double Homogeneity = 0.0;
        double ASM = 0.0;
        double Energy = 0.0;
        double MAX = 0.0;
        double Entropy = 0.0;
        double GLCMMeanX = 0.0;
        double GLCMMeanY = 0.0;
        double GLCMMean = 0.0;
        double GLCMVariance = 0.0;
        boolean doContrast = this.outputContrast;
        boolean doDissimilarity = this.outputDissimilarity;
        boolean doHomogeneity = this.outputHomogeneity;
        boolean doASM = this.outputASM != false || this.outputEnergy != false;
        boolean doEntropy = this.outputEntropy;
        boolean doVariance = this.outputVariance;
        boolean doCorrelation = this.outputCorrelation;
        GLCMElem[] glcmList2 = null;
        if (doVariance || doCorrelation) {
            glcmList2 = new GLCMElem[totals.numElems];
        }
        int cnt = 0;
        for (GLCMElem e : GLCM) {
            if (!e.init || !((double)e.value > 0.0)) continue;
            int ij = e.row - e.col;
            double GLCMval = e.prob = (double)e.value / (double)totals.totalCount;
            if (doContrast) {
                Contrast += GLCMval * (double)ij * (double)ij;
            }
            if (doDissimilarity) {
                Dissimilarity += GLCMval * (double)Math.abs(ij);
            }
            if (doHomogeneity) {
                Homogeneity += GLCMval / (double)(1 + ij * ij);
            }
            if (doASM) {
                ASM += GLCMval * GLCMval;
            }
            if (MAX < GLCMval) {
                MAX = GLCMval;
            }
            if (doEntropy) {
                Entropy += -GLCMval * Math.log(GLCMval + 1.0E-15);
            }
            GLCMMeanY += GLCMval * (double)e.row;
            GLCMMeanX += GLCMval * (double)e.col;
            if (!doVariance && !doCorrelation) continue;
            glcmList2[cnt++] = e;
        }
        if (doASM) {
            Energy = Math.sqrt(ASM);
        }
        if (this.outputMean.booleanValue()) {
            GLCMMean = (GLCMMeanX + GLCMMeanY) / 2.0;
        }
        double GLCMVarianceX = 0.0;
        double GLCMVarianceY = 0.0;
        double GLCMCorrelation = 0.0;
        if (doVariance || doCorrelation) {
            for (GLCMElem e : glcmList2) {
                e.diff_col_GLCMMeanX = (double)e.col - GLCMMeanX;
                e.diff_row_GLCMMeanY = (double)e.row - GLCMMeanY;
                GLCMVarianceX += e.prob * e.diff_col_GLCMMeanX * e.diff_col_GLCMMeanX;
                GLCMVarianceY += e.prob * e.diff_row_GLCMMeanY * e.diff_row_GLCMMeanY;
            }
            if (doVariance) {
                GLCMVariance = (GLCMVarianceX + GLCMVarianceY) / 2.0;
            }
            if (doCorrelation) {
                double sqrtOfGLCMVariance = Math.sqrt(GLCMVarianceX * GLCMVarianceY);
                for (GLCMElem e : glcmList2) {
                    GLCMCorrelation += e.prob * e.diff_row_GLCMMeanY * e.diff_col_GLCMMeanX / sqrtOfGLCMVariance;
                }
            }
        }
        return new TextureFeatures(Contrast, Dissimilarity, Homogeneity, ASM, Energy, MAX, Entropy, GLCMMean, GLCMVariance, GLCMCorrelation);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GLCMOp.class);
        }
    }

    private static final class GLCMElem {
        public int row;
        public int col;
        public boolean init;
        public int value;
        public double prob;
        public double diff_col_GLCMMeanX;
        public double diff_row_GLCMMeanY;

        private GLCMElem() {
        }

        void setPos(int row, int col) {
            this.row = row;
            this.col = col;
            this.value = 0;
            this.init = true;
        }
    }

    private static final class Totals {
        public int numElems = 0;
        public int totalCount = 0;

        private Totals() {
        }
    }

    private static final class TextureFeatures {
        public final double Contrast;
        public final double Dissimilarity;
        public final double Homogeneity;
        public final double ASM;
        public final double Energy;
        public final double MAX;
        public final double Entropy;
        public final double GLCMMean;
        public final double GLCMVariance;
        public final double GLCMCorrelation;

        TextureFeatures(double Contrast, double Dissimilarity, double Homogeneity, double ASM, double Energy, double MAX, double Entropy, double GLCMMean, double GLCMVariance, double GLCMCorrelation) {
            this.Contrast = Contrast;
            this.Dissimilarity = Dissimilarity;
            this.Homogeneity = Homogeneity;
            this.ASM = ASM;
            this.Energy = Energy;
            this.MAX = MAX;
            this.Entropy = Entropy;
            this.GLCMMean = GLCMMean;
            this.GLCMVariance = GLCMVariance;
            this.GLCMCorrelation = GLCMCorrelation;
        }
    }

    private final class TileData {
        final ProductData dataBuffer;
        final boolean doContrast;
        final boolean doDissimilarity;
        final boolean doHomogeneity;
        final boolean doASM;
        final boolean doEnergy;
        final boolean doMax;
        final boolean doEntropy;
        final boolean doMean;
        final boolean doVariance;
        final boolean doCorrelation;

        public TileData(Tile tile, String bandName) {
            this.dataBuffer = tile.getDataBuffer();
            this.doContrast = GLCMOp.this.outputContrast != false && bandName.endsWith(GLCM_TYPES.Contrast.toString());
            this.doDissimilarity = GLCMOp.this.outputDissimilarity != false && bandName.endsWith(GLCM_TYPES.Dissimilarity.toString());
            this.doHomogeneity = GLCMOp.this.outputHomogeneity != false && bandName.endsWith(GLCM_TYPES.Homogeneity.toString());
            this.doASM = GLCMOp.this.outputASM != false && bandName.endsWith(GLCM_TYPES.ASM.toString());
            this.doEnergy = GLCMOp.this.outputEnergy != false && bandName.endsWith(GLCM_TYPES.Energy.toString());
            this.doMax = GLCMOp.this.outputMAX != false && bandName.endsWith(GLCM_TYPES.MAX.toString());
            this.doEntropy = GLCMOp.this.outputEntropy != false && bandName.endsWith(GLCM_TYPES.Entropy.toString());
            this.doMean = GLCMOp.this.outputMean != false && bandName.endsWith(GLCM_TYPES.GLCMMean.toString());
            this.doVariance = GLCMOp.this.outputVariance != false && bandName.endsWith(GLCM_TYPES.GLCMVariance.toString());
            this.doCorrelation = GLCMOp.this.outputCorrelation != false && bandName.endsWith(GLCM_TYPES.GLCMCorrelation.toString());
        }
    }

    private static final class SrcInfo {
        public final Tile sourceTile;
        public final TileIndex srcIndex;
        public final ProductData srcData;
        public final float noDataValue;
        public final double scalingFactor;
        public final double scalingOffset;
        public final TextureFeatures tfNoData;
        public TileData[] tileDataList;
        public int[][] quantizedImage;
        public Totals totals;
        public GLCMElem[] GLCM;
        private final int numQuantLevels;

        public SrcInfo(int numQuantLevels, Band srcBand, Tile srcTile) {
            this.numQuantLevels = numQuantLevels;
            this.sourceTile = srcTile;
            this.srcIndex = new TileIndex(this.sourceTile);
            this.srcData = this.sourceTile.getDataBuffer();
            this.noDataValue = (float)srcBand.getNoDataValue();
            this.scalingFactor = srcBand.getScalingFactor();
            this.scalingOffset = srcBand.getScalingOffset();
            this.tfNoData = new TextureFeatures(this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue, this.noDataValue);
            this.GLCM = new GLCMElem[numQuantLevels * numQuantLevels];
            for (int i = 0; i < this.GLCM.length; ++i) {
                this.GLCM[i] = new GLCMElem();
            }
        }

        public void reset(int w, int h) {
            this.totals = new Totals();
            this.quantizedImage = new int[h][w];
            for (GLCMElem elem : this.GLCM) {
                elem.init = false;
                elem.value = 0;
            }
        }
    }

    private static final class EqualDistanceQuantizer
    implements Quantizer {
        private final double bandMin;
        private final double delta;
        private final int max;

        public EqualDistanceQuantizer(Band srcBand, int numQuantLevels) {
            Stx stx = srcBand.getStx(true, ProgressMonitor.NULL);
            this.bandMin = stx.getMinimum();
            this.delta = (stx.getMaximum() - this.bandMin) / (double)numQuantLevels;
            this.max = numQuantLevels - 1;
        }

        @Override
        public int compute(double v) {
            return Math.min((int)((v - this.bandMin) / this.delta), this.max);
        }
    }

    private static final class ProbabilityQuantizer
    implements Quantizer {
        private final double[] newBinLowValues;
        private final int numQuantLevels;
        private final double minBin;
        private final double maxBin;

        public ProbabilityQuantizer(Band srcBand, int numQuantLevels) {
            this.numQuantLevels = numQuantLevels;
            Histogram hist = srcBand.getStx().getHistogram();
            int numBins = hist.getNumBins(0);
            int[] bins = hist.getBins(0);
            int totalNumPixels = 0;
            for (int i = 0; i < numBins; ++i) {
                totalNumPixels += bins[i];
            }
            int newBinSize = totalNumPixels / numQuantLevels;
            this.newBinLowValues = new double[numQuantLevels + 1];
            this.newBinLowValues[0] = hist.getBinLowValue(0, 0);
            int k = 1;
            int sum = 0;
            for (int i = 0; i < numBins; ++i) {
                if ((sum += bins[i]) < k * newBinSize) continue;
                this.newBinLowValues[k] = hist.getBinLowValue(0, i);
                if (k < numQuantLevels - 1) {
                    ++k;
                    continue;
                }
                this.newBinLowValues[numQuantLevels] = hist.getHighValue(0);
                break;
            }
            this.minBin = this.newBinLowValues[0];
            this.maxBin = this.newBinLowValues[numQuantLevels];
        }

        @Override
        public int compute(double v) {
            double midValue;
            if (v < this.minBin) {
                return 0;
            }
            if (v >= this.maxBin) {
                return this.numQuantLevels - 1;
            }
            int low = 0;
            int high = this.numQuantLevels;
            int mid = -1;
            while (!(low >= high || v >= (midValue = this.newBinLowValues[mid = (low + high) / 2]) && v < this.newBinLowValues[mid + 1])) {
                if (v < midValue) {
                    high = mid;
                    continue;
                }
                low = mid;
            }
            return mid;
        }
    }

    private static interface Quantizer {
        public int compute(double var1);
    }

    static enum GLCM_TYPES {
        Contrast,
        Dissimilarity,
        Homogeneity,
        ASM,
        Energy,
        MAX,
        Entropy,
        GLCMMean,
        GLCMVariance,
        GLCMCorrelation,
        Unknown;

    }
}

