/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFDirectory
implements Cloneable {
    private static final int MAX_LOW_FIELD_TAG_NUM = 532;
    private List tagSets;
    private TIFFTag parentTag;
    private TIFFField[] lowFields = new TIFFField[533];
    private int numLowFields = 0;
    private Map highFields = new TreeMap();

    public static TIFFDirectory createFromMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        TIFFImageMetadata tIFFImageMetadata;
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("tiffImageMetadata == null");
        }
        if (iIOMetadata instanceof TIFFImageMetadata) {
            tIFFImageMetadata = (TIFFImageMetadata)iIOMetadata;
        } else {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            String string = null;
            if ("com_sun_media_imageio_plugins_tiff_image_1.0".equals(iIOMetadata.getNativeMetadataFormatName())) {
                string = "com_sun_media_imageio_plugins_tiff_image_1.0";
            } else {
                String[] stringArray = iIOMetadata.getExtraMetadataFormatNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!"com_sun_media_imageio_plugins_tiff_image_1.0".equals(stringArray[i])) continue;
                        string = stringArray[i];
                        break;
                    }
                }
                if (string == null) {
                    if (iIOMetadata.isStandardMetadataFormatSupported()) {
                        string = "javax_imageio_1.0";
                    } else {
                        throw new IllegalArgumentException("Parameter does not support required metadata format!");
                    }
                }
            }
            tIFFImageMetadata.setFromTree(string, iIOMetadata.getAsTree(string));
        }
        return tIFFImageMetadata.getRootIFD();
    }

    private static TIFFIFD getDirectoryAsIFD(TIFFDirectory tIFFDirectory) {
        if (tIFFDirectory instanceof TIFFIFD) {
            return (TIFFIFD)tIFFDirectory;
        }
        TIFFIFD tIFFIFD = new TIFFIFD(Arrays.asList(tIFFDirectory.getTagSets()), tIFFDirectory.getParentTag());
        TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
        int n = tIFFFieldArray.length;
        for (int i = 0; i < n; ++i) {
            TIFFField tIFFField = tIFFFieldArray[i];
            TIFFTag tIFFTag = tIFFField.getTag();
            if (tIFFTag.isIFDPointer()) {
                TIFFIFD tIFFIFD2 = TIFFDirectory.getDirectoryAsIFD((TIFFDirectory)tIFFField.getData());
                tIFFField = new TIFFField(tIFFTag, tIFFField.getType(), tIFFField.getCount(), tIFFIFD2);
            }
            tIFFIFD.addTIFFField(tIFFField);
        }
        return tIFFIFD;
    }

    public TIFFDirectory(TIFFTagSet[] tIFFTagSetArray, TIFFTag tIFFTag) {
        if (tIFFTagSetArray == null) {
            throw new IllegalArgumentException("tagSets == null!");
        }
        this.tagSets = new ArrayList(tIFFTagSetArray.length);
        int n = tIFFTagSetArray.length;
        for (int i = 0; i < n; ++i) {
            this.tagSets.add(tIFFTagSetArray[i]);
        }
        this.parentTag = tIFFTag;
    }

    public TIFFTagSet[] getTagSets() {
        return this.tagSets.toArray(new TIFFTagSet[this.tagSets.size()]);
    }

    public void addTagSet(TIFFTagSet tIFFTagSet) {
        if (tIFFTagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (!this.tagSets.contains(tIFFTagSet)) {
            this.tagSets.add(tIFFTagSet);
        }
    }

    public void removeTagSet(TIFFTagSet tIFFTagSet) {
        if (tIFFTagSet == null) {
            throw new IllegalArgumentException("tagSet == null");
        }
        if (this.tagSets.contains(tIFFTagSet)) {
            this.tagSets.remove(tIFFTagSet);
        }
    }

    public TIFFTag getParentTag() {
        return this.parentTag;
    }

    public TIFFTag getTag(int n) {
        return TIFFIFD.getTag(n, this.tagSets);
    }

    public int getNumTIFFFields() {
        return this.numLowFields + this.highFields.size();
    }

    public boolean containsTIFFField(int n) {
        return n >= 0 && n <= 532 && this.lowFields[n] != null || this.highFields.containsKey(new Integer(n));
    }

    public void addTIFFField(TIFFField tIFFField) {
        if (tIFFField == null) {
            throw new IllegalArgumentException("f == null");
        }
        int n = tIFFField.getTagNumber();
        if (n >= 0 && n <= 532) {
            if (this.lowFields[n] == null) {
                ++this.numLowFields;
            }
            this.lowFields[n] = tIFFField;
        } else {
            this.highFields.put(new Integer(n), tIFFField);
        }
    }

    public TIFFField getTIFFField(int n) {
        TIFFField tIFFField = n >= 0 && n <= 532 ? this.lowFields[n] : (TIFFField)this.highFields.get(new Integer(n));
        return tIFFField;
    }

    public void removeTIFFField(int n) {
        if (n >= 0 && n <= 532) {
            if (this.lowFields[n] != null) {
                --this.numLowFields;
                this.lowFields[n] = null;
            }
        } else {
            this.highFields.remove(new Integer(n));
        }
    }

    public TIFFField[] getTIFFFields() {
        TIFFField[] tIFFFieldArray = new TIFFField[this.numLowFields + this.highFields.size()];
        int n = 0;
        for (int i = 0; i <= 532; ++i) {
            if (this.lowFields[i] == null) continue;
            tIFFFieldArray[n++] = this.lowFields[i];
            if (n == this.numLowFields) break;
        }
        if (!this.highFields.isEmpty()) {
            Iterator iterator = this.highFields.keySet().iterator();
            while (iterator.hasNext()) {
                tIFFFieldArray[n++] = (TIFFField)this.highFields.get(iterator.next());
            }
        }
        return tIFFFieldArray;
    }

    public void removeTIFFFields() {
        Arrays.fill(this.lowFields, null);
        this.numLowFields = 0;
        this.highFields.clear();
    }

    public IIOMetadata getAsMetadata() {
        return new TIFFImageMetadata(TIFFDirectory.getDirectoryAsIFD(this));
    }

    public Object clone() {
        TIFFDirectory tIFFDirectory = new TIFFDirectory(this.getTagSets(), this.getParentTag());
        TIFFField[] tIFFFieldArray = this.getTIFFFields();
        int n = tIFFFieldArray.length;
        for (int i = 0; i < n; ++i) {
            tIFFDirectory.addTIFFField(tIFFFieldArray[i]);
        }
        return tIFFDirectory;
    }
}

