/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.Set;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ServiceLoader;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;

public class LandCoverModelRegistry {
    private final ServiceRegistry<LandCoverModelDescriptor> descriptors = ServiceRegistryManager.getInstance().getServiceRegistry(LandCoverModelDescriptor.class);

    private LandCoverModelRegistry() {
        ServiceLoader.loadServices(this.descriptors);
    }

    public static LandCoverModelRegistry getInstance() {
        return Holder.instance;
    }

    public void addDescriptor(LandCoverModelDescriptor modelDescriptor) {
        this.descriptors.addService((Object)modelDescriptor);
    }

    public void removeDescriptor(LandCoverModelDescriptor modelDescriptor) {
        this.descriptors.removeService((Object)modelDescriptor);
    }

    public LandCoverModelDescriptor getDescriptor(String name) {
        Guardian.assertNotNullOrEmpty((String)"name", (String)name);
        Set services = this.descriptors.getServices();
        for (LandCoverModelDescriptor descriptor : services) {
            if (!name.equalsIgnoreCase(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public LandCoverModelDescriptor[] getAllDescriptors() {
        return this.descriptors.getServices().toArray(new LandCoverModelDescriptor[this.descriptors.getServices().size()]);
    }

    private static class Holder {
        private static final LandCoverModelRegistry instance = new LandCoverModelRegistry();

        private Holder() {
        }
    }
}

