/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.landcover.dataio.LandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverTile;

public class BaseLandCoverTile
implements LandCoverTile {
    protected Product product;
    private final Band band;
    private final int bandWidth;
    protected final double noDataValue;
    private final float[][] objectArray;

    public BaseLandCoverTile(LandCoverModel dem, Product product) {
        this.product = product;
        this.band = product.getBandAt(0);
        this.bandWidth = this.band.getRasterWidth();
        this.noDataValue = dem.getDescriptor().getNoDataValue();
        this.objectArray = new float[this.band.getRasterHeight() + 1][];
    }

    @Override
    public final void clearCache() {
        if (this.objectArray != null) {
            Arrays.fill((Object[])this.objectArray, 0, this.objectArray.length, null);
        }
    }

    public File getFile() {
        return this.product.getFileLocation();
    }

    @Override
    public final float getSample(int pixelX, int pixelY) throws Exception {
        float[] line = this.objectArray[pixelY];
        if (line == null) {
            line = this.band.readPixels(0, pixelY, this.bandWidth, 1, new float[this.bandWidth], ProgressMonitor.NULL);
            this.objectArray[pixelY] = line;
        }
        return line[pixelX];
    }

    @Override
    public void dispose() {
        this.clearCache();
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }
}

