/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.engine_utilities.download.downloadablecontent.DownloadableContent;
import org.esa.snap.landcover.dataio.LandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverTile;

public abstract class AbstractLandCoverModel
implements LandCoverModel,
Resampling.Raster {
    private final int NUM_X_TILES;
    protected final int NUM_Y_TILES;
    protected final int NUM_PIXELS_PER_TILE;
    private final double NUM_PIXELS_PER_TILEinv;
    private final double NO_DATA_VALUE;
    protected final int DEGREE_RES;
    private final int RASTER_WIDTH;
    protected final int RASTER_HEIGHT;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    protected final LandCoverModelDescriptor descriptor;
    private final DownloadableContent[][] elevationFiles;
    private final Resampling resampling;
    private final Resampling.Raster resamplingRaster;
    private final List<LandCoverTile> elevationTileCache = new ArrayList<LandCoverTile>(20);
    private int maxCacheSize = 60;

    public AbstractLandCoverModel(LandCoverModelDescriptor descriptor, Resampling resamplingMethod) {
        this.descriptor = descriptor;
        if (resamplingMethod == null) {
            resamplingMethod = Resampling.NEAREST_NEIGHBOUR;
        }
        this.resampling = resamplingMethod;
        this.resamplingRaster = this;
        this.NUM_X_TILES = descriptor.getNumXTiles();
        this.NUM_Y_TILES = descriptor.getNumYTiles();
        this.NO_DATA_VALUE = descriptor.getNoDataValue();
        this.NUM_PIXELS_PER_TILE = descriptor.getPixelRes();
        this.NUM_PIXELS_PER_TILEinv = 1.0 / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES = descriptor.getDegreeRes();
        this.RASTER_WIDTH = this.NUM_X_TILES * this.NUM_PIXELS_PER_TILE;
        this.RASTER_HEIGHT = this.NUM_Y_TILES * this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE = (double)this.DEGREE_RES / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv = 1.0 / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
        this.elevationFiles = this.createLandCoverFiles();
    }

    @Override
    public Resampling getResampling() {
        return this.resampling;
    }

    @Override
    public LandCoverModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setMaxCacheSize(int size) {
        this.maxCacheSize = size;
    }

    @Override
    public final double getLandCover(GeoPos geoPos) throws Exception {
        double pixelY;
        if (geoPos.lon > 180.0) {
            geoPos.lon -= 360.0;
        }
        if ((pixelY = this.getIndexY(geoPos)) < 0.0) {
            return this.NO_DATA_VALUE;
        }
        Resampling.Index newIndex = this.resampling.createIndex();
        this.resampling.computeIndex(this.getIndexX(geoPos), pixelY, this.RASTER_WIDTH, this.RASTER_HEIGHT, newIndex);
        double elevation = this.resampling.resample(this.resamplingRaster, newIndex);
        return Double.isNaN(elevation) ? this.NO_DATA_VALUE : elevation;
    }

    public abstract double getIndexX(GeoPos var1);

    public abstract double getIndexY(GeoPos var1);

    @Override
    public abstract GeoPos getGeoPos(PixelPos var1);

    @Override
    public PixelPos getIndex(GeoPos geoPos) {
        return new PixelPos((double)((float)this.getIndexX(geoPos)), (double)((float)this.getIndexY(geoPos)));
    }

    @Override
    public void dispose() {
        for (LandCoverTile tile : this.elevationTileCache) {
            if (tile == null) continue;
            tile.dispose();
        }
        this.elevationTileCache.clear();
        DownloadableContent[][] downloadableContentArray = this.elevationFiles;
        int n = downloadableContentArray.length;
        for (int i = 0; i < n; ++i) {
            DownloadableContent[] elevationFile;
            for (DownloadableContent anElevationFile : elevationFile = downloadableContentArray[i]) {
                if (anElevationFile == null) continue;
                anElevationFile.dispose();
            }
        }
    }

    public int getWidth() {
        return this.RASTER_WIDTH;
    }

    public int getHeight() {
        return this.RASTER_HEIGHT;
    }

    @Override
    public final float getSample(double pixelX, double pixelY) throws Exception {
        int tileXIndex = (int)(pixelX * this.NUM_PIXELS_PER_TILEinv);
        int tileYIndex = (int)(pixelY * this.NUM_PIXELS_PER_TILEinv);
        LandCoverTile tile = (LandCoverTile)this.elevationFiles[tileXIndex][tileYIndex].getContentFile();
        if (tile == null) {
            return Float.NaN;
        }
        float sample = tile.getSample((int)(pixelX - (double)(tileXIndex * this.NUM_PIXELS_PER_TILE)), (int)(pixelY - (double)(tileYIndex * this.NUM_PIXELS_PER_TILE)));
        return sample == (float)this.NO_DATA_VALUE ? Float.NaN : sample;
    }

    private DownloadableContent[][] createLandCoverFiles() {
        DownloadableContent[][] elevationFiles = new DownloadableContent[this.NUM_X_TILES][this.NUM_Y_TILES];
        File demInstallDir = this.descriptor.getInstallDir();
        for (int x = 0; x < elevationFiles.length; ++x) {
            for (int y = 0; y < elevationFiles[x].length; ++y) {
                this.createLandCoverFile(elevationFiles, x, y, demInstallDir);
            }
        }
        return elevationFiles;
    }

    protected abstract void createLandCoverFile(DownloadableContent[][] var1, int var2, int var3, File var4);

    public void updateCache(LandCoverTile tile) {
        this.elevationTileCache.remove(tile);
        this.elevationTileCache.add(0, tile);
        while (this.elevationTileCache.size() > this.maxCacheSize) {
            int index = this.elevationTileCache.size() - 1;
            LandCoverTile lastTile = this.elevationTileCache.get(index);
            if (lastTile != null) {
                lastTile.clearCache();
            }
            this.elevationTileCache.remove(index);
        }
    }

    protected static ProductReaderPlugIn getReaderPlugIn(String formatName) {
        Iterator readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(formatName);
        return (ProductReaderPlugIn)readerPlugIns.next();
    }

    @Override
    public final boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            int tileYIndex = (int)((double)y[i] * this.NUM_PIXELS_PER_TILEinv);
            int pixelY = y[i] - tileYIndex * this.NUM_PIXELS_PER_TILE;
            for (int j = 0; j < x.length; ++j) {
                int tileXIndex = (int)((double)x[j] * this.NUM_PIXELS_PER_TILEinv);
                DownloadableContent content = this.elevationFiles[tileXIndex][tileYIndex];
                if (content == null) {
                    samples[i][j] = Double.NaN;
                    allValid = false;
                    continue;
                }
                LandCoverTile tile = (LandCoverTile)content.getContentFile();
                if (tile == null) {
                    samples[i][j] = Double.NaN;
                    allValid = false;
                    continue;
                }
                samples[i][j] = tile.getSample(x[j] - tileXIndex * this.NUM_PIXELS_PER_TILE, pixelY);
                if (samples[i][j] != this.NO_DATA_VALUE) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }
}

