/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AAFC.FileLandCoverProvincialModel;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class AESBEOS2016CropModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada 2016 Crop";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC" + File.separator + "AESB_EOS_Crop_2016");
    private static final File[] fileList = new File[]{new File(INSTALL_DIR, "ci_2016_ab_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_bc_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_mb_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_nb_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_nfl_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_ns_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_on_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_pei_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_qc_30m_v1.zip"), new File(INSTALL_DIR, "ci_2016_sk_30m_v1.zip")};

    public AESBEOS2016CropModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/AESB_EOS_Crop_2016/";
        this.name = NAME;
        this.NO_DATA_VALUE = -9999.0;
        this.installDir = INSTALL_DIR;
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/aafc_crop_index.col");
    }

    @Override
    public synchronized boolean installFiles() {
        this.installMetadata();
        if (this.installDir != null) {
            this.isInstalled = true;
        }
        return this.isInstalled;
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverProvincialModel(this, fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return fileList[0].getName();
    }
}

