/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class AESBEOS2010CropModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada 2010 Prairies Crop";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC" + File.separator + "AESB_EOS_Crop_2010");
    private static final File[] fileList = new File[]{new File(INSTALL_DIR, "AAFC_Prairie_Crop_Mapping_2010_v3.zip")};

    public AESBEOS2010CropModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/AESB_EOS_Crop_2010/";
        this.name = NAME;
        this.installDir = INSTALL_DIR;
        this.NO_DATA_VALUE = -9999.0;
        this.metadataFileName = "AAFC_Prairie_Crop_Mapping_2010_v3_Metadata_EN.xml";
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.metadataSrcPath = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/AAFC_Prairie_Crop_Mapping_2010/");
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/aafc_crop_index.col");
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return fileList[0].getName();
    }
}

