/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class ACGEO2016CropSMAPVEXModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada 2016 Crop SMAPVEX";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC");
    private static final File file = new File(INSTALL_DIR, "ACGEO_2016_CI_SMAPVEX_30m_v3.zip");

    public ACGEO2016CropSMAPVEXModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/AESB_EOS_Crop_2016/";
        this.name = NAME;
        this.installDir = INSTALL_DIR;
        this.NO_DATA_VALUE = -9999.0;
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/aafc_crop_index.col");
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, new File[]{file}, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return file.getName();
    }
}

