/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.masks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.FilterWindow;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Terrain-Mask", category="Raster/Masks", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Terrain Mask Generation")
public final class TerrainMaskOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"ACE", "ASTER 1sec GDEM", "GETASSE30", "SRTM 1Sec HGT", "SRTM 3Sec"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BICUBIC_INTERPOLATION", "BISINC_5_POINT_INTERPOLATION"}, defaultValue="NEAREST_NEIGHBOUR", label="DEM Resampling Method")
    private String demResamplingMethod = "NEAREST_NEIGHBOUR";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17"}, defaultValue="15x15", label="Window Size")
    private String windowSizeStr = "15x15";
    @Parameter(description="Threshold for detection", interval="(0, *)", defaultValue="40.0", label="Threshold (m)")
    private double thresholdInMeter = 40.0;
    private ElevationModel dem = null;
    private FilterWindow window;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean isElevationModelAvailable = false;
    private double demNoDataValue = 0.0;
    public static String TERRAIN_MASK_NAME = "Terrain_Mask";

    public void initialize() throws OperatorException {
        try {
            this.window = new FilterWindow(this.windowSizeStr);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        if (this.externalDEMFile != null) {
            this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Double.valueOf(this.externalDEMNoDataValue));
            this.demNoDataValue = this.externalDEMNoDataValue;
            this.demName = this.externalDEMFile.getPath();
        } else {
            this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
            this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
        }
        this.isElevationModelAvailable = true;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.externalDEMFile != null) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.externalDEMFile.getPath());
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
        }
        absTgt.setAttributeString("DEM resampling method", this.demResamplingMethod);
        if (this.externalDEMFile != null) {
            absTgt.setAttributeDouble("external DEM no data value", this.externalDEMNoDataValue);
        }
        TerrainMaskOp.addBitmasks(this.targetProduct);
    }

    private void addSelectedBands() {
        for (Band srcBand : this.sourceProduct.getBands()) {
            if (srcBand instanceof VirtualBand) {
                ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
                continue;
            }
            Band band = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        Band targetBand = new Band(TERRAIN_MASK_NAME, 10, this.sourceImageWidth, this.sourceImageHeight);
        targetBand.setUnit("class");
        this.targetProduct.addBand(targetBand);
    }

    public static void addBitmasks(Product product) {
        for (Band band : product.getBands()) {
            if (!band.getName().contains(TERRAIN_MASK_NAME)) continue;
            String expression = band.getName() + " > 0";
            Mask mask = new Mask(band.getName() + "_detection", product.getSceneRasterWidth(), product.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
            mask.setDescription("Terrain Detection");
            mask.getImageConfig().setValue("color", (Object)Color.ORANGE);
            mask.getImageConfig().setValue("transparency", (Object)0.7);
            mask.getImageConfig().setValue("expression", (Object)expression);
            mask.setNoDataValue(0.0);
            mask.setNoDataValueUsed(true);
            product.getMaskGroup().add((ProductNode)mask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        try {
            double[][] localDEM;
            int windowSize;
            TileGeoreferencing tileGeoRef;
            boolean valid;
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            if (!(valid = DEMFactory.getLocalDEM((ElevationModel)this.dem, (double)this.demNoDataValue, (String)this.demResamplingMethod, (TileGeoreferencing)(tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, y0, w + (windowSize = this.window.getWindowSize()), h + windowSize)), (int)x0, (int)y0, (int)(w + windowSize), (int)(h + windowSize), (Product)this.sourceProduct, (boolean)true, (double[][])(localDEM = new double[h + windowSize + 2][w + windowSize + 2])))) {
                return;
            }
            ProductData targetData = targetTile.getDataBuffer();
            TileIndex targetIndex = new TileIndex(targetTile);
            double[] minMaxMean = new double[]{this.demNoDataValue, this.demNoDataValue, this.demNoDataValue};
            int ymax = y0 + h;
            int xmax = x0 + w;
            for (int y = y0; y < ymax; y += windowSize) {
                for (int x = x0; x < xmax; x += windowSize) {
                    this.getMinMaxMean(x0, y0, x, y, windowSize, localDEM, minMaxMean);
                    this.createTerrainMask(x0, y0, x, y, windowSize, xmax, ymax, minMaxMean, localDEM, targetIndex, targetData);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMinMaxMean(int x0, int y0, int x, int y, int windowSize, double[][] localDEM, double[] minMaxMean) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        int numSamples = 0;
        int maxX = x + windowSize;
        int maxY = y + windowSize;
        for (int yy = y; yy < maxY; ++yy) {
            int yIdx = yy - y0 + 1;
            for (int xx = x; xx < maxX; ++xx) {
                Double h = localDEM[yIdx][xx - x0 + 1];
                if (h.equals(this.demNoDataValue)) continue;
                if (min > h) {
                    min = h;
                }
                if (max < h) {
                    max = h;
                }
                sum += h.doubleValue();
                ++numSamples;
            }
        }
        minMaxMean[0] = min;
        minMaxMean[1] = max;
        minMaxMean[2] = sum / (double)numSamples;
    }

    private void createTerrainMask(int x0, int y0, int x, int y, int windowSize, int xmax, int ymax, double[] minMaxMean, double[][] localDEM, TileIndex targetIndex, ProductData targetData) {
        int maxX = Math.min(x + windowSize, xmax);
        int maxY = Math.min(y + windowSize, ymax);
        double elevDiff = minMaxMean[1] - minMaxMean[0];
        if (elevDiff >= this.thresholdInMeter) {
            for (int yy = y; yy < maxY; ++yy) {
                targetIndex.calculateStride(yy);
                int yIdx = yy - y0 + 1;
                for (int xx = x; xx < maxX; ++xx) {
                    Double h = localDEM[yIdx][xx - x0 + 1];
                    if (!h.equals(this.demNoDataValue)) {
                        targetData.setElemIntAt(targetIndex.getIndex(xx), 1);
                        continue;
                    }
                    targetData.setElemIntAt(targetIndex.getIndex(xx), 0);
                }
            }
        } else {
            for (int yy = y; yy < maxY; ++yy) {
                targetIndex.calculateStride(yy);
                for (int xx = x; xx < maxX; ++xx) {
                    targetData.setElemIntAt(targetIndex.getIndex(xx), 0);
                }
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TerrainMaskOp.class);
        }
    }
}

