/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import java.util.Iterator;
import org.esa.snap.cluster.Roi;
import org.esa.snap.core.gpf.Tile;

class PixelIter {
    private final Tile[] tiles;
    private final Iterator<Tile.Pos> iterator;
    private final Roi roi;

    PixelIter(Tile[] tiles, Roi roi) {
        this.tiles = (Tile[])tiles.clone();
        this.roi = roi;
        this.iterator = tiles[0].iterator();
    }

    double[] next(double[] samples) {
        while (this.iterator.hasNext()) {
            Tile.Pos nextPos = this.iterator.next();
            if (this.roi != null && !this.roi.contains(nextPos.x, nextPos.y)) continue;
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = this.tiles[i].getSampleDouble(nextPos.x, nextPos.y);
            }
            return samples;
        }
        return null;
    }
}

