/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.stream.Stream;
import org.esa.snap.cluster.ClusterMetaDataUtils;
import org.esa.snap.cluster.KMeansClusterSet;
import org.esa.snap.cluster.KMeansClusterer;
import org.esa.snap.cluster.PixelIter;
import org.esa.snap.cluster.RandomSceneIter;
import org.esa.snap.cluster.Roi;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;

@OperatorMetadata(alias="KMeansClusterAnalysis", category="Raster/Classification/Unsupervised Classification", version="1.0", authors="Ralf Quast, Marco Zuehlke", copyright="(c) 2008 by Brockmann Consult", description="Performs a K-Means cluster analysis.")
public class KMeansClusterOp
extends Operator {
    private static final int NO_DATA_VALUE = 255;
    @SourceProduct(alias="source", label="Source product", description="The source product.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(label="Number of clusters", description="Number of clusters", defaultValue="14", interval="(0,100]")
    private int clusterCount;
    @Parameter(label="Number of iterations", description="Number of iterations", defaultValue="30", interval="(0,10000]")
    private int iterationCount;
    @Parameter(label="Random seed", defaultValue="31415", description="Seed for the random generator, used for initialising the algorithm.")
    private int randomSeed;
    @Parameter(label="Source band names", description="The names of the bands being used for the cluster analysis.", rasterDataNodeType=Band.class)
    private String[] sourceBandNames;
    @Parameter(label="ROI-mask", description="The name of the ROI-Mask that should be used.", defaultValue="", rasterDataNodeType=Mask.class)
    private String roiMaskName;
    private transient Roi roi;
    private transient Band[] sourceBands;
    private transient Band clusterMapBand;
    private transient KMeansClusterSet clusterSet;
    private transient MetadataElement clusterAnalysis;

    public void initialize() throws OperatorException {
        Band[] sourceBands = this.collectSourceBands();
        if (this.roiMaskName != null) {
            this.ensureSingleRasterSize((RasterDataNode[])Stream.concat(Arrays.stream(sourceBands), Stream.of(this.sourceProduct.getMaskGroup().get(this.roiMaskName))).toArray(Band[]::new));
        } else {
            this.ensureSingleRasterSize((RasterDataNode[])sourceBands);
        }
        int width = sourceBands[0].getRasterWidth();
        int height = sourceBands[0].getRasterHeight();
        String name = this.sourceProduct.getName() + "_CLUSTERS";
        String type = this.sourceProduct.getProductType() + "_CLUSTERS";
        this.targetProduct = new Product(name, type, width, height);
        if (this.sourceProduct.getSceneRasterSize().equals(sourceBands[0].getRasterSize())) {
            ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
            ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        }
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.clusterMapBand = new Band("class_indices", 20, width, height);
        this.clusterMapBand.setDescription("Class_indices");
        this.clusterMapBand.setNoDataValue(255.0);
        this.clusterMapBand.setNoDataValueUsed(true);
        this.targetProduct.addBand(this.clusterMapBand);
        IndexCoding indexCoding = new IndexCoding("Cluster_classes");
        for (int i = 0; i < this.clusterCount; ++i) {
            indexCoding.addIndex("class_" + (i + 1), i, "Cluster " + (i + 1));
        }
        this.targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        this.clusterMapBand.setSampleCoding((SampleCoding)indexCoding);
        this.clusterAnalysis = new MetadataElement("Cluster_Analysis");
        this.targetProduct.getMetadataRoot().addElement(this.clusterAnalysis);
        this.setTargetProduct(this.targetProduct);
    }

    private Band[] collectSourceBands() {
        if (this.sourceBandNames != null && this.sourceBandNames.length > 0) {
            this.sourceBands = new Band[this.sourceBandNames.length];
            for (int i = 0; i < this.sourceBandNames.length; ++i) {
                Band sourceBand = this.sourceProduct.getBand(this.sourceBandNames[i]);
                if (sourceBand == null) {
                    throw new OperatorException("Source band not found: " + this.sourceBandNames[i]);
                }
                this.sourceBands[i] = sourceBand;
            }
        } else {
            this.sourceBands = this.sourceProduct.getBands();
        }
        return this.sourceBands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        pm.beginTask("Computing clusters...", 10);
        try {
            KMeansClusterSet theClusterSet = this.getClusterSet(SubProgressMonitor.create((ProgressMonitor)pm, (int)9));
            Rectangle targetRectangle = targetTile.getRectangle();
            Tile[] sourceTiles = new Tile[this.sourceBands.length];
            for (int i = 0; i < sourceTiles.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)this.sourceBands[i], targetRectangle);
            }
            double[] point = new double[sourceTiles.length];
            for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                for (int x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    try {
                        if (this.roi.contains(x, y)) {
                            for (int i = 0; i < sourceTiles.length; ++i) {
                                point[i] = sourceTiles[i].getSampleDouble(x, y);
                            }
                            targetTile.setSample(x, y, theClusterSet.getMembership(point));
                            continue;
                        }
                        targetTile.setSample(x, y, 255);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                }
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized KMeansClusterSet getClusterSet(ProgressMonitor pm) {
        if (this.clusterSet == null) {
            Rectangle[] tileRectangles = this.getAllTileRectangles();
            pm.beginTask("Extracting data points...", tileRectangles.length * this.iterationCount * 2 + 2);
            try {
                this.roi = new Roi(this.sourceProduct, this.sourceBands, this.roiMaskName);
                pm.worked(1);
                KMeansClusterer clusterer = this.createClusterer();
                pm.worked(1);
                boolean endIteration = false;
                for (int i = 0; i < this.iterationCount && !endIteration; ++i) {
                    clusterer.startIteration();
                    for (Rectangle rectangle : tileRectangles) {
                        this.checkForCancellation();
                        PixelIter pixelIterr = this.createPixelIter(rectangle, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                        clusterer.iterateTile(pixelIterr);
                        pm.worked(1);
                    }
                    endIteration = clusterer.endIteration();
                }
                this.clusterSet = clusterer.getClusters();
                ClusterMetaDataUtils.addCenterToIndexCoding(this.clusterMapBand.getIndexCoding(), this.sourceBands, this.clusterSet.getMeans());
                ClusterMetaDataUtils.addCenterToMetadata(this.clusterAnalysis, this.sourceBands, this.clusterSet.getMeans());
            }
            finally {
                pm.done();
            }
        }
        return this.clusterSet;
    }

    private KMeansClusterer createClusterer() {
        KMeansClusterer clusterer = new KMeansClusterer(this.clusterCount, this.sourceBands.length);
        RandomSceneIter randomSceneIter = new RandomSceneIter(this, (RasterDataNode[])this.sourceBands, this.roi, this.randomSeed);
        if (randomSceneIter.getRoiMemberCount() < this.clusterCount) {
            throw new OperatorException("The combination of ROI and valid pixel masks contain " + randomSceneIter.getRoiMemberCount() + " pixel. These are too few to initialize the clustering.");
        }
        clusterer.initialize(randomSceneIter);
        return clusterer;
    }

    private Rectangle[] getAllTileRectangles() {
        Dimension tileSize = ImageManager.getPreferredTileSize((Product)this.sourceProduct);
        int rasterHeight = this.sourceProduct.getSceneRasterHeight();
        int rasterWidth = this.sourceProduct.getSceneRasterWidth();
        Rectangle boundary = new Rectangle(rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(tileX * tileSize.width, tileY * tileSize.height, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PixelIter createPixelIter(Rectangle rectangle, ProgressMonitor pm) {
        Tile[] sourceTiles = new Tile[this.sourceBands.length];
        try {
            pm.beginTask("Extracting data points...", this.sourceBands.length);
            for (int i = 0; i < this.sourceBands.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)this.sourceBands[i], rectangle);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return new PixelIter(sourceTiles, this.roi);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(KMeansClusterOp.class);
        }
    }
}

