/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import de.gkss.hs.datev2004.FirstMoments;
import de.gkss.hs.datev2004.General;

public class RecMom {
    int dim;
    public long npoints;
    public double swgt;
    public double avg;
    public double var;
    double[] av;
    double[] cov;

    public RecMom(int dim) {
        if (dim < 1) {
            General.error("RecMom: dim=" + dim);
        }
        this.dim = dim;
        this.npoints = 0L;
        this.swgt = 0.0;
        if (dim == 1) {
            this.avg = 0.0;
            this.var = 0.0;
        } else {
            this.av = new double[dim];
            this.cov = new double[dim * (dim + 1) / 2];
            int k = 0;
            for (int i = 0; i < dim; ++i) {
                this.av[i] = 0.0;
                for (int j = 0; j < i + 1; ++j) {
                    this.cov[k] = 0.0;
                    ++k;
                }
            }
        }
    }

    public void recalc(double p1dim, double wgt) {
        ++this.npoints;
        double wold = this.swgt;
        this.swgt += wgt;
        this.var = wold * this.var / this.swgt + wold * wgt / (this.swgt * this.swgt) * (p1dim * p1dim + this.avg * this.avg - 2.0 * p1dim * this.avg);
        this.avg = (wold * this.avg + wgt * p1dim) / this.swgt;
    }

    public void recalc(double[] pt, double wgt) {
        int i;
        if (this.dim != pt.length) {
            General.error("RecMom: dim's=" + this.dim + " " + pt.length);
        }
        ++this.npoints;
        double wold = this.swgt;
        this.swgt += wgt;
        int k = 0;
        for (i = 0; i < this.dim; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                this.cov[k] = wold * this.cov[k] / this.swgt + wold * wgt / (this.swgt * this.swgt) * (pt[i] * pt[j] + this.av[i] * this.av[j] - pt[i] * this.av[j] - this.av[i] * pt[j]);
                ++k;
            }
        }
        for (i = 0; i < this.dim; ++i) {
            this.av[i] = (wold * this.av[i] + wgt * pt[i]) / this.swgt;
        }
    }

    public FirstMoments get() {
        FirstMoments res = new FirstMoments(this.dim);
        res.npoints = this.npoints;
        res.swgt = this.swgt;
        if (this.dim == 1) {
            res.avg[0] = this.avg;
            res.cov[0][0] = this.var;
        } else {
            int k = 0;
            for (int i = 0; i < this.dim; ++i) {
                res.avg[i] = this.av[i];
                for (int j = 0; j < i + 1; ++j) {
                    res.cov[i][j] = this.cov[k];
                    res.cov[j][i] = this.cov[k];
                    ++k;
                }
            }
        }
        return res;
    }
}

