/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import java.util.Random;

public final class General {
    public static void error(String msg) {
        throw new IllegalStateException(msg);
    }

    public static double eucliddist(double[] v1, double[] v2) {
        double res = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            res += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return Math.sqrt(res);
    }

    public static int indmin(double[] a) {
        if (a.length == 0) {
            return -1;
        }
        int res = 0;
        double min = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            res = i;
        }
        return res;
    }

    public static int indmax(double[] a) {
        if (a.length == 0) {
            return -1;
        }
        int res = 0;
        double max = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
            res = i;
        }
        return res;
    }

    public static int indmax(long[] a) {
        if (a.length == 0) {
            return -1;
        }
        int res = 0;
        long max = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
            res = i;
        }
        return res;
    }

    public static double[] vector_rand(int dim, Random gen) {
        int i;
        double[] res = new double[dim];
        double sum = 0.0;
        for (i = 0; i < dim; ++i) {
            res[i] = gen.nextGaussian();
            sum += res[i] * res[i];
        }
        sum = 1.0 / Math.sqrt(sum);
        i = 0;
        while (i < dim) {
            int n = i++;
            res[n] = res[n] * sum;
        }
        return res;
    }

    public static double[][] plane_rand(int dim, Random gen) {
        int i;
        if (dim < 3) {
            General.error("plane_rand called with dim=" + dim);
        }
        double[][] res = new double[2][dim];
        res[0] = General.vector_rand(dim, gen);
        boolean collinear = true;
        double sum = 0.0;
        while (collinear) {
            res[1] = General.vector_rand(dim, gen);
            sum = 0.0;
            for (i = 0; i < dim; ++i) {
                sum += res[0][i] * res[1][i];
            }
            if (!(sum * sum < 0.98)) continue;
            collinear = false;
        }
        double b = Math.sqrt(1.0 / (1.0 - sum * sum));
        double a = -b * sum;
        for (i = 0; i < dim; ++i) {
            res[1][i] = a * res[0][i] + b * res[1][i];
        }
        return res;
    }
}

