/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

public class FirstMoments {
    public int dim;
    public long npoints = 0L;
    public double swgt;
    public double[] avg;
    public double[][] cov;

    public FirstMoments(int dim) {
        this.dim = dim;
        this.swgt = 0.0;
        this.avg = new double[dim];
        this.cov = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            this.avg[i] = 0.0;
            for (int j = 0; j < dim; ++j) {
                this.cov[i][j] = 0.0;
            }
        }
    }

    public FirstMoments combine(FirstMoments that) {
        if (this.dim != that.dim) {
            throw new IllegalArgumentException("FirstMoments.combine: dim's differ: " + this.dim + " " + that.dim);
        }
        FirstMoments res = new FirstMoments(this.dim);
        res.npoints = this.npoints + that.npoints;
        res.swgt = this.swgt + that.swgt;
        double rho = this.swgt / res.swgt;
        double omr = 1.0 - rho;
        for (int i = 0; i < this.dim; ++i) {
            res.avg[i] = rho * this.avg[i] + omr * that.avg[i];
            for (int j = 0; j < this.dim; ++j) {
                res.cov[i][j] = rho * this.cov[i][j] + omr * that.cov[i][j] + rho * omr * (this.avg[i] - that.avg[i]) * (this.avg[j] - that.avg[j]);
            }
        }
        return res;
    }
}

