/*
 * Decompiled with CFR 0.152.
 */
package de.gkss.hs.datev2004;

import Jama.Matrix;
import de.gkss.hs.datev2004.FirstMoments;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DataSet {
    public int npoints;
    public int dim;
    public double[][] pt;
    public double[] wgt;
    public short[] group;
    private int np;

    public DataSet(int npoints, int dim) {
        this.npoints = npoints;
        this.dim = dim;
        this.pt = new double[npoints][dim];
        this.wgt = new double[npoints];
        this.group = new short[npoints];
        for (int i = 0; i < this.npoints; ++i) {
            this.group[i] = 0;
            this.wgt[i] = 1.0;
        }
        this.np = 0;
    }

    public DataSet(String filename) throws IOException {
        try {
            double[][] df;
            int dimension;
            int weighted;
            try (BufferedReader in = new BufferedReader(new FileReader(filename));){
                String eing = "";
                while (!eing.equals("$")) {
                    eing = in.readLine();
                }
                eing = in.readLine();
                StringTokenizer stok = new StringTokenizer(eing);
                weighted = Integer.valueOf(stok.nextToken());
                dimension = Integer.valueOf(stok.nextToken());
                df = Matrix.read((BufferedReader)in).getArray();
            }
            this.np = this.npoints = df.length;
            this.dim = df[0].length - 1 - weighted;
            if (this.dim != dimension) {
                throw new IOException("bad mdda file" + filename);
            }
            this.pt = new double[this.npoints][this.dim];
            this.wgt = new double[this.npoints];
            this.group = new short[this.npoints];
            for (int n = 0; n < this.npoints; ++n) {
                if (weighted == 0) {
                    System.arraycopy(df[n], 1, this.pt[n], 0, this.dim);
                    this.wgt[n] = 1.0;
                    continue;
                }
                System.arraycopy(df[n], 2, this.pt[n], 0, this.dim);
                this.wgt[n] = df[n][1];
            }
        }
        catch (NoSuchElementException e) {
            throw new IOException("file has wrong structure ");
        }
        catch (NumberFormatException e) {
            throw new IOException("bad number format " + e);
        }
        catch (FileNotFoundException e) {
            throw new IOException("file not found " + e);
        }
    }

    public void add(double[] pt) {
        if (this.np == this.npoints) {
            throw new IllegalArgumentException("DataSet.add: to many points. " + this.npoints + " were declared.");
        }
        if (this.dim != pt.length) {
            throw new IllegalArgumentException("DataSet.add: bad dimension" + pt.length + ". dim of DataSet=" + this.dim);
        }
        System.arraycopy(pt, 0, this.pt[this.np], 0, this.dim);
        this.wgt[this.np] = 1.0;
        this.group[this.np] = 0;
        ++this.np;
    }

    public int[] indices(short group) {
        int times = 0;
        for (int i = 0; i < this.npoints; ++i) {
            if (group != this.group[i]) continue;
            ++times;
        }
        int[] res = new int[times];
        times = 0;
        for (int i = 0; i < this.npoints; ++i) {
            if (group != this.group[i]) continue;
            res[times] = i;
            ++times;
        }
        return res;
    }

    public short[] groups() {
        short[] gr = new short[this.npoints];
        short[] gn = new short[this.npoints];
        System.arraycopy(this.group, 0, gr, 0, this.npoints);
        boolean ready = false;
        int next = 0;
        int ngr = 0;
        block0: while (!ready) {
            int i;
            short extrgr;
            gn[ngr] = extrgr = gr[next];
            ++ngr;
            for (i = 0; i < this.npoints; ++i) {
                if (gr[i] != extrgr) continue;
                gr[i] = -1;
            }
            ready = true;
            for (i = 0; i < this.npoints; ++i) {
                if (gr[i] == -1) continue;
                next = i;
                ready = false;
                continue block0;
            }
        }
        short[] res = new short[ngr];
        System.arraycopy(gn, 0, res, 0, ngr);
        return res;
    }

    public FirstMoments[] groupMoments() {
        int i;
        int gg;
        int g;
        int n;
        int g2;
        short[] gr = this.groups();
        FirstMoments[] res = new FirstMoments[gr.length];
        for (g2 = 0; g2 < gr.length; ++g2) {
            res[g2] = new FirstMoments(this.dim);
        }
        for (n = 0; n < this.npoints; ++n) {
            g = -1;
            for (gg = 0; gg < gr.length; ++gg) {
                if (this.group[n] != gr[gg]) continue;
                g = gg;
                break;
            }
            ++res[g].npoints;
            res[g].swgt += this.wgt[n];
            for (i = 0; i < this.dim; ++i) {
                int n2 = i;
                res[g].avg[n2] = res[g].avg[n2] + this.wgt[n] * this.pt[n][i];
            }
        }
        for (g2 = 0; g2 < gr.length; ++g2) {
            int d = 0;
            while (d < this.dim) {
                int n3 = d++;
                res[g2].avg[n3] = res[g2].avg[n3] / res[g2].swgt;
            }
        }
        for (n = 0; n < this.npoints; ++n) {
            g = -1;
            for (gg = 0; gg < gr.length; ++gg) {
                if (this.group[n] != gr[gg]) continue;
                g = gg;
                break;
            }
            for (i = 0; i < this.dim; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    double[] dArray = res[g].cov[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + this.wgt[n] * (this.pt[n][i] - res[g].avg[i]) * (this.pt[n][j] - res[g].avg[j]);
                }
            }
        }
        for (g2 = 0; g2 < gr.length; ++g2) {
            for (int i2 = 0; i2 < this.dim; ++i2) {
                int j = 0;
                while (j < this.dim) {
                    double[] dArray = res[g2].cov[i2];
                    int n5 = j++;
                    dArray[n5] = dArray[n5] / res[g2].swgt;
                }
            }
        }
        return res;
    }
}

